/*
 * X-mame main-routine
 */

#define __MAIN_C_
#include "xmame.h"
#include "sound.h"

/* put here anything you need to do when the program is started. Return 0 if */
/* initialization was successful, nonzero otherwise. */
int osd_init(void)
{
	/* now invoice system-dependent initialization */
#ifdef MAME_NET
	if (osd_net_init()      !=OSD_OK) return OSD_NOT_OK;
#endif	
	if (osd_input_initpre() !=OSD_OK) return OSD_NOT_OK;
	if (osd_debug_init()    !=OSD_OK) return OSD_NOT_OK;
	
	return OSD_OK;
}

/*
 * Cleanup routines to be executed when the program is terminated.
 */
void osd_exit (void)
{
#ifdef MAME_NET
	osd_net_close();
#endif
	osd_input_close();
	osd_audio_close();
	osd_debug_close();
}


int main (int argc, char **argv)
{
	int res;
	
	/* some display methods need to do some stuff with root rights */
	if (sysdep_init()!= OSD_OK) exit(OSD_NOT_OK);
	
	/* to be absolutly safe force giving up root rights here in case
	   a display method doesn't */
	if(setuid(getuid()))
	{
		perror("setuid");
		sysdep_close();
		return OSD_NOT_OK;
	}
	
        /* Set the title, now auto build from defines from the makefile */
        sprintf(title,"%s (%s) version %s", NAME, DISPLAY_METHOD, VERSION);

	/* parse configuration file and environment */
	if ((res = get_config(argc, argv)) != 1234) goto leave;
	
	/* this could change the samplerate so has to be done here and not
	   in osd_init ! */
	if ((res = osd_audio_init()) != OSD_OK) goto leave;

	/* Set the samplerate to 0 if sound is disabled,
	   this should notify mame not to "render" it (speed improvement) */
	if (play_sound==0) 
	{
	   if (fake_sound)
	      options.samplerate=8000;
	   else
	   {
	      options.samplerate=0;
	      options.no_fm=FALSE;
	   }
	}
	
        options.samplebits = sound_8bit? 8:16;
	
	/* go for it */
	res = run_game (game_index);

leave:
	sysdep_close();

	/* close open files */
	if (stdout_file && stdout_file != stdout) fclose(stdout_file);
	if (stderr_file && stderr_file != stderr) fclose(stderr_file);
	if (options.errorlog) fclose (options.errorlog);
	if (options.playback) osd_fclose (options.playback);
	if (options.record)   osd_fclose (options.record);

	exit(res);
}
