#ifndef __DEVICES_H_
#define __DEVICES_H_

#ifdef __DEVICES_C_
#define EXTERN
#else
#define EXTERN extern
#endif

#define JOY 8
#define JOY_BUTTONS 16
#define JOY_AXIS 16
#define JOY_DIRS 2
#define JOY_LIST_AXIS_ENTRIES (JOY_AXIS * JOY_DIRS)
#define JOY_LIST_TOTAL_ENTRIES (JOY_LIST_AXIS_ENTRIES + JOY_BUTTONS)
#define JOY_LIST_LEN (JOY * JOY_LIST_TOTAL_ENTRIES)
#define JOY_NAME_LEN 20

#define JOY_BUTTON_CODE(joy, button) \
 (joy * JOY_LIST_TOTAL_ENTRIES + JOY_LIST_AXIS_ENTRIES + button)
 
#define JOY_AXIS_CODE(joy, axis, dir) \
 (joy * JOY_LIST_TOTAL_ENTRIES + JOY_DIRS * axis + dir)
 
#define JOY_GET_JOY(code) \
 (code / JOY_LIST_TOTAL_ENTRIES)
 
#define JOY_IS_AXIS(code) \
 ((code % JOY_LIST_TOTAL_ENTRIES) <  JOY_LIST_AXIS_ENTRIES)
 
#define JOY_IS_BUTTON(code) \
 ((code % JOY_LIST_TOTAL_ENTRIES) >= JOY_LIST_AXIS_ENTRIES)
 
#define JOY_GET_AXIS(code) \
 ((code % JOY_LIST_TOTAL_ENTRIES) / JOY_DIRS)
 
#define JOY_GET_DIR(code) \
 ((code % JOY_LIST_TOTAL_ENTRIES) % JOY_DIRS)
 
#define JOY_GET_BUTTON(code) \
 ((code % JOY_LIST_TOTAL_ENTRIES) -  JOY_LIST_AXIS_ENTRIES)


/*** variables ***/

struct axisdata_struct
{
   /* current value */
   int val;
   /* calibration data */
   int min;
   int center;
   int max;
   /* boolean values */
   int dirs[JOY_DIRS];
};

struct joydata_struct
{
   int fd;
   int num_axis;
   int num_buttons;
   struct axisdata_struct axis[JOY_AXIS];
   int buttons[JOY_BUTTONS];
};

struct mousedata_struct
{
   int buttons[JOY_BUTTONS];
   int deltas[JOY_AXIS];
   int analogjoy_emus[JOY_AXIS];
};

EXTERN struct joydata_struct joy_data[JOY];
EXTERN struct mousedata_struct mouse_data[JOY];
EXTERN void (*joy_poll_func) (void);

/*** prototypes ***/
void joy_evaluate_moves(void);
void joy_i386_init(void);
void joy_pad_init(void);
void joy_x11_init(void);

#undef EXTERN
#endif
