
/* Copyright (c) Miguel Angel Sepulveda, 1998. */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#include <stdlib.h>  
#include <math.h>  
#include <stdlib.h>  
#include "Gd_function.h"  
 
 
/********************************************************************\  
*         GdTableFunc1D        M E M B E R S  
\********************************************************************/  
GdTableFunc1D::GdTableFunc1D(){  
  table = NULL;  
};  
 
GdTableFunc1D::GdTableFunc1D(GDfunc1D f, int points, double minimum,  
                             double maximum){  
  xmin = minimum;  
  xmax = maximum;  
  numberPoints = points;  
  DeltaX = (xmax - xmin)/(numberPoints-1);  
	  
  table = new double[points];  
  double x = xmin;  
  for (int i = 0; i < numberPoints; i++){  
    table[i] = f(x);  
    x += DeltaX;  
  };  
};  
 
GdTableFunc1D::~GdTableFunc1D(){  
  delete[] table;  
};  
 
ostream& operator<<(ostream &cs, const GdTableFunc1D &tfun){  
  double x = tfun.xmin;  
  for (int i = 0; i < tfun.numberPoints; i++){  
    cs << x << " " << tfun.table[i] << endl;  
    x += tfun.DeltaX;  
  };  
  return cs;  
};  
 
double GdTableFunc1D::evaluate(double x) const{  
  //    Return 0 for x outside domain  
  if(x < xmin || x > xmax ) return 0.0;  
	  
  // Interpolation of second order  
  int index  = int((x - xmin)/DeltaX);  
  if(index+2 >= numberPoints) index = numberPoints -3;  
  double xk = xmin + index * DeltaX;  
  double xi = (x -xk)/DeltaX;  
  double dk  = table[index + 1] - table[index];  
  double dk1 = table[index + 2] - table[index + 1];  
  double d2k = dk1 - dk;  
  double f = table[index] + xi * (dk + 0.5 * (xi -1.0) * d2k);   
  return f;  
};  
 
 
void GdTableFunc1D::bounds(double &min, double &max){  
  // Guess upper and lower bounds  
  min = table[0];  
  max = table[0];  
	  
  // Search bounds in table  
  for (int i = 1; i < numberPoints; i++){  
    if (min > table[i]) min = table[i];  
    if (max < table[i]) max = table[i];  
  };  
};  
