#! /bin/sh
":";exec ../gsi/gsi -f $0 $*

;==============================================================================

; file: "igsc.scm"

; Copyright (C) 1994-1998 by Marc Feeley, All Rights Reserved.

;------------------------------------------------------------------------------

(define c#absent-object
  (string->symbol "#<absent>")) ; (##type-cast -6 2)

(define ##compilation-options '(check))

(##include "../gsc/fixnum.scm")

;------------------------------------------------------------------------------

(define modules '(
"_utils"
"_source"
"_parms"
"_env"
"_ptree1"
"_ptree2"
"_gvm"
"_back"
"_front"
"_prims"
"_t-c-1"
"_t-c-2"
"_t-c-3"
"gsc"
))

(define (load-from-gsc file)
  (##namespace ("" load))
  (load (string-append "../gsc/" file ".scm")))

(eval '(##define-macro (include file)
        `(##include ,(string-append "../gsc/" file))))

;------------------------------------------------------------------------------

(load-from-gsc "_host")

(set! **main-readtable
  (##list->vector (##vector->list **main-readtable)))

(for-each load-from-gsc modules)

;------------------------------------------------------------------------------
