package biss.awt;

import biss.Command;
import biss.CommandQueue;
import java.awt.Component;

/**
 * command class to asynchronously set the focus. Some platforms don't like the
 * focus to be changed during sync processing of GOT_FOCUS events. If there is a need
 * to control the focus inside of toplevel windows, it has to be done async by
 * means of this command and the CommandQueue
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class SetFocusCmd
  implements Command
{
	Component Target;
	int Count;

public SetFocusCmd ( Component target ) {
	Target = target;
	Count = 5;

	Target.requestFocus();
}

public boolean execute () {
	if ( Target.isShowing() && (GUIHandler.currentFocusOwner() != Target) ) {
		Awt.DefToolkit.sync();
		Target.requestFocus();

		if ( --Count > 0 ) {
			try { Thread.sleep( 50); } catch ( Exception x ) {}
			CommandQueue.append( this);
		}
	}

	return true;
}
}
