package biss.awt;

import biss.awt.GraphicsLib;
import java.awt.Color;
import java.awt.Graphics;

/**
 * general border draw support for biss.awt classes
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class Border
{
	final public static int BS_INSET = 5;
	final public static int BS_NONE = 0;
	final public static int BS_OUTSET = 4;
	final public static int BS_OUTSTEP = 3;
	final public static int BS_PLAIN = 1;
	final public static int BS_STEP = 2;
	protected int Ext;
	protected int Style;
	final public static int BS_CARVED = 6;

public Border() {
	setBorder( BS_NONE);
}

protected void blankBorder( Graphics g, int x, int y, int w, int h, Color clrBack){
	if ( Style > BS_NONE)
		GraphicsLib.drawBox( g, x, y, w, h, Ext, clrBack);
}

protected void drawBorder( Graphics g, int w, int h){
	drawBorder( g, 0, 0, w, h);
}

protected void drawBorder( Graphics g, int x, int y, int w, int h){
	switch( Style){
	case BS_NONE:
		break;
	case BS_PLAIN:
		g.setColor( Color.black);
		g.drawRect( x, y, w-1, h-1);
		break;
	case BS_STEP:
		GraphicsLib.paintInstepBox( g, x, y, w, h, null);
		break;
	case BS_OUTSTEP:
		GraphicsLib.paint3dBox( g, x, y, w, h, false, null);
		break;
	case BS_OUTSET:
		GraphicsLib.paint3dBox( g, x, y, w, h, false, null);
		break;
	case BS_INSET:
		GraphicsLib.paint3dBox( g, x, y, w, h, true, null);
		break;
	case BS_CARVED:
		GraphicsLib.paintCarvedBox( g, x, y, w, h);
		break;
	}
}

public void setBorder( int bs) {  
	switch( bs){
	case BS_NONE:
		Style = bs;
		Ext   = 0;
		break;
	case BS_STEP:
		Style = bs;
		Ext   = Awt.BorderWidth;
		break;
	case BS_OUTSTEP:
		Style = bs;
		Ext   = Awt.BorderWidth;
		break;
	case BS_OUTSET:
	case BS_INSET:
		Style = bs;
		Ext   = Awt.BorderWidth;
		break;
	case BS_CARVED:
		Style = bs;
		Ext = 2;
		break;
	default:
		Style = BS_PLAIN;
		Ext   = 1;
	}
}
}
