static char qmod_rcsid[]="qmod.c,v 1.2 1994/11/28 16:55:39 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *
 *  qmod.c,v
 * Revision 1.2  1994/11/28  16:55:39  kerce
 * *** empty log message ***
 *
 * Revision 1.3  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.2  1994/08/21  02:59:18  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:02  raju
 * Initial revision
 *
 *
 **********************************************************/
#include "globals.h"

static Widget           qmod_popup;
static Widget           widget_qmodrc;
static Widget           widget_qmodlabel;
static Widget           widget_qmodframe;
static Widget           widget_qmodmenu;
static Widget           widget_qmodmain;
static Widget           widget_qmodexec;
static Widget           widget_qmodclear;
static Widget           widget_qmodclose;
static Widget           widget_qmodseparator;
static Widget           widget_qmodopt;

struct optionstruct qmodmenu[]={
  0,"Cell Name                ","-cell",MENUTYPE,NULL,NULL,
  0,"Help                        ","-help",FLAGTYPE,"False",NULL,
  0,"Verify                      ","-verify",FLAGTYPE,"False",NULL,
  0,"Force Action                ","-f",FLAGTYPE,"False",NULL,
  0,"Disable                     ","-d",RADIOTYPE,"False",NULL,
  0,"Enable                      ","-e",RADIOTYPE,"False",NULL,
  0,"Suspend                     ","-s",RADIOTYPE,"False",NULL,
  0,"Unsuspend                   ","-us",RADIOTYPE,"False",NULL,
  0,"Resource List               ","-l",INPUTTYPE,NULL,NULL,
  0,"Destination List         ",NULL,MENUTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};
/*
  0,"Suspend On Completion       ","-soc",RADIOTYPE,"False",NULL,
  0,"Cancel Suspend On Completion","-xsoc",RADIOTYPE,"False",NULL,
*/


/***********************************************************
 * pb_qmodexec - Activate callback for exec
 */
XtCallbackProc pb_qmodexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  buildcommand(QMOD_BINARY,qmodmenu,0);
  sleep(1);
  UnMapIconWin ();
  refreshicons();
  MapIconWin ();
}


/***********************************************************
 * pb_qmodclear - Activate callback for clear
 */
XtCallbackProc pb_qmodclear(Widget w, caddr_t client_data, caddr_t call_data)
{
  int n=0;

  clearsubmenu(qmodmenu);
  QmonTextSetString(qmodmenu[0].widgetid ,current_cell );
  QmonTextSetString(qmodmenu[8].widgetid ,current_resource );
  QmonTextSetString(qmodmenu[9].widgetid ,current_destination );
}


/***********************************************************
 * pb_qmodclose - Activate callback for close
 */
XtCallbackProc pb_qmodclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closemainmenuwin();
}


/***********************************************************
 * create_qmod_dialog - Create widgets used for the qmod menu
 */
int create_qmod_dialog(Widget w,XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        qmod_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  qmodmenu[0].list = cell_list;
  qmodmenu[9].list = queue_list;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  qmod_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  qmod_form = XtCreateManagedWidget("form", formWidgetClass, qmod_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_qmodlabel=
        XtCreateManagedWidget("Qmod",labelWidgetClass,qmod_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_qmodlabel); ii++;
  widget_qmodmain=XtCreateManagedWidget("box",formWidgetClass,qmod_form,
                                        args,ii);

 exec=QmonAddButtonN(widget_qmodmain,NULL,"Exec",(XtCallbackProc)pb_qmodexec,NULL);
 clear=QmonAddButtonN(widget_qmodmain,exec,"Clear",(XtCallbackProc)pb_qmodclear,NULL);
 close=QmonAddButtonN(widget_qmodmain,clear,"Close",(XtCallbackProc)pb_qmodclose,NULL);

  widget_qmodopt=createmenuoptions(qmod_form,widget_qmodmain,qmodmenu,(XtCallbackProc)NULL);
  
}


/***********************************************************
 * openwidget_qmod - Open the qmod menu
 */
int openwidget_qmod()
{
  pb_qmodclear(NULL,NULL,NULL);
  XtPopup(qmod_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_qmod - Close the qmod menu
 */
int closewidget_qmod()
{
  XtPopdown(qmod_popup);
}
