static char dqs_sec_rcsid[]="$Id: dqs_sec.c,v 1.4 1998/10/21 14:42:01 green Exp $";

/*----------------------------------------------------
 * dqs_sec.c Tom Green Mon Jan 31 10:43:01 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_sec.c,v $
 * Revision 1.4  1998/10/21 14:42:01  green
 * Red Hat Alpha port - ADDRLEN incorporated
 *
 * Revision 1.3  1998/10/13 15:08:49  green
 * Solaris 2.6 support - hopefully, as I don't have access to one...
 *
 * Revision 1.2  1998/10/13 14:23:13  green
 * Patching Solaris defines - shooting in the dark here as I don't have access to
 * a Solaris 2.5 box
 *
 * Revision 1.1.1.1  1998/08/18 14:39:13  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.2  1998/04/27 14:54:15  decker
 * Added patch, from Drake, concerning testing dereferenced value.
 *
 * Revision 1.1.1.1  1997/04/10 15:10:34  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.22  1996/11/20 23:04:17  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.21  1996/06/27  01:56:00  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.20  1996/03/22  04:21:08  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.19  1996/03/12  17:12:35  nrl
 * removed aborts and replaced with an error messaging scheme
 * to send email to the dqs adminsitrator and wait for
 * actions by that administrator
 *
 * Revision 3.18  1995/05/29  18:08:55  nrl
 * More solaris stuff GAGGHH had to differentiate more cases of
 * solaris2.3 and solaris2.4 stuff
 *
 * Revision 3.17  1995/05/26  19:07:42  nrl
 * Cleaned up signal handling and the notify option with the
 * help of Ron Lee.
 *
 * Revision 3.16  1995/05/14  18:28:57  nrl
 * Plugged one hole in dqs_execd and qmaster handhsaking...
 * added gethostbyname calls to overcome problems with some
 * systems
 *
 * Revision 3.15  1995/03/14  22:21:23  nrl
 * Error messages for gid less than minimum were backward
 *
 * Revision 3.14  1995/03/05  03:47:34  nrl
 * Included Axel Brandes job scheduling mechanism to keep one
 * user from hawging the queue.
 *
 * Revision 3.13  1995/02/25  17:08:11  nrl
 * Changed dqs_locate+host call
 *
 * Revision 3.12  1995/02/24  23:36:23  nrl
 * Changed all Host lookups to use dqs_locate_host subroutine,
 * and changed that routine to look for the "registered host name"
 *
 * Revision 3.11  1995/02/15  23:23:36  nrl
 * The primary name used for hostname in all handshaking and
 * in the hostshash and queue stuff is now the "official"
 * name delivered by gethostbyname. This should eliminate name
 * confusion between queues and hosts reporting in
 *
 * Revision 3.10  1995/02/12  21:55:45  nrl
 * plugged memory leak due to tid processing
 *
 * Revision 3.9  1994/12/21  19:23:43  green
 * sprintf()s changed to strcpy()s
 *
 * Revision 3.8  1994/06/23  20:32:24  green
 * more Solaris fun
 *
 * Revision 3.7  1994/06/12  16:18:49  green
 * added additional error logging to aid in troubleshooting illegitimate
 * hosts.
 *
 * Revision 3.6  1994/06/09  20:03:53  green
 * added "-par generic_sla" and "-par generic_all" to dqs_parse.c,
 * dqs_exec_job.c and dqs_utility.c
 *
 * forgot a couple ";" on my last checkin of dqs_sec.c(knew I should
 * have compiled before checking in...)
 *
 * Revision 3.5  1994/06/09  18:38:22  green
 * had some problems with nonre-entrant gethostbyX in dqs_sec.c - fixed
 *
 * #def overload for "GENERIC" in def.h - fixed
 *
 * Revision 3.4  1994/05/31  00:52:41  green
 * added dsh.c dshd.c to Makefile.proto
 *
 * added MAXNAMELEN and NCARGS to def.h
 *
 * type casting in dqs_reauth.c, dqs_sec.c, dqs_setup.c to hush gcc
 * warnings
 *
 * added jmp_buf to globals.h, changed Revision number in globals.h
 *
 * added dsh and dshd tp prognames.h
 *
 * Revision 3.3  1994/05/28  15:43:06  green
 * added dqs_c_dshd.c to Makefile.proto
 *
 * misc type casting to squalk cc warnings
 *
 * Revision 3.2  1994/03/26  19:49:35  green
 * fixed queue "acl" and "xacl" functionality.
 *
 * Revision 3.1  1994/03/26  12:24:10  green
 * bug in dqs_ck_to_do_list.c:dqs_ck_to_do_list() allowed garbage in
 * "lp2" to be forwarded to dqs_build_complex_str();
 *
 * dqs_job_exit.c:dqs_build_complex_str() modified - changed line 460
 * from strcat() to strcpy()
 *
 * added additional error logging to dqs_sec.c:dqs_qmaster() and
 * dqs_sec.c:dqs_trusted_host() to aid in tracking of bougus
 * configurations.
 *
 * Revision 3.0  1994/03/07  04:14:28  green
 * 3.0 freeze
 *
 * Revision 1.4  1994/02/28  13:47:47  green
 * fixed incoorect addressing of request_list->who in dqs_c_qconf.c
 * should have been request_list->user
 *
 * enabled comments in "resolve_file"
 *
 * dqs_execd now uses me.default_cell rather than conf.default_cell
 * to allow use of "dqs_execd -cell cell_name" and $DQS_CELL
 *
 * Revision 1.3  1994/02/24  01:10:06  green
 * added default compile flags in Makefile.proto
 *
 * modified GETPGRP() and SETPGRP() in def.h for IRIX 5.1.1.1 support
 *
 * changed "st_mtime" to "st_m_time" in dqs_reauth.cand dqs_sec.c
 * for IRIX 5.1.1.1 support
 *
 * Revision 1.2  1994/02/09  19:48:14  green
 * syncing source with docs
 *
 * Revision 1.1.1.1  1994/02/01  17:57:46  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"


/***********************************************************************/
int dqs_q_master(sfd)
     int sfd;
     
{
  
  dqs_list_type      *lp;
  struct sockaddr_in cli_addr;
  struct  in_addr    sin_addr;
  struct hostent     *hp;
  string client;
  string host;
  ADDRLEN addrlen;
  
  
  DENTER((DQS_EVENT,"dqs_q_master"));
  
  addrlen=sizeof(cli_addr);
  if (getpeername(sfd,(struct sockaddr *) &cli_addr, &addrlen) < 0) {
    WARNING((DQS_EVENT,"DQS_ERROR_0423 Illegitimate request origin - getpeername() failed"));
    DEXITE;
    return(-1);
  }
  
  if (cli_addr.sin_family != AF_INET) {
    WARNING((DQS_EVENT,"DQS_ERROR_0424 Illegitimate request != AF_INET from %s",
	     inet_ntoa(cli_addr.sin_addr)));
    DEXITE;
    return(-1);
  }
  
  if (conf.reserved_port) 
    {
      cli_addr.sin_port=ntohs((ushort)cli_addr.sin_port);
      if (cli_addr.sin_port >= IPPORT_RESERVED ||
	  (int) cli_addr.sin_port < IPPORT_RESERVED/2) {
	WARNING((DQS_EVENT,"DQS_ERROR_0425 Non-Reserved port origin %s",
		 inet_ntoa(cli_addr.sin_addr)));
	
	/*             DEXITE;
		       return(-1);
		       
		       Temporaray kludge to by bypass solaris<->AIX problem
	*/
	
	
      }
    }
  
  hp=gethostbyaddr((char *)&cli_addr.sin_addr,
		   sizeof(struct in_addr), cli_addr.sin_family);
  if (!hp) {
    sprintf(host,"%s",inet_ntoa(cli_addr.sin_addr));
    WARNING((DQS_EVENT,"DQS_ERROR_0426 Couldn't gethostbyaddr() origin %s",
	     inet_ntoa(cli_addr.sin_addr)));
    DEXITE;
    return(-1);
  }
  
  /* apparently the next gethostbyname()
     trashing cli_addr on some machines */
  bzero((char *)client,sizeof(client));
  strcpy(client, hp->h_name);
  bcopy(&cli_addr.sin_addr,&sin_addr,sizeof(sin_addr));
  
  if (dqs_my_domain((char *)hp->h_name)) {
    hp=gethostbyname(client);
    if (!hp) {
      WARNING((DQS_EVENT,"DQS_ERROR_0427 Couldn't gethostbyname() origin %s",
	       inet_ntoa(sin_addr)));
      DEXITE;
      return(-1);
    }
    
    for (;;hp->h_addr_list++) {
      if (bcmp(hp->h_addr_list[0], (caddr_t) &sin_addr,
	       sizeof(sin_addr)) == 0)
	break;
      if (!(hp->h_addr_list[0])) {
	WARNING((DQS_EVENT,"DQS_ERROR_0428 addr not listed for %s",hp->h_name));
	DEXITE;
	return(-1);
      }
    }      
  } /* dqs_my_domain(hp->h_name) */
  
  else{
    hp=gethostbyname(client);
    if (!hp) {
      WARNING((DQS_EVENT,"DQS_ERROR_0429 Couldn't gethostbyname() origin %s",
	       inet_ntoa(sin_addr)));
      DEXITE;
      return(-1);
    }
  }
  
  strcpy(host,hp->h_name);
  
  lp=dqs_resolve_cell(me.default_cell);
  
  if (!lp)
    {
      DEXITE;
      return(-1);
    }
  
  if (!dqs_strcasecmp(host,lp->str0)) 
    {
      DEXIT;
      return(0);
    }
  
  if (!dqs_strcasecmp(host,lp->str1))
    {
      DEXIT;
      return(0);
    }
  
  if (!dqs_strcasecmp(host,lp->str2))
    {
      DEXIT;
      return(0);
    }
  
  if (!dqs_strcasecmp(host,lp->str3))
    {
      DEXIT;
      return(0);
    }
  
  ERROR((DQS_EVENT,
	 "Illegitimate host >%s< tried to connect to dqs_execd on >%s< as qmaster",
	 host,me.qualified_hostname));
  
  DEXITE;
  return(-1);
  
}

/***********************************************************************/
int dqs_trusted_host(sfd) 
     int sfd;
     
{
  
  struct sockaddr_in cli_addr;
  struct hostent     *hp;
  struct  in_addr    sin_addr;
  string client;
  string err_str;
  string host;
  ADDRLEN addrlen;
  
  DENTER((DQS_EVENT,"dqs_trusted_host"));
  
  addrlen=sizeof(cli_addr);
  if (getpeername(sfd,(struct sockaddr *) &cli_addr, &addrlen) < 0) {
    WARNING((DQS_EVENT,
	     "Illegitimate request origin - getpeername() failed"));
    DEXITE;
    return(-1);
  }
  
  if (cli_addr.sin_family != AF_INET) {
    WARNING((DQS_EVENT,"DQS_ERROR_0430 Illegitimate request != AF_INET"));
    DEXIT;
    return(-1);
  }
  
  if (conf.reserved_port)
    {
      cli_addr.sin_port=ntohs((ushort)cli_addr.sin_port);
      if (cli_addr.sin_port >= IPPORT_RESERVED ||
	  (int) cli_addr.sin_port < IPPORT_RESERVED/2)
	{
	  WARNING((DQS_EVENT,"DQS_ERROR_0431 Non-Reserved port %d  origin %s",
		   cli_addr.sin_port,inet_ntoa(cli_addr.sin_addr)));
	  DEXITE;
	  return(-1);
	}
    }
  
#ifdef __GNUC__
  hp=gethostbyaddr((void *)&cli_addr.sin_addr,
		   sizeof(struct in_addr), cli_addr.sin_family);
#else
  hp=gethostbyaddr(&cli_addr.sin_addr,
		   sizeof(struct in_addr), cli_addr.sin_family);
#endif
  
  if (!hp) {
    WARNING((DQS_EVENT,
	     "Couldn't gethostbyaddr() origin %s",inet_ntoa(cli_addr.sin_addr)));
    DEXITE;
    return(-1);
  }
  
  /* apparently the next gethostbyname()
     is trashing cli_addr on some machines */
  bzero((char *)client,sizeof(client));
  strcpy(client,hp->h_name);
  bcopy(&cli_addr.sin_addr,&sin_addr,sizeof(sin_addr));
  
  if (dqs_my_domain((char *)hp->h_name)) {
    hp=gethostbyname(client);
    if (!hp) {
      WARNING((DQS_EVENT,
	       "Couldn't gethostbyname() origin %s",inet_ntoa(sin_addr)));
      DEXITE;
      return(-1);
    }
    /*Patch by Drake, for testing with null value after dereference*/  
    for (;;hp->h_addr_list++) {
      if (!(hp->h_addr_list[0])) {
	WARNING((DQS_EVENT,"DQS_ERROR_0432 Couldn't find addr for origin %s",inet_ntoa(sin_addr)));
	DEXIT;
	return(-1);
      }
      if (bcmp(hp->h_addr_list[0], (caddr_t) &sin_addr,
	       sizeof(sin_addr)) == 0)
	break;
      
    }
  } /* dqs_my_domain(hp->h_name) */
  
  else{
    hp=gethostbyname(client);
    if (!hp) {
      WARNING((DQS_EVENT,"DQS_ERROR_0433 Couldn't gethostbyname() origin %s",
	       inet_ntoa(sin_addr)));
      DEXITE;
      return(-1);
    }
  }
  
  strcpy(host,hp->h_name);
  
  if (!dqs_locate_host(host)) {
    ERROR((DQS_EVENT,"DQS_ERROR_0434 Illegitimate host >%s< tried to connect to %s on >%s<",
	   host,me.dqs_formal_prog_name,me.qualified_hostname));
    DEXITE;
    return(-1);
  }
  
  DEXIT;
  return(0);
  
}

/***********************************************************************/
int dqs_my_domain(h)
     char *h;
     
{
  
  static int initialized=0;
  static string local;
  register char *p1, *p2;
  struct hostent *hent;
  dqs_list_type *err_rpt;
  
  DENTER((DQS_EVENT,"dqs_my_domain"));
  
  
  if (!initialized)
    {
      bzero((char *)local,sizeof(local));
      if (gethostname(local, sizeof(local))) 
	{
	  CRITICAL((DQS_EVENT,"DQS_ERROR_0435 gethostname() failed"));
	  if(me.who==DQS_EXECD){
	    err_rpt=(dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));
	    bzero((char *)&err_rpt,sizeof(err_rpt));
	    err_rpt->str1= dqs_string_insert(NULL,h);
	    err_rpt->str1= dqs_string_insert(NULL,
					     "gethpstname failedr ");
	    dqs_report_problem(err_rpt, TRUE);
	  }           
	  abort();
	}
      hent= gethostbyname(local);
      if(!hent) {
	CRITICAL((DQS_EVENT,"DQS_ERROR_0436 gethostbyname() failed"));
	if(me.who==DQS_EXECD){
	  err_rpt=(dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));
	  bzero((char *)&err_rpt,sizeof(err_rpt));
	  err_rpt->str1= dqs_string_insert(NULL,h);
	  err_rpt->str1= dqs_string_insert(NULL,
					   "gethostbyname failedr ");
	  dqs_report_problem(err_rpt, TRUE);
	}  
	abort();
      }
      strcpy(local,hent->h_name);
      initialized++;
    }
  
  if ((p1=(char *)index(h,'.'))==NULL) 
    {
      DEXITE;
      return(-1);
    }   
  
  if ((p2=(char *)index(local,'.'))==NULL) 
    {
      DEXITE;
      return(-1);
    }
  
  if (!dqs_strcasecmp(p1,p2)) 
    {
      DEXITE;   
      return(-1);
    }
  
  DEXIT;   
  return(0);
  
}

/***********************************************************************/
int dqs_manager(cp)
     char *cp;
     
{
  
  DENTER((DQS_EVENT,"dqs_manager"));
  
  if (!cp)
    {
      DEXITE;
      return(-1);
    }
  
  if (!dqs_hash_lookup(cp,Man_hash))
    {
      DEXITE;
      return(-1);
    }
  
  DEXIT;
  return(0);
  
}

/***********************************************************************/
int dqs_operator(cp)
     char *cp;
     
     /*
       Note: a manager is implicitly an "operator".
     */
     
{
  
  DENTER((DQS_EVENT,"dqs_operator"));
  
  if (!cp)
    {
      DEXITE;
      return(-1);
    }
  
  if (dqs_hash_lookup(cp,Man_hash))
    {
      DEXIT;
      return(0);
    }
  
  if (!dqs_hash_lookup(cp,Op_hash))
    {
      DEXITE;
      return(-1);
    }
  
  DEXIT;
  return(0);
  
}

/***********************************************************************/
int dqs_owner(cp,lp)
     char          *cp;
     dqs_list_type *lp;
     
     /*
       Note: a manager/operator is implicitly an "owner".
     */
     
{
  
  DENTER((DQS_EVENT,"dqs_owner"));
  
  if (!cp)
    {
      DEXITE;
      return(-1);
    }
  
  if (dqs_hash_lookup(cp,Man_hash))
    {
      DEXIT;
      return(0);
    }
  
  if (dqs_hash_lookup(cp,Op_hash))
    {
      DEXITE;
      return(0);
    }
  
  while (lp)
    {
      if (!strcmp(cp,lp->str0))
	{
	  DEXITE;
	  return(0);
	}
      lp=lp->next;
    }
  
  DEXIT;
  return(-1);
  
}

/***********************************************************************/
int dqs_job_owner(user_name,job_name)
     char          *user_name;
     char          *job_name;
     
     /*
       Determines if the user is an owner of a job.
       
       Note: a manager/operator is implicitly an "owner".
       
       returns : -1 if unable to locate the job.
       0 if a valid owner
       1 not a valid owner
       
     */
     
{
  
  dqs_job_type *job;
  
  DENTER((DQS_EVENT,"dqs_job_owner"));
  
  if (!user_name)
    {
      DEXITE;
      return(-1);
    }
  
  if (dqs_hash_lookup(user_name,Man_hash))
    {
      DEXIT;
      return(0);
    }
  
  if (dqs_hash_lookup(user_name,Op_hash))
    {
      DEXITE;
      return(0);
    }
  
  job=dqs_locate_job(job_name);
  if (!job)
    {
      DEXITE;
      return(-1);
    }
  
  if (strcmp(user_name,job->owner))
    {
      DEXITE;
      return(1);
    }
  
  DEXIT;
  return(0);
  
}

/***********************************************************************/
int dqs_valid_queue_user(user,queue)
     char *user; /* user name */
     dqs_queue_type *queue; /* queue in question */
     
     /*
       dqs_valid_queue_user - determines if a user has access to a queue
       
       if the queues exclude ACL list, xacl, is non-null, transverse
       the list to see if the user is not explicitly denied access.
       If the queues exclude ACL list, xacl, is non-null, transverse
       the list to see if the user is not explicitly denied access.
       
       returns 1 if user is a valid user;
       0 if the user is not valid.
     */
     
{
  
  string        str;
  dqs_list_type *lp;
  dqs_list_type *err_rpt;
  
  DENTER((DQS_EVENT,"dqs_valid_queue_user"));
  
  if (!user)
    {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0437 NULL username passed to dqs_valid_queue_user - aborting()"));
      if(me.who==DQS_EXECD){
	err_rpt=(dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));
	bzero((char *)&err_rpt,sizeof(err_rpt));
	
	err_rpt->str1= dqs_string_insert(NULL,
					 "NULL username passed ");
	dqs_report_problem(err_rpt, TRUE);
      }  
      abort();
    }
  
  lp=queue->xacl;
  while (lp)
    {
      sprintf(str,"%s...%s",user,lp->str0);
      if (dqs_hash_lookup(str,Acl_hash))
	{ /* explicitly denied access */
	  DEXITE;
	  return(0);
	}
      lp=lp->next;
    }
  
  if (!queue->acl)
    { /* everyone who is not explicitly denied has access */
      DEXIT;
      return(1);
    }
  
  lp=queue->acl;
  while (lp)
    {
      sprintf(str,"%s...%s",user,lp->str0);
      if (dqs_hash_lookup(str,Acl_hash))
	{ /* explicitly given access */
	  DEXIT;
	  return(1);
	}
      lp=lp->next;
    }
  
  DEXITE;
  return(0);
  
}

/***********************************************************************/
void dqs_set_uid_gid(job)
     dqs_job_type   *job;
     
{
  
  int           status;
  struct passwd *pw;
  
  DENTER((DQS_EVENT,"dqs_set_uid_gid"));
  
  if (me.uid)
    {
      DEXIT;
      return;
    }
  
  if (!job->owner)
    {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0438 error: NULL username passed to dqs_set_uid_gid()"));
      DEXITE;
      exit(DQS_EINVAL);
    }
  
  pw=(struct passwd *)getpwnam(job->owner);
  
  /* better safe than sorry */
  if (!pw)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0439 error: getpwnam(%s) failed",job->owner));
      DEXITE;
      exit(DQS_ESAD);
    }
  
  if (pw->pw_gid<conf.min_gid)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0440 error: gid less than minimum allowed",job->owner));
      DEXITE;
      exit(DQS_EINVAL);
    }
  
  if (setgid(pw->pw_gid))
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0441 error: setgid() failed"));
      DEXITE;
      exit(DQS_EINVAL);
    }
  status=initgroups(pw->pw_name,pw->pw_gid);
  
  /* Why am I doing it this way?  Good question,
     an even better question would be why vendors
     can't get their act together on what is returned,
     at least get it right in the man pages!
     on error heres what I get:
     (subject to change with OS releases)
     OS      return       errno
     AIX     1            1
     ULTRIX  1            1
     OSF/1   1            1
     IRIX   -1            1   (returns #groups if successful)
     SUNOS  -1            1
     
     UGH!!!
  */
  
#if (defined(SVR3) || defined(sun) || defined(solaris) || defined(SOLARIS23_UP))
  if (status<0) {
    ERROR((DQS_EVENT,"DQS_ERROR_0442 error: initgroups() failed with errno %d\n",status));
    DEXITE;
    exit(DQS_EINVAL);
  }
#else
  if (status) {
    ERROR((DQS_EVENT,"DQS_ERROR_0443 error: initgroups() failed with errno %d\n",status));
    DEXITE;
    exit(DQS_EINVAL);
  }
#endif
  
  if (pw->pw_uid<conf.min_uid)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0444 error: user gid less than minimum specified in conf"));
      DEXITE;
      exit(DQS_EINVAL);
    }
  
  if (setuid(pw->pw_uid))
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0445 error: setuid() failed"));
      DEXITE;
      exit(DQS_EINVAL);
    }
  
  DEXIT;
  return;
  
}
