%define rel 1
%define prefix /usr
%define confdir /etc
%define statedir /var

Summary: A tool for defining, selecting and indicating XKB keyboards
Name: xkbsel
Version: 0.12
Release: %{rel}
Copyright: GPL
Group: X11/Utilities
Source: ftp://ftp.penguin.cz/pub/users/stano/i18n/%{name}-%{version}.tar.gz
Requires: XFree86
Buildroot: /var/tmp/%{name}-root

%description
xkbsel is a framework for defining, selecting and
indicating XKB keyboard mappings, without the need
to modify X11 distribution in any way.

This package contains the maintenance application
the command-line tool and the simple Xaw GUI tool.

%prep
if [ ! "${RPM_BUILD_ROOT}" = "/" ]; then
  rm -rf "${RPM_BUILD_ROOT}" ;
fi
%setup

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --with-kde --with-gnome \
	--prefix=%{prefix} --sysconfdir=%{confdir} \
	--localstatedir=%{statedir}
make

%install
make prefix=$RPM_BUILD_ROOT%{prefix} sysconfdir=$RPM_BUILD_ROOT%{confdir} \
	localstatedir=$RPM_BUILD_ROOT%{statedir} install-strip

%clean
if [ ! "${RPM_BUILD_ROOT}" = "/" ]; then
  rm -rf "${RPM_BUILD_ROOT}" ;
fi

%package common
Summary: A tool for defining, selecting and indicating XKB keyboards
Group: X11/Utilities
Requires: XFree86

%description common
xkbsel is a framework for defining, selecting and
indicating XKB keyboard mappings, without the need
to modify X11 distribution in any way.

This package contains the maintenance application
the command-line tool and the simple Xaw GUI tool.

%post common
/usr/bin/xkbseldb -R

%preun common
rm -rf %{statedir}/%{name}/compiled/*
rm -f %{statedir}/%{name}/xkbseldb.*


%package devel
Summary: Header files and libraries for developing xkbsel applications
Group: Development/Libraries
Requires: xkbsel-common XFree86-devel

%description devel
Header files and libraries for developing selectors
and indicators in the xkbsel framework.

%package kde
Summary: Dockable XKB keyboard selector and indicator for KDE
Group: X11/Utilities
Requires: xkbsel-common kdebase

%description kde
xkbsel is a framework for defining, selecting and
indicating XKB keyboard mappings, without the need
to modify X11 distribution in any way.

This package contains the dockable selector
and indicator for kpanel.

%package gnome
Summary: XKB keyboard selector and indicator applet for Gnome
Group: X11/Utilities
Requires: xkbsel-common gnome-core

%description gnome
xkbsel is a framework for defining, selecting and
indicating XKB keyboard mappings, without the need
to modify X11 distribution in any way.

This package contains the dockable selector
and indicator applet for the Gnome panel.


%files common
%defattr(-, root, root)

%doc ABOUT-NLS AUTHORS COPYING ChangeLog INSTALL NEWS README TODO
%{prefix}/bin/xkbseldb
%{prefix}/bin/xkbsel
%{prefix}/bin/xkbsel-aw
%{prefix}/man
%{prefix}/share/xkbsel
%{prefix}/share/locale
%{statedir}
%config %{confdir}/xkbsel.conf

%files devel
%defattr(-, root, root)
%{prefix}/lib
%{prefix}/include
%doc COPYING AUTHORS NEWS doc/protocol.txt

%files kde
%{prefix}/bin/xkbsel-kde
%{prefix}/share/applnk/Utilities/xkbsel-kde.kdelnk

%files gnome
%{prefix}/bin/xkbsel_gnome_applet
%{prefix}/share/applets/Utility/xkbsel_gnome_applet.desktop
%{confdir}/CORBA/servers/xkbsel_gnome_applet.gnorba

%changelog
* Sun Jul 25 1999 Stanislav Meduna <stano@trillian.eunet.sk>
- first public version

