/*
                  XJoystick Caliberator Global Callbacks

	Functions:

	int JCFileBrowserCancelCB(char *path)
	int JCFileBrowserOKCB(char *path)
	int JCWMenuBarCB(void *ptr, int op_code)
	int JCWDoOpenDevice(jcw_struct *j, char *device, char *calib_file)

	---

 */

#include <stdio.h>
#include <malloc.h>
#include <db.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/stat.h>

#include "../include/disk.h"
#include "../include/string.h"
#include "../include/strexp.h"
#include "../include/osw-x.h"
#include "../include/widget.h"

#include "xjc.h"
#include "config.h"


/*
 *	File browser cancel callback.
 */
int JCFileBrowserCancelCB(char *path)
{
	return(0);
}

/*
 *	File browser OK callback.
 */
int JCFileBrowserOKCB(char *path)
{
        switch(file_browser_op_code)
        {
          case FB_OP_CODE_NONE:
            break;
 
          case FB_OP_CODE_OPEN_DEVICE:
	    if(path != NULL)
                JCWDoOpenDevice(
                    &jcw,
                    path,
                    jcw.calib_file
                );
            break;

          case FB_OP_CODE_SAVE_AS:
	    if(path != NULL)
	    {
	        strncpy(
		    jcw.calib_file,
		    path,
		    PATH_MAX + NAME_MAX
	        );
	        jcw.calib_file[PATH_MAX + NAME_MAX - 1] = '\0';
                XJCDoSaveCaliberation(&jcw, path);
	    }
            break;
        }


	return(0);
}

/*
 *	JC window menu bar callback.
 */
int JCWMenuBarCB(void *ptr, int op_code)
{
	int status = 0;
	char *strptr;
	char tmp_path[PATH_MAX + NAME_MAX];
	jcw_struct *j;


	j = (jcw_struct *)ptr;
	if(j == NULL)
	    return(-1);


	switch(op_code)
	{
	  case JCW_MENU_CODE_NONE:

	    break;

	  case JCW_MENU_CODE_OPEN_DEVICE:
	    if(file_browser_op_code == FB_OP_CODE_OPEN_DEVICE)
	    {
		FBrowserMapSearchMask(
		    &file_browser,
		    JS_DEVICE_MASK_STRING
		);
	    }
	    else
	    {
		FBrowserMapPath(
		    &file_browser,
                    JS_DEVICE_PATH_MASK_STRING
		);
		file_browser_op_code = FB_OP_CODE_OPEN_DEVICE;
	    }
	    break;

	  case JCW_MENU_CODE_SAVE_CAL:
	    XJCDoSaveCaliberation(j, j->calib_file);
	    break;

	  case JCW_MENU_CODE_SAVE_CAL_AS:
            if(file_browser_op_code == FB_OP_CODE_SAVE_AS)
            {
		FBrowserMap(&file_browser);
	    }
            else
            {
		strptr = getenv("HOME");
		strptr = PrefixPaths(strptr, CALIB_FILE_MASK_STRING);
		strncpy(
		    tmp_path,
		    ((strptr == NULL) ? "/" : strptr),
		    PATH_MAX + NAME_MAX
		);
		tmp_path[PATH_MAX + NAME_MAX - 1] = '\0';
                FBrowserMapPath(&file_browser, tmp_path);

                file_browser_op_code = FB_OP_CODE_SAVE_AS;
            }
	    break;

	  case JCW_MENU_CODE_EXIT:
	    runlevel = 1;
	    break;
	}


	return(status);
}


/*
 *	Procedure to open a joystick device for jc window j and
 *	fetch caliberation values from calib_file.
 *
 *	Updating values on jc window j as needed.
 */
int JCWDoOpenDevice(jcw_struct *j, char *device, char *calib_file)
{
	int i, n;
	int strc;
	char *strv[10];
	char ldevice[PATH_MAX + NAME_MAX];
	char lcalib[PATH_MAX + NAME_MAX];
	char text[PATH_MAX + NAME_MAX + 256];

	axis_bar_struct **axis_bar;


	if(j == NULL)
	    return(-1);

	strncpy(
	    ldevice,
	    ((device == NULL) ? DEF_DEVICE_NAME : device),
	    PATH_MAX + NAME_MAX
	);
	ldevice[PATH_MAX + NAME_MAX - 1] = '\0';

        strncpy(
            lcalib,
            ((calib_file == NULL) ? DEF_CALIB_FILE : calib_file),
            PATH_MAX + NAME_MAX
        );
        lcalib[PATH_MAX + NAME_MAX - 1] = '\0';


	/* Close device first. */
	JSClose(&j->jsd);


	/* Format commands. */
        strc = 4;
        strv[0] = "-d";
        strv[1] = ldevice;
        strv[2] = "-f";
        strv[3] = lcalib;

	/* Open joystick device. */
        if(
            JSInit(
                &j->jsd,
                strc, strv
            ) != JSSuccess
        )
        {
            JSClose(&j->jsd);

	    sprintf(text,
		"Cannot open device:\n\n    %s",
		ldevice
	    );
	    dialog.icon_img = xjc_image.error;
	    printdw(&dialog, text);
        }

	/* Update device prompt. */
        PromptSetS(&j->device_prompt, ldevice);
	PromptMarkBuffer(&j->device_prompt, PROMPT_POS_END);
	if(j->device_prompt.map_state)
	    PromptDraw(&j->device_prompt, PROMPT_DRAW_AMOUNT_TEXTONLY);


	/* Update axis readout values. */
	for(i = 0, axis_bar = j->axis_bar;
            i < j->total_axis_bars;
            i++, axis_bar++
        )
	{
	    if(*axis_bar == NULL)
		continue;

	    n = PromptGetI(&((*axis_bar)->axis_num_prompt));
	    if(JSIsAxisAllocated(&j->jsd, n))
	    {
                (*axis_bar)->pos = 0;
		(*axis_bar)->min = j->jsd.axis[n]->min;
                (*axis_bar)->max = j->jsd.axis[n]->max;
		(*axis_bar)->caliberate_tb.state = False;
                PromptSetI(&((*axis_bar)->null_zone_prompt), j->jsd.axis[n]->nz);
                (*axis_bar)->flip_tb.state = ((j->jsd.axis[n]->flip) ?
		    True : False);
	    }
	    else
	    {
                (*axis_bar)->pos = 0;
                (*axis_bar)->min = 0;
                (*axis_bar)->max = 0;
                (*axis_bar)->caliberate_tb.state = False;
                PromptSetI(&((*axis_bar)->null_zone_prompt), 0);
                (*axis_bar)->flip_tb.state = False;
	    }

	    if(j->map_state)
	    {
		PromptDraw(&((*axis_bar)->axis_num_prompt), PROMPT_DRAW_AMOUNT_TEXTONLY);
		AxisBarDraw(*axis_bar);
		TgBtnDraw(&((*axis_bar)->caliberate_tb), TGBTN_DRAW_AMOUNT_COMPLETE);
                PromptDraw(&((*axis_bar)->null_zone_prompt), PROMPT_DRAW_AMOUNT_TEXTONLY);
                TgBtnDraw(&((*axis_bar)->flip_tb), TGBTN_DRAW_AMOUNT_COMPLETE);
	    }
	}

	/* Set title. */
	*text = '\0';
	strncat(text, PROG_NAME, 80);
	if(j->jsd.name != NULL)
	{
	    strncat(text, ": ", 80);
	    strncat(text, j->jsd.name, 80);
	}
	text[79] = '\0';
	OSWSetWindowTitle(j->toplevel, text);


	return(0);
}
