/*-
 * Copyright (c) 1998-1999 Shunsuke Akiyama <akiyama@jp.FreeBSD.org>.
 * All rights reserved.
 * Copyright (c) 1998-1999 X-TrueType Server Project, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: fontcacheP.h,v 1.6 1999/01/31 12:43:53 akiyama Exp $
 */

#ifndef _FONTCACHEP_H_
#define _FONTCACHEP_H_

struct fc_cache_settings {
    long	himark;
    long	lowmark;
    long	balance;
};

struct fc_cache_stat {
    long	hits;
    long	misshits;
    long	purged;
    long	usage;
};

struct fc_cache_statistics {
    long			purge_runs;
    long			purge_stat;
    long			balance;
    struct fc_cache_stat	f;
    struct fc_cache_stat	v;
};

typedef struct fc_cache_settings FontCacheSettings, *FontCacheSettingsPtr;
typedef struct fc_cache_statistics FontCacheStatistics, *FontCacheStatisticsPtr;

int	FontCahceChangeSettings(FontCacheSettingsPtr /* cinfo */);
void	FontCacheGetSettings(FontCacheSettingsPtr /* cinfo */);
void	FontCacheGetStatistics(FontCacheStatisticsPtr /* cstats */);

#endif /* _FONTCACHEP_H_ */
