/*
    Copyright (C) 1999 by  XCIN TEAM

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For any question or suggestion, please mail to xcin mailing-list:
    xcin@linux.org.tw, or the maintainer Tung-Han Hsieh: thhsieh@linux.org.tw
*/      

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <locale.h>
#include <string.h>
#include <ctype.h>
#include "constant.h"
#include "xcintool.h"

#ifdef HAVE_GETTEXT
#  include <libintl.h>
#endif

void 
locale_setting(char **lc_ctype, char **lc_messages, char **encoding, 
	       int exitcode)
{
    char *locale = NULL, *s;

#ifdef HAVE_GETTEXT
    if (lc_messages)
        *lc_messages = setlocale(LC_MESSAGES, "");
    textdomain("xcin");
    bindtextdomain("xcin", XCIN_MSGLOCAT);
#endif

    locale = setlocale(LC_CTYPE, "");
    if (! locale) {
	if (exitcode != XCINMSG_EMPTY)
	    perr(XCINMSG_WARNING, 
		N_("C locale \"%s\" is not supported by your system.\n"
		   "Try to set LC_CTYPE=%s\n"), locale, LOCALE_NAME);

	locale = LOCALE_NAME;
	if (! setlocale(LC_CTYPE, locale) && exitcode != XCINMSG_EMPTY) {
            perr(exitcode,
                N_("C locale \"%s\" is also not available.\n"), locale);
	    locale = NULL;
	}
    }
    if (lc_ctype)
        *lc_ctype = locale;
    if (locale && encoding) {
	if ((s = strrchr(locale, '.'))) {
	    *encoding = (char *)strdup(s+1);
	    s = *encoding;
	    while (*s) {
		*s = (char)tolower(*s);
		s ++;
	    }
	}
	else
	    *encoding = NULL;
    }
}
