/* LOADAVG patch thanks to Darren Benham <gecko@benham.net>
 now use -l switch on the command line to toggle between graphical and 
 numeric loadavg display.
*/

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>

#include <sys/wait.h>
#include <sys/param.h>
#include <sys/types.h>

#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include "../wmgeneral/wmgeneral.h"
#include "../wmgeneral/misc.h"

#include "wmcpu-master.xpm"

#define WMCPU_VERSION "1.2"
char	*ProgName;
int		gfLoadBar = 1;

char wmcpu_mask_bits[64*64];
int  wmcpu_mask_width = 64; 
int  wmcpu_mask_height = 64;

/* functions */
void usage(void);
void printversion(void);
void wmcpu_routine(int, char **);


int main(int argc, char *argv[]) {
	int		i;
	ProgName = argv[0];

	if (strlen(ProgName) >= 5)
		ProgName += (strlen(ProgName) - 5);

	for (i=1; i<argc; i++) {
		char *arg = argv[i];

		if (*arg=='-') {
			switch (arg[1]) {
			case 'd' :
				if (strcmp(arg+1, "display")) {
					usage();
					exit(1);
				}
				break;
			case 'v' :
				printversion();
				exit(0);
				break;
			case 'l' :
				gfLoadBar = 0;
				break;
			default:
				usage();
				exit(0);
				break;
			}
		}
	}
	wmcpu_routine(argc, argv);
	return(0);
}

void usage(void) {

	fprintf(stderr, "\nwmcpu - programming: timecop (timecop@linuxwarez.com)\n\n");
	fprintf(stderr, "usage:\n");
	fprintf(stderr, "\t-display <display name>\n");
	fprintf(stderr, "\t-h\tthis screen\n");
	fprintf(stderr, "\t-v\tprint the version number\n");
	fprintf(stderr, "\t-l\tshow load as numbers\n");
	fprintf(stderr, "\n");
}

void printversion(void) {

	if (!strcmp(ProgName, "wmcpu")) {
		fprintf(stderr, "%s\n", WMCPU_VERSION);
	}
}

int uptime()
{
	FILE *fp;
	float fupt;
	if( (fp = fopen("/proc/uptime", "r")) != NULL)
		fscanf(fp, "%f",&fupt);
	fclose(fp);
	return fupt;
}

void wmcpu_routine(int argc, char **argv)
{
	/* /proc/stat   kernel/system statistics
	cpu  3357 0 4313 1362393
	The number of jiffies (1/100ths of a second)
	that the system spent in user mode, user
	mode with low priority (nice), system mode,
	and the idle task, respectively.  The last
	value should be 100 times the second entry
	in the uptime pseudo-file. */

	static float cpustat[4];   /* remember the statistics read last time */
	int		xpm_X = 0, xpm_Y = 0,i;
    int 	tempy;
	int 	upt,days=0,hours=0,mins=0;
	XEvent	Event;
	FILE	*fp;
	char	str[32];
	float 	info[4],ftmp;
	int 	old_mins=-1,old_hours=-1;


	/* Open 64x64 window */
	createXBMfromXPM(wmcpu_mask_bits, wmcpu_master_xpm, wmcpu_mask_width, wmcpu_mask_height);
	openXwindow(argc, argv, wmcpu_master_xpm, wmcpu_mask_bits, wmcpu_mask_width, wmcpu_mask_height);

	while(1) {
		if( (fp = fopen("/proc/stat", "r")) != NULL)
		{
			long int CPUuser,CPUnice,CPUsyst;
			fscanf(fp, "%s %f %f %f %f", str, info, info+1, info+2, info+3);

			if(cpustat[0] != 0)
			{
				float fields[4], total = 0.0;
				for(i = 0; i < 4; i++)
				{ fields[i] = info[i] - cpustat[i]; total += fields[i]; }
				if(total > 0)
				{
					CPUuser=(fields[0]*100)/54;
					CPUnice=(fields[1]*100)/54;
					CPUsyst=(fields[2]*100)/54;
					copyXPMArea(3,93,CPUuser,9,5,5);
					copyXPMArea(3,75,CPUnice,9,5+CPUuser,5);
					copyXPMArea(3,84,CPUsyst,9,5+CPUuser+CPUnice,5);
					copyXPMArea(3,102,(54-(CPUuser+CPUnice+CPUsyst)),9,5+CPUuser+CPUnice+CPUsyst,5);
				}
			}
		for(i=0; i < 4; i++) cpustat[i] = info[i];
		fclose(fp);
	}
	/* /proc/loadavg
	The load average numbers give the number of jobs in
	the run queue averaged over 1, 5 and 15 minutes.
	They are the same as the load average numbers given
	by uptime(1) and other programs. */

	if( (fp = fopen("/proc/loadavg", "r")) != NULL)
	{
		static float oldv = 0.0;

		fscanf(fp, "%f", &ftmp);
		if(oldv != ftmp)
		{
			int tempx;
			oldv = info[0];
			if ( gfLoadBar )
			{
				oldv = ftmp;
				i=ftmp*54;
				copyXPMArea(3,75,i,9,5,33);
				copyXPMArea(3,102,54-i,9,5+i,33);
			}
			else
			{
				tempx=ftmp*100;
				if ( tempx > 9999 ) tempx=9999;
				if ( tempx>1000 )
				{
					tempy=tempx/1000;
					copyXPMArea(3+(tempy*6),66,6,9,15,33);
				}
				else
					copyXPMArea(68,66,6,9,15,33);
				tempy=(tempx/100)%10;
				copyXPMArea(3+(tempy*6),66,6,9,21,33);
			
				copyXPMArea( 65,66,3,9,28,33);

				tempy=(tempx/10)%10;
				copyXPMArea(3+(tempy*6),66,6,9,31,33);

				tempy=tempx%10;
				copyXPMArea(3+(tempy*6),66,6,9,37,33);
			}
		}
		fclose(fp);
	}
	/* /proc/meminfo
	This is used by free(1) to report the amount of
	free and used memory (both physical and swap) on
	the system as well as the shared memory and buffers
	used by the kernel. */

	if( (fp = fopen("/proc/meminfo", "r")) != NULL)
	{
		static float stotal=0.0, suser=0.0, sshared=0.0, sbuffers=0.0;
		char junk[512];
		float total, used, freeM, shared, buffers, cached;
		long int MEMshar,MEMbuff,MEMcach;
		float user;

		fgets(junk, 500, fp);
		fscanf(fp, "%s %f %f %f %f %f %f", junk, &total, &used, &freeM, &shared, &buffers, &cached);
		user = total - freeM - shared - buffers;
		if(user < 0.0)
		{
			user = 0.0;
			buffers = total - freeM - shared;
		}
		if(stotal != total || suser != user || sshared != shared || sbuffers != buffers)
		{
			stotal = total; suser = user; sshared = shared; sbuffers = buffers;
			MEMshar=(shared*54)/total;
			MEMbuff=(buffers*54)/total;
			MEMcach=(cached*54)/total;
			copyXPMArea(3,93,MEMshar,9,5,19);
			copyXPMArea(3,75,MEMcach,9,5+MEMshar,19);
			copyXPMArea(3,84,MEMbuff,9,5+MEMshar+MEMcach,19);
			copyXPMArea(3,102,(54-(MEMshar+MEMbuff+MEMcach)),9,5+MEMshar+MEMbuff+MEMcach,19);
		}
		fclose(fp);
	}


   upt=uptime();
   mins=(upt/60)%60;
   hours=(upt/3600)%24;
   days=(upt/86400);
   if(old_hours!=hours)
      {
	 printf("%03d:%02d:",days,hours);
	 old_hours=hours;
      }
   if(old_mins!=mins)
      {
	old_mins=mins;
	tempy=mins%10;
	copyXPMArea(3+(tempy*6),66,6,9,50,48);
	tempy=mins/10;
	copyXPMArea(3+(tempy*6),66,6,9,44,48);
	copyXPMArea(63,66,3,9,41,48);
	tempy=hours%10;
	copyXPMArea(3+(tempy*6),66,6,9,34,48);
	tempy=hours/10;
	copyXPMArea(3+(tempy*6),66,6,9,28,48);
	copyXPMArea(63,66,3,9,25,48);
	tempy=days%10;
	copyXPMArea(3+(tempy*6),66,6,9,18,48);
	tempy=days/10;
	copyXPMArea(3+(tempy*6),66,6,9,12,48);
	tempy=days/100;
	copyXPMArea(3+(tempy*6),66,6,9,6,48);
      }

	RedrawWindowXY(xpm_X, xpm_Y);
	while (XPending(display))
	{
		XNextEvent(display, &Event);
		switch (Event.type)
		{	
			case Expose:
				RedrawWindowXY(xpm_X, xpm_Y);
				break;
			case DestroyNotify:
				XCloseDisplay(display);
				exit(0);
				break;
			}
		}
   		usleep(250000L);
   	}
}
