/* GiMd2Viewer - Quake2 model viewer
 * Copyright (C) 1998  Lionel ULMER <bbrox@mygale.org>
 *
 * Based on code Copyright (C) 1997 Trey Harrison <trey@crack.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MODEL_H__
#define __MODEL_H__

typedef struct {
  float x, y, z;
  float nx, ny, xz;
} Vertex;

typedef struct {
  float s, t;
} TexInfo;

typedef struct {
  char name[16];
  
  Vertex *vert_table;
} Frame;

typedef struct {
  /* The GL commands */
  long *glcmds;
  TexInfo *texinfo;
  
  /* The number of Frames */
  long numframes;
  Frame *frames;
  
  long skinwidth;
  long skinheight;
} Model;

/*void DrawModel(Model *mdl, int frame, int nextframe, float interpolation) ;
  Model *ModelLoad(FILE *f) ; */

Model *GetModel(char *url) ;
void FreeModel(Model *mdl) ;

int GetModelDList(Model *mdl, int frame, int nextframe,
		  float inter, float scale) ;

#endif  __MODEL__H__
