#include "global.h"
#include "grid.h"
#include "chat.h"


FuncList getFuncList, setFuncList;

Public
WObject *
copy_object(WObject *pwoh)
{
  WObject wohold, *pwohold = &wohold;

  memset(pwohold, 0, sizeof(WObject));    
  *pwohold = *pwoh;
  return (pwohold);
}

Public
void update_object(WObject *pwoh, WObject *pwohold)
{
  updateObjectIn3D(pwoh);
  updateBB(pwoh);
  updateObjectIntoGrid(pwoh, pwohold);
}

/* Definition des fonctions set */
void set_xy(WObject *pwoh, Payload *ppl)
{
  WObject *pwohold;
  
  pwohold = copy_object(pwoh);
  scanPayload(ppl, "ff", &(pwoh->x), &(pwoh->y));
  update_object(pwoh, pwohold);
}

void set_z(WObject *pwoh, Payload *ppl)
{
  WObject *pwohold;

  pwohold = copy_object(pwoh);
  scanPayload(ppl, "f", &(pwoh->z));
  update_object(pwoh, pwohold);
}

void set_a1(WObject *pwoh, Payload *ppl)
{
  WObject *pwohold;

  pwohold = copy_object(pwoh);
  scanPayload(ppl, "f", &(pwoh->a1));
  update_object(pwoh, pwohold);
}

void set_a2(WObject *pwoh, Payload *ppl)
{
  WObject *pwohold;

  pwohold = copy_object(pwoh);
  scanPayload(ppl, "f", &(pwoh->a2));
  update_object(pwoh, pwohold);
}

void set_a3(WObject *pwoh, Payload *ppl)
{
  WObject *pwohold;

  pwohold = copy_object(pwoh);
  scanPayload(ppl, "f", &(pwoh->a3));
  update_object(pwoh, pwohold);
}

void set_msg(WObject *pwoh, Payload *ppl)
{
  int lastmess;
  char msg[MESS_LEN];

  scanPayload(ppl, "ds", &lastmess, msg);
  if (lastmess != pwoh->ext.user.lastmess) {
    newTextMessage(pwoh->h_name, msg);
    pwoh->ext.user.lastmess = lastmess;
  }
}

void set_hname(WObject *pwoh, Payload *ppl)
{
  scanPayload(ppl, "s", pwoh->h_name);
}

void set_mapface(WObject *pwoh, Payload *ppl)
{
  scanPayload(ppl, "s", pwoh->ext.user.urlface);
}

void set_mapback(WObject *pwoh, Payload *ppl)
{
  scanPayload(ppl, "s", pwoh->ext.user.urlback);
}

void set_world(WObject *pwoh, Payload *ppl)
{
  scanPayload(ppl, "s", pwoh->ext.user.world);
}

/*
 * Get functions Definition
 */
void get_xy(WObject *pwoh, Payload *ppl)
{
  writePayload(ppl, "ff", pwoh->x, pwoh->y);
}

void get_z(WObject *pwoh, Payload *ppl)
{
  writePayload(ppl, "f", pwoh->z);
}

void get_a1(WObject *pwoh, Payload *ppl)
{
  writePayload(ppl, "f", pwoh->a1);
}

void get_a2(WObject *pwoh, Payload *ppl)
{
  writePayload(ppl, "f", pwoh->a2);
}

void get_a3(WObject *pwoh, Payload *ppl)
{
  writePayload(ppl, "f", pwoh->a3);
}

void get_msg(WObject *pwoh, Payload *ppl)
{
  writePayload(ppl, "ds", pwoh->ext.user.lastmess, pwoh->ext.user.message);
}

void get_hname(WObject *pwoh, Payload *ppl)
{
  writePayload(ppl, "s", pwoh->h_name);
}

void get_mapface(WObject *pwoh, Payload *ppl)
{
  writePayload(ppl, "s", pwoh->ext.user.urlface);
}

void get_mapback(WObject *pwoh, Payload *ppl)
{
  writePayload(ppl, "s", pwoh->ext.user.urlback);
}

void get_world(WObject *pwoh, Payload *ppl)
{
  writePayload(ppl, "s", pwoh->ext.user.world);
}

/* Permet de modifier la propriete (sa copie locale). La nouvelle
 * valeur se trouve dans text. Il faut renvoyer la position
 * de lecture de la suite (utiliser scanPayload et sa valeur de retour).
 * Cette fonction est typiquement appelee suite a la reception d'un
 * delta sur le reseau.
 */
void setProperty(NetObject *pnoh, u_int8 prop_id, Payload *ppl)
{
  WObject *pwoh;

  pwoh = (WObject *) pnoh;
  if (setFuncList[prop_id][pnoh->type].pf == NULL) {
    warning("set: property=%d doesn't match the object type=%d",
	     prop_id, pnoh->type);
    return;
  }
  setFuncList[prop_id][pnoh->type].pf(pwoh, ppl);
}

/* Permet de recuperer la propriete (sa copie locale). Il faut
 * ecrire text et renvoyer la longueur ecrite 
 * (utiliser writePayload et sa valeur de retour) 
 * Typiquement appelee pour connaitre text avant d'emettre 
 * un delta.
 */
Public
void getProperty(NetObject *pnoh, u_int8 prop_id, Payload *ppl)
{
  WObject *pwoh;

  pwoh = (WObject *) pnoh;
  if (getFuncList[prop_id][pnoh->type].pf == NULL) {
    warning("get: property=%d doesn't match the object type=%d",
	     prop_id, pnoh->type);
    return;
  }
  getFuncList[prop_id][pnoh->type].pf(pwoh, ppl);
}

Public
void setAllProperties(NetObject *pnoh, Payload *ppl)
{
  int nprop;

  for (nprop=0; nprop < propertiesnumber[pnoh->type]; nprop++)
    setProperty(pnoh, nprop, ppl);
}

/* Permet de recuperer toutes les proprietes d'un objet. Le text est
 * initialise avant l'appel, et rempli dans la procedure.
 * Typiquement appelee pour connaitre text apres emission
 * d'un declareCreationToNetwork.
 */
Public
void getAllProperties(NetObject *pnoh, Payload *ppl)
{
  int nprop;

  for (nprop=0; nprop < propertiesnumber[pnoh->type]; nprop++)
    getProperty(pnoh, nprop, ppl);
}

/* Alloue une copie locale pour l'objet , avec initialisation et
 * attribution de tous les champs grace a des setProperty.
 * Typiquement appelee suite a la reception d'un C.
 */
Public
NetObject *
createObjectFromNetwork(u_int8 type_id, NetObjectId noid, Payload *ppl)
{
  WObject *pwoh;
  NetObject *pnoh;

  pwoh = (WObject *) malloc(sizeof(WObject));
  memset(pwoh, 0, sizeof(WObject));
  pnoh = &(pwoh->noh);
  assert (pnoh == (NetObject*) pwoh);
  pnoh->type = type_id;
  pnoh->noid = noid;

  placeObjectInGrid(pwoh); /* Placer l'objet dans la grille */

  if (generalFuncList[type_id].createFromNetwork == NULL) {
    warning("WMgt: I don't know how to create an object with this type!");
    return ((NetObject*) NULL);
  }
  generalFuncList[type_id].createFromNetwork(pwoh, ppl);
  return pnoh;
}

/* Supprime object du monde, si object n'est pas le local user...
 * La sequence doit inclure un "deleteNetObject" qui est le
 * reciproque d'un newObjectName/createNetObjectFromString.
 * 1) faire le menage et afficher tout ce qui est necessaire.
 * 2) (si la decision a ete prise localement) declareDeletionToNetwork
 * 3) deleteNetObject 
 *    (le nom devient invalide, plus aucun declare n'est possible)
 * 4) faire le free final
 */
void requestDeletionFromNetwork(NetObject *pnoh)
{
  WObject *pwoh;

  pwoh = (WObject *) pnoh;
  if (pwoh != plocaluser) {
    if (pnoh->type == USERTYPE)
      userLoggingOut(pwoh->ext.user.interfacebuf);
    selectedObjectDeletion(pwoh->soh);

    deleteObjectFromGrid(pwoh);
    mobilelist = deleteObjectFromList(pwoh, mobilelist);
    SolidDelete(pwoh->soh);
    deleteNetObject((NetObject*) pwoh);
    memset(pwoh, 0, sizeof(WObject));
    free(pwoh);
  }
  else
    notice("You're trying to kill me, but I'm back!");
}

/* Cette fonction renvoie le nombre total de proprietes du type.
 * Elles doivent etre numerotees de 0 a properties_count-1.
 * Cette fonction utilise par exemple un simple tableau constant.
 * Typiquement appelee sur reception d'un C, apres appel a
 * create_object, pour savoir le nombre de set_property a faire.
 */
u_int8 countProperties(u_int8 type_id)
{
  return propertiesnumber[type_id];
}

int updateObjectToNetwork(WObject *pwoh, WObject *pwohold)
{
  if (generalFuncList[pwoh->noh.type].updateToNetwork == NULL)
    return TRUE;
  return generalFuncList[pwoh->noh.type].updateToNetwork(pwoh, pwohold);
}

