#ifndef FUNCS_H
#define FUNCS_H


/**********************/
/* External Variables */

extern int wmgtlockstate;
extern WObject *plocaluser;
extern ObjectList stilllist, mobilelist, volatilelist;
extern Grid grid;
extern FuncList getFuncList, setFuncList;
extern GeneralFuncList generalFuncList;
extern GeneralMethodList generalMethodList;
extern u_int8 propertiesnumber[TYPESNUMBER];
extern char *fileline;
extern float defmaxlasting[TYPESNUMBER];


/************************/
/*  macros              */

#define ABSF(f)           ((f) > 0 ? (f) : (-(f)))
#define MAXI(f1, f2)       ((f1) > (f2) ? (f1) : (f2))
#define MINI(f1, f2)       ((f1) < (f2) ? (f1) : (f2))


void localWorldName(char *);

/************************/
/* module initobj.c	*/

/* initialisation du tableau de pointeurs de fonction des constantes */
void initGeneralFuncList(void);

/************************/
/* module obj3d.c	*/

/* mise a jour d'un objet dans le module 3D */
void updateObjectIn3D(WObject *);

/* mise a jour de la camera dans le module 3D */
void updateCameraFromObject(WObject *);

/* stub de la 3D pour les intersections de solides */
int Solid_intersect_2D(Solid, Solid);

/* remplit le champ optional buffer de la 3D avec le pointeur WObject */
void setOptionalBuffer(WObject *);

/************************/
/* module move.c	*/

/* mise a jour de la Bounding Box d'un objet */
void updateBB(WObject *);

/* mvt general d'un user */
void userMovement(long, long, WObject *);

/* mvt general d'un objet */
void objectMovement(long, long, WObject *);

/* mvt permanent general d'un objet */
void objectPermanentMovement(long, long, WObject *);

/* recopie de la position et de la Bounding Box d'un objet
 * au cas ou il y aurait intersection */
void copyPositionAndBB(WObject *, WObject *);


/************************/
/* module initworld.c	*/

/* procedure de fermeture d'un monde */
void quitWorld();
     
/* procedure d'initialisation generale du module Wmgt */
void newWorld(char *);

/* mise a zero des flags "ispointed" de tous les objets * d'un liste */
void clearIspointedFlag(ObjectList);

/* mise a zero des tableaux des temps des touches */
void clearKeyTab(WObject *);

/* remplit les champs filename des fichiers de mapping d'un user */
void findUserTexture(char *, char *, char *);

/************************/
/* module parse.c	*/

int readCfg(void *handleint, void *handleext);

/************************/
/* module col.c		*/

/* renvoie une constante pour decrire l'etat de l'intersection
 * des deux Bounding Boxs */
int interBBs(V3 vcenter1, V3 vsize1, V3 vcenter2, V3 vsize2);

/* renvoie la liste des pointeurs sur les objets touchant
 * la case de la grille ou se trouve l'objet */
ObjectList vicinityObject(WObject *, WObject *);

/* projete le mouvement de l'objet mobile parallelement a l'objet statique
 * quand la normale sera fournie par la 3D */
void projectMovementOnObject(WObject *pmb_object, WObject st_object);

/************************/
/* module net.c		*/

#ifdef WITHOUT_NETWORK
void nameObjectFromStringStub(NetObject *, char *);

/* A appeler apres creation de l'objet */
void declareCreationToNetworkStub(NetObject *);

/* A appeler apres changement de valeur de la propriete */ 
void declareDeltaToNetworkStub(NetObject *, int);

/* A appeler quand on veut detruire l'objet
 * Un "ObjectDelete" sera fait un peu plus tard */
void declareDeletionToNetworkStub(NetObject *);
#endif

int updateObjectToNetwork(WObject *, WObject *);

WObject * copy_object(WObject *);
void update_object(WObject *, WObject *);

void set_xy(WObject *, Payload *);
void set_z(WObject *, Payload *);
void set_a1(WObject *, Payload *);
void set_a2(WObject *, Payload *);
void set_a3(WObject *, Payload *);
void set_msg(WObject *, Payload *);
void set_hname(WObject *, Payload *);
void set_mapface(WObject *, Payload *);
void set_mapback(WObject *, Payload *);
void set_world(WObject *, Payload *);
void set_speed(WObject *, Payload *);
void set_frame(WObject *, Payload *);

void get_xy(WObject *, Payload *);
void get_z(WObject *, Payload *);
void get_a1(WObject *, Payload *);
void get_a2(WObject *, Payload *);
void get_a3(WObject *, Payload *);
void get_msg(WObject *, Payload *);
void get_hname(WObject *, Payload *);
void get_mapface(WObject *, Payload *);
void get_mapback(WObject *, Payload *);
void get_world(WObject *, Payload *);
void get_speed(WObject *, Payload *);
void get_frame(WObject *, Payload *);

/************************/
/* module grid.c	*/

void clearGrid();
void freeGrid();
void placeObjectInGrid(WObject *);

/* ajout d'un pointeur vers un objet dans une liste */
ObjectList addObjectToList(WObject *, ObjectList);

/* suppression d'un pointeur vers un objet dans une liste */
ObjectList deleteObjectFromList(WObject *, ObjectList);

/* desalloue une liste d'objet */
void freeObjectList(ObjectList);

/* concatenation de liste de pointeurs sur objet */
ObjectList addObjectList(ObjectList, ObjectList);

/* concatenation (avec test de "ispointed" et objet) de liste
 * de pointeurs sur objet */
ObjectList addObjectListToList(ObjectList, WObject *, ObjectList);

/* evalue et remplit le tableau igrid, tableaux d'indices de la position
 * de pos dans la grille */
void calculateCoordinatesIntoGrid(float pos[3], int igrid[3]);

/* ajout d'un objet dans la grille */
void insertObjectIntoGrid(WObject *);

/* supprime un objet de la grille */
void deleteObjectFromGrid(WObject *);

/* mise a jour d'un objet dans la grille */
void updateObjectIntoGrid(WObject *, WObject *);

/* procedure de test de la grid: affiche les objets de la grille
 * dans la meme case que le user */
void testGrid(WObject *puser, int color);

/************************/
/* module wmgt.c	*/

/* procedure d'initialisation generale du module Wmgt */
void WmgtInit(char *, char *, char *, char *);

/* procedure de fermeture du module Wmgt */
void quitWMgt();

/* Convertit le format Solid (3D) en WObject */
WObject* getPobjectFromSolid(Solid);

/* Signale au module Gestion du Monde qu'une touche a
 * change d'etat
 * key_id = 0..MAXKEYNUMBER-1 (#define...)
 * key_state = 0..1 (#define...)
 */
void changeKey(int key_id, int etat, long time_s, long time_m);

/* Signale au module Gestion du Monde le message envoye par
 * l'utilisateur.
 */
void userWriting(char *);

/* fonction d'appel aux methodes particulieres de chaque objet */
void specialAction(Solid solid, int action, long time_s, long time_m,...);

void getObjectHumanName(Solid solid, char **human_name, char **pmethodes);
     
/* Lance la mise a jour du monde */
int doWorldCalculation(long, long);

/* Permet de modifier la propriete (sa copie locale). La nouvelle
 * valeur se trouve dans text. Il faut renvoyer la position
 * de lecture de la suite (utiliser scanPayload et sa valeur de retour).
 * Cette fonction est typiquement appelee suite a la reception d'un
 * delta sur le reseau.
 */
void setProperty(NetObject *, u_int8, Payload *);

/* Permet de recuperer la propriete (sa copie locale). Il faut
 * ecrire text et renvoyer la longueur ecrite 
 * (utiliser make_text et sa valeur de retour) 
 * Typiquement appelee pour connaitre text avant d'emettre 
 * un delta.
 */
void getProperty(NetObject *, u_int8, Payload *);

/* Permet de recuperer toutes les proprietes d'un objet. Le text est
 * initialise avant l'appel, et rempli dans la procedure.
 * Typiquement appelee pour connaitre text apres emission
 * d'un declareCreationToNetwork.
 */
void getAllProperties(NetObject *, Payload *);
void setAllProperties(NetObject *, Payload *);

/* Alloue une copie locale pour l'objet , avec initialisation et
 * attribution de tous les champs grace a des setProperty.
 * Typiquement appelee suite a la reception d'un C.
 */
NetObject* createObjectFromNetwork(u_int8, NetObjectId, Payload *);

/* Supprime object du monde.  */
void requestDeletionFromNetwork(NetObject *);

/* Cette fonction renvoie le nombre total de proprietes du type.
 * Elles doivent etre numerotees de 0 a properties_count-1.
 * Cette fonction utilise par exemple un simple tableau constant.
 * Typiquement appelee sur reception d'un C, apres appel a
 * create_object, pour savoir le nombre de set_property a faire.
 */
u_int8 countProperties(u_int8);

/* Function to have a delayed deletion */
void ObjectsDelete() ;
void ObjectDelete(WObject *) ;


#endif /* FUNCS_H */
