#include "global.h"
#include "parse.h"


/* entry parser */
Private
void entryParser(char *l, WObject *pentry)
{
  char *w;

  w = parseFileLine(l);
  w = parsePosition(w, pentry);
}

/* entry creation from a file */
Private
void entryCreateFromFile(Fileline l)
{
  WObject *pentry;

  pentry = (WObject*) malloc(sizeof(WObject));
  memset(pentry, 0, sizeof(WObject));    
  pentry->noh.type = ENTRYTYPE;
  strcpy(pentry->h_name, ENTRYNAME);
  entryParser(l, pentry);
  plocaluser->entryflag = 1;
  plocaluser->x = pentry->x;
  plocaluser->y = pentry->y;
  plocaluser->a1 = pentry->a1;
  free(pentry);
} 

/* functions initialization */
Public
void initEntryFuncList(void)
{
  generalFuncList[ENTRYTYPE].createFromFileline = entryCreateFromFile;
  
  propertiesnumber[ENTRYTYPE] = 0;
}
