#include "global.h"
#include "parse.h"
#include "whiteboard.h"


/* board parser */
Private
void boardParser(char *l, WObject *pboard)
{
  char *w;

  w = parseFileLine(l);
  w = parsePosition(w, pboard);
  pboard->soh = SolidParser(w);
}

/* board initialization from a file */
Private
void createBoardFromFile(Fileline l)
{
  WObject *pboard;

  pboard = (WObject*)malloc(sizeof(WObject));
  memset(pboard, 0, sizeof(WObject));    
  pboard->noh.type = BOARDTYPE;
  boardParser(l, pboard);
  strcpy(pboard->h_name, BOARDNAME);
  updateObjectIn3D(pboard);
  setOptionalBuffer(pboard);
  updateBB(pboard);
  stilllist = addObjectToList(pboard, stilllist);
  insertObjectIntoGrid(pboard);
} 

/* object intersect: stop */
Private
void boardIntersect(WObject *pwoh, WObject *pwohold, WObject *pboard)
{
  copyPositionAndBB(pwohold, pwoh);
}

/* draw */
Private
void boardMethode0(WObject *pboard, long sec, long usec)
{
#ifdef WITHWHITEBOARD
  quitwhiteboard();
  startwhiteboard(curr_chan);
#endif
}

/* board functions initialization */
Public
void initBoardFuncList(void)
{
  generalFuncList[BOARDTYPE].createFromFileline = createBoardFromFile;
  generalFuncList[BOARDTYPE].whenIntersect = boardIntersect;
  
  propertiesnumber[BOARDTYPE] = 0;

  strcpy(generalMethodList[0][BOARDTYPE].name, "Draw");
  generalMethodList[0][BOARDTYPE].method = boardMethode0;
}
