#define REFLECTOR
#define RTP
#define RTCP

/* dates and versions */
#define REFRESH_TIMEOUT 1.5
#ifndef RAND_MAX
#define RAND_MAX 32768
#endif
#define MIN_ASSUME_DELAY (REFRESH_TIMEOUT*5)
#define MAX_ASSUME_DELAY (REFRESH_TIMEOUT*10)
#define MAX_VERSION_JUMP 10

/* packet format */
#define PKTSIZE			512	/* Max packet size */
#define PAYLOAD_HDR_SIZE	7	/* payload header length */
#define PAYLOAD_HDR_HOSTID	1
#define PAYLOAD_HDR_PORTID	5
#define PAYLOAD_HDR_LEN		0
#define RTP_HDR_SIZE		12	/* RTP header length */
#define PAYLOAD_TYPE		105	/* vreng payload type */

/* commands types */
#define CREATE		'C'
#define DELETE		'D'
#define DELTA		'd'
#define QUERY		'?'

/* sockets addresses index */
#define SOCK_RTP	0
#define SOCK_RTCP	1
#define SOCK_UDP	2

/* sockets descriptors */
#define RECV_RTP	0
#define SEND_RTP	1
#define RECV_RTCP	2
#define SEND_RTCP	3
#define RECV_UDP	4
#define SEND_UDP	4


/*** channels ***/
extern Channel *channels_list;		/* channel head */

/*** network ids ***/
extern u_int32 my_ssrcid;		/* ssrc network format*/
extern u_int32 my_hostid;		/* addr_IP network format */
extern u_int16 my_portid;		/* port network format */
extern u_int16 new_objectid;		/* id new object (naming), fmt host */

/*** network counters ***/
extern u_int32 pkts_sent;
extern u_int32 pkts_recvd;
extern u_int32 bytes_sent;
extern u_int32 bytes_recvd;
extern u_int32 sum_pkts_sent;
extern u_int32 sum_pkts_recvd;
extern u_int32 sum_bytes_sent;
extern u_int32 sum_bytes_recvd;
extern u_int32 sum_pkts_lost;
extern struct timeval start_time;

/*** Globales gestion objets/proprietes ***/
extern NetObject *objects_list;	/* list of all objects */

/** all we need to do rtp **/
#include "rtpsess.h"
extern Session *sessions_list;

/* unicast tunnel: Multicast Unicast Proxy */
extern u_int8 mup;
extern u_int32 muphost;
extern u_int16 mupctrlport;
extern u_int16 mupdataport;

