/*
 * Browser tool
 *
 * Philippe Dax
 * Nov 1997
 */

#include "global.h"
#include "mc.h"
#include "browsers.h"

#ifdef WITHHTML

/* global variable */
int browsertool = NETSCAPE_TOOL;
int browserpid = -1;

void startbrowser(char *url)
{
	trace(DBG_TOOL, "browsertool=%d url=%s", browsertool, url);
	if (browsertool == NETSCAPE_TOOL)
		startnetscape("netscape", url);
	else if (browsertool == MMOSAIC_TOOL)
		startmMosaic("mMosaic", url);
	else trace(DBG_TOOL, "unknown browser");
}

void startnetscape(char *browser, char *url)
{
#ifdef WITHNETSCAPE
	int netscapepid = -1, status;
	char openurl[URL_LEN];

#ifdef LAUNCHNETSCAPE
	if (browserpid < 0) {
		browserpid = fork();
		switch (browserpid) {
		case -1:
			trace(DBG_TOOL, "can't fork for %s", browser);
			break;
		case 0:
			execl(NETSCAPEPATH, browser, url, (char *) NULL);
			trace(DBG_TOOL, "can't exec %s", browser);
			exit(1);
		default:
			break;
		}
	}
	else {
#endif
		sprintf(openurl, "openURL(%s)", url);
		netscapepid = fork();
		switch (netscapepid) {
		case -1:
			trace(DBG_TOOL, "can't fork for %s", browser);
			break;
		case 0:
			execl(NETSCAPEPATH, browser, "-remote", openurl, (char *) NULL);
			trace(DBG_TOOL, "can't exec %s", browser);
			exit(1);
		default:
			break;
		}
#ifdef LAUNCHNETSCAPE
	}
#endif
#endif
}

void startmMosaic(char *browser, char *url)
{
#ifdef WITHMMOSAIC
        char *p, *ttl;
	static char mmosaicmc[CHAN_LEN];

        strncpy(mmosaicmc, getbrowsermc(), sizeof(mmosaicmc));
        p = strrchr(mmosaicmc, '/');
        *p = '\0';
        ttl = ++p;
	browserpid = fork();
	switch (browserpid) {
	case -1:
		trace(DBG_TOOL, "can't fork for %s", browser);
		break;
	case 0:
		execl(MMOSAICPATH, browser, "-S", "VReng", "-t", ttl, "-mcDest", mmosaicmc, url, (char *) NULL);
		trace(DBG_TOOL, "can't exec %s", browser);
		exit(1);
	default:
		break;
	}
#endif
}

void mailto()
{
#ifdef NETSCAPEPATH
	int netscapepid = -1;
	char openurl[URL_LEN];

	sprintf(openurl, "mailto()");
	netscapepid = fork();
	switch (netscapepid) {
	case -1:
		trace(DBG_TOOL, "can't fork for netscape");
		break;
	case 0:
		execl(NETSCAPEPATH, "netscape", "-remote", openurl, (char *) NULL);
		trace(DBG_TOOL, "can't exec netscape");
		exit(1);
	default:
		break;
	}
#endif
}

void addBookmark(char *browser, char *url)
{
#ifdef WITHNETSCAPE
	int netscapepid = -1;
	char openurl[URL_LEN];

	sprintf(openurl, "addBookmark(%s)", url);
	netscapepid = fork();
	switch (netscapepid) {
	case -1:
		trace(DBG_TOOL, "can't fork for %s", browser);
		break;
	case 0:
		execl(NETSCAPEPATH, browser, "-remote", openurl, (char *) NULL);
		trace(DBG_TOOL, "can't exec %s", browser);
		exit(1);
	default:
		break;
	}
#endif
}

void quitbrowser()
{
	if (browserpid > 0) {
		kill(browserpid, SIGKILL);
		browserpid = -1;
	}
}

char * getbrowsermc()
{
        static char browsermc[CHAN_LEN], group[GROUP_LEN];
        unsigned short port;

        port = getvrport(curr_chan);
        strncpy(group, getvrgroup(curr_chan), sizeof(group));
        strncpy(browsermc, createmc(group, port, ttlorigin), sizeof(browsermc));
        trace(DBG_TOOL, "browsermc=%s", browsermc);
        return(browsermc);
}

#endif /* WITHHTML */
