/*
 * Audio tool
 *
 * Philippe Dax
 * Oct 1997
 */

#include "global.h"
#include "audio.h"
#include "mc.h"

#ifdef WITHAUDIO

/* global variable */
int audiotool = VAT_TOOL;
int audiopid = -1;
int audiobusy = 0;


void startaudio(char *mc)
{
	static char audiomc[CHAN_LEN];
	char ttlstr[4];

	strncpy(audiomc, getaudiomc(mc), sizeof(audiomc));
	sprintf(ttlstr, "%d", ttlorigin);
	audiopid = fork();
	switch (audiopid) {
	case -1:
		trace(DBG_TOOL, "can't fork for audio");
		break;
	case 0:
#ifdef WITHVAT
		if (audiotool == VAT_TOOL) {
		execl(VATPATH, "vat", "-aAsM", "-C", "VReng", "-t", ttlstr, audiomc,
			(char *) NULL);
		trace(DBG_TOOL, "can't exec vat");
		}
#endif
#ifdef WITHRAT
		if (audiotool == RAT_TOOL) {
		execl(RATPATH, "rat", "-f", "pcm", "-C", "VReng", "-t", ttlstr, audiomc,
			(char *) NULL);
		trace(DBG_TOOL, "can't exec rat");
		}
#endif
#ifdef WITHFPHONE
		if (audiotool == FPHONE_TOOL) {
		execl(FPHONEPATH, "fphone", "/T", ttlstr, audiomc,
			(char *) NULL);
		trace(DBG_TOOL, "can't exec fphone");
		}
#endif
		exit(1);
	default:
		break;
	}
}

void quitaudio()
{
	if (audiopid > 0) {
		kill(audiopid, SIGKILL);
	}
}

char * getaudiomc(char *mc)
{
	static char audiomc[CHAN_LEN], group[GROUP_LEN];
	unsigned short port;

        port = getvrport(mc);
	port += 2;
	if (port % 1)
		port++;	/* even port for RTP */
	strncpy(group, getvrgroup(mc), sizeof(group));
	strncpy(audiomc, createmc(group, port, ttlorigin), sizeof(audiomc));
	trace(DBG_TOOL, "audiomc=%s", audiomc);
	return(audiomc);
}

#endif /* WITHAUDIO */

void playsound(char *sound)
{
#ifdef WITHAUDIO
	int r, w, fdaudio, fdsound;
	struct stat audiostat;
	char bufaudio[512];

	if (audiobusy)
		return;
	if (stat(sound, &audiostat) == 0) {
		if ((fdsound = open(sound, 0)) < 0) {
			trace(DBG_TOOL, "can't open %s", sound);
		}
		else if ((fdaudio = open(DEVAUDIO, 1)) < 0) {
			perror("open devaudio");
		}
		else {
			while ((r = read(fdsound, bufaudio, sizeof(bufaudio)))) {
				if ((w = write(fdaudio, bufaudio, r)) < 0 ) {
					perror("write audio");
					break;
				}
			}
			close(fdsound);
			close(fdaudio);
		}
	}
#endif /* WITHAUDIO */
}
