/*
   File     : mainloop.c
   Author   : Lionel ULMER
   Creation : 04/12/96

   Virtual Reality ENGine

   File containing the main loop handling events.
*/

#include <X11/Intrinsic.h>

#include "global.h"
#include "defaults.h"
#include "initui.h"
#include "initfuncs.h"
#include "supportfuncs.h"
#include "mainloop.h"

int iconified = 0;


void mainLoop()
{
  int i, cfn = 0;
  int event_cnt, event_redisp_delay = 0;
  long secs[NBPICMEAN], usecs[NBPICMEAN];
  double ftime, fps;
  struct timeval tv;
  XtInputMask im;
  XEvent ev;

  /* create time-outs */
  XtAppAddTimeOut(appContext, NET_TIMEOUT, TimeOut, (XtPointer) NETTO);

  /* init sockets observation */
  id_fd = (XtInputId *) malloc(cnt_fd * sizeof(XtInputId));
  for (i = 0; i < cnt_fd; i++) {
    id_fd[i] = XtAppAddInput(appContext, tab_fd[i],
		     (XtPointer)XtInputReadMask, FDEvent, (XtPointer) NETFD);
  }

  /* Main loop */
  while (1) {
    if (iconified) {
      XtAppPeekEvent(appContext, &ev);
      trace(DBG_WIN, "Event");
    }
    evthandle = 1;

#ifdef OPTIM_LOOP
    /* increment  event_redisp_delay in interval [0..MIN_EVENT_REDISP-1] */
    event_redisp_delay++;
    event_redisp_delay %= MIN_EVENT_REDISP;
    for (event_cnt = 0;                    
         event_cnt < MAX_EVENT_CNT && (im = XtAppPending(appContext));    
         event_cnt++) {
#else
    while ((im = XtAppPending(appContext))) {
#endif
      XtAppProcessEvent(appContext, im); /* events to handle */
    }

    if (!iconified) {      
      gettimeofday(&tv, NULL);
#ifdef STAT_FRAMES
      secs[cfn] = tv.tv_sec;
      usecs[cfn] = tv.tv_usec;
      ftime = (double) (secs[cfn] - secs[(cfn+1) % NBPICMEAN]) +
	               (usecs[cfn] - usecs[(cfn+1) % NBPICMEAN]) / 1000000.0;
      fps = (double) NBPICMEAN / ftime;
      cfn = (cfn+1) % NBPICMEAN;
      /* trace(DBG_FORCE, "cfn=%d fps=%2.2f", cfn, fps); */
#endif

      doWorldCalculation(tv.tv_sec, tv.tv_usec); /* compute the world */

#ifdef OPTIM_LOOP
      /* S'il y a un vnement, on le traite et on ne fait pas le
       * rendering, sauf si on doit le faire  cause du dlai dj expir
       * sans raffraichissement.                                         
       */
      if (event_redisp_delay && (im = XtAppPending(appContext))) {
        XtAppProcessEvent(appContext, im);                            
        continue;                            
      }
#endif

      Render();	/* compute the 3D */
      GLwDrawingAreaSwapBuffers(threeDWidget);
      XFlush(display);
       
      /* we can do a new cycle */
      event_redisp_delay = 0;                                           
    }
  }
  /* NOT_REACHED */
}

/* called when we iconify the window in order to suppress redraws */
void mapWin3D(Widget w, XEvent *ev, String *s, Cardinal *c)
{
  trace(DBG_WIN, "Map: %s", *s);
  if (*s[0] == 'm') {
    iconified = 0; /* Widget displayed */
  }
  else {
    iconified = 1; /* Widget iconified */
    XtAppAddTimeOut(appContext, WMGT_TIMEOUT, TimeOut, (XtPointer) WMGTTO);
  }
}
