/*
   File     : log.c
   Author   : Lionel ULMER
   Creation : 07/12/96

*/

#include "global.h"
#include "initui.h"		/* statusLabel */
#include "initfuncs.h"		/* QuitVreng() */
#include "supportfuncs.h"	/* writeLabelStatus() */


static int infatal = 0;


Public
void fatal(char *s,...)
{
  va_list ap;

  va_start(ap, s);
  vfprintf(stderr, s, ap);
  fprintf(stderr, "\n");
  va_end(ap);
  if (!infatal) {
    infatal = 1;
    QuitVreng(-1);
  }
}

Public
void warning(char *s,...)
{
  va_list ap;
  char buf[BUFSIZ];
  
  va_start(ap, s);
  if (debug || (statusLabel == NULL)) {
    vfprintf(stderr, s, ap);
    fprintf(stderr, "\n");
  } else {
    vsprintf(buf, s, ap);
    writeLabelStatus(buf);
    vfprintf(stderr, s, ap);
    fprintf(stderr, "\n");
  }
  va_end(ap);
}

Public
void notice(char *s,...)
{
  va_list ap;
  char buf[BUFSIZ];
  
  va_start(ap, s);
  if (statusLabel != NULL) {
    vsprintf(buf, s, ap);
    writeLabelStatus(buf);
  }
  va_end(ap);
}

Public
void trace(int dbgmask, char *s,...)
{
  va_list ap;

  if (debug & (1 << dbgmask) || dbgmask == DBG_FORCE) {
    va_start(ap, s);
    vfprintf(stderr, s, ap);
    fprintf(stderr, "\n");
    va_end(ap);
  }
}

Public
FILE * writelog(char *s,...)
{
  va_list ap;
  char logfile[PATH_LEN];
  static FILE *fl = (FILE *) NULL;

  if (fl == (FILE *) NULL) {
    sprintf(logfile, "%s/log", vrengdir);
    unlink(logfile);
    if ((fl = fopen(logfile, "w")) == NULL) {
      perror("open log");
      return((FILE *) NULL);
    }
  }
  va_start(ap, s);
  vfprintf(fl, s, ap);
  fprintf(fl, "\n");
  va_end(ap);
  return(fl);
}

Public
void closelog(FILE * fl)
{
  fclose(fl);
}

Public
void printlog()
{
  FILE *fl;
  char logfile[PATH_LEN];
  char buf[BUFSIZ];

  sprintf(logfile, "%s/log", vrengdir);
  if ((fl = fopen(logfile, "r")) == NULL) {
    perror("open log");
    return;
  }
  while (fgets(buf, sizeof(buf), fl) != NULL)
    fputs(buf, stderr);
  closelog(fl);
}
