/*----------------------------------------------------------------------*/
/*                                keys.h                                */
/*----------------------------------------------------------------------*/
/* Dealing with key binding for TCL/Tk interface.                       */
/*----------------------------------------------------------------------*/
/* Adrien Felon <felon@infres.enst.fr> - 10 Sep 1999                    */
/*----------------------------------------------------------------------*/
#ifndef KEYS_H
#define KEYS_H

#undef WANT_TCL

#ifdef WANT_TCL
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

/* Include TCL/Tk header files */
#include <tcl.h> /* ClientData type */
#include <tk.h>
#endif

/*
 * This module actually process Key event from X and maps keyboard to
 * world management keys definition
 */

/* X-Keyboard keys definition */
#define K_UP 0x0001	/* UP */
#define K_DO 0x0002	/* DOWN */
#define K_LE 0x0004	/* LEFT */
#define K_RI 0x0008	/* RIGHT */
#define K_AL 0x0010	/*  */
#define K_PU 0x0020	/* PAGE UP */
#define K_PD 0x0040	/* PAGE DOWN */
#define K_HO 0x0080	/* HOME */
#define K_IN 0x0100	/* INSERT */
#define K_DE 0x0200	/* DEL */
#define K_EN 0x0400	/* END */
#define K_KL 0x0800	/* KP LEFT */
#define K_KR 0x1000	/* KP RIGHT */

/* Keys needed by VREng world management module */
#define KEY_AV		0
#define KEY_AR		1
#define KEY_DR		2
#define KEY_GA		3
#define KEY_SD		4
#define KEY_SG		5
#define KEY_MT		6
#define KEY_DE		7
#define KEY_HZ		8
#define KEY_JD		9
#define KEY_JU		10
#define KEY_VI		11	/* speeder */
#define KEY_TL		12
#define KEY_TR		13
#define MAXKEYS		14

#define KEY_UP		0
#define KEY_DOWN	1

/* A macro to actually manage a key event */
#define DOKEY(touche,samt,invtouche,saminvt)               \
   if (key_up) {                                           \
      keystatus &= ~touche;                                \
      if (keystatus & invtouche) {                         \
	changeKey(saminvt, KEY_DOWN, t.tv_sec, t.tv_usec); \
      } else {                                             \
	changeKey(samt, KEY_UP, t.tv_sec, t.tv_usec);      \
      }                                                    \
    } else {                                               \
      keystatus |= touche;                                 \
      if (keystatus & invtouche) {                         \
	changeKey(saminvt, KEY_UP, t.tv_sec, t.tv_usec);   \
      } else {                                             \
	changeKey(samt, KEY_DOWN, t.tv_sec, t.tv_usec);    \
      }                                                    \
    }

extern int grabactive;
extern int keystatus;

#ifdef WANT_TCL
/*
 * Event procedure to handle specific key events.
 * Proc is registered with a Tk_CreateEventHandler() call in file
 * "tkAppInit.c"
 */
void KeyEventProc(ClientData clientData, XEvent *eventPtr);
#endif

#endif /* KEYS_H */
