/*
   File     : initfuncs.c
   Author   : Lionel ULMER
   Creation : 04/12/96

     Fonctions d'initialisation et de fin : allocation de la memoire
   partagee, des GC, ouverture des FD...
*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xlib.h>
#ifdef MOTIF
#include <Xm/XmCall.h>
#include "GLwMDrawA.h"
#else
#include "GLwDrawA.h"
#endif

#include "global.h"
#include "initui.h"
#include "initfuncs.h"
#include "chat.h"
#include "supportfuncs.h"
#include "widget.h"

Display *display;	/* The Display */
int startX, startY;	/* Debut en X et Y de la 3D dans la widget */
int todisp;		/* Indique si y'a qqchose a afficher */
int cpopup, cbutton;	/* Gestion du popup-menu */
#ifndef WANT_TCL
Colormap cmap;		/* colormap used */
#endif

/* Variable globales du fichier */
static int inquit=0;
static Visual *visual;		/* Visual */
static Screen *screen;          /* Le Screen */
static int depth;               /* La profondeur des couleurs */
static int x11error;            /* Si non nulm indique une erreur fatale X */
static int (*orgx11err)(Display *, XErrorEvent *); /* Handler original des erreurx X */

/* GL initialisation */
static int dblBuf[]={GLX_RGBA, GLX_DEPTH_SIZE, 16, GLX_DOUBLEBUFFER, None};


/* Fonction XErrors : gestion des erreurs sous X */
Private
int XErrors(Display *d, XErrorEvent *ev)
{
  /* errors for shared-mem... */
  if (ev->request_code == 129) {
    fprintf(stderr, "Shared memory unavailable.\n");
    x11error = 1;
  } else {
    /* free shared-mem */
    QuitVreng(0);
    orgx11err(d, ev);
    exit(-1);
  }
  return 0;
}

#ifndef WANT_TCL

/* Convertisseur des couleurs Xt => couleurs de la cmap prive  */
Private
Boolean colorToPixel(Display *dsp,XrmValue *args,Cardinal *c,
		     XrmValue *fv,XrmValue *tv,XtPointer *dd)
{
  static Pixel pix;
  char *value;
  XColor cs, ce;
  int status;

  if (!strcmp(fv->addr, "XtDefaultBackground"))
    value = "white";
  else if (!strcmp(fv->addr, "XtDefaultForeground"))
    value = "black";
  else
    value = fv->addr;
  
  status = XAllocNamedColor(dsp, cmap, value, &cs, &ce);
  pix=cs.pixel;
  
  tv->size=sizeof(Pixel);
  tv->addr=(XtPointer) &pix;

  trace(DBG_WIN, " -> %s %d", (char *) fv->addr, pix);
  return True;
}

Private
void initGLZone(Widget w)
{
  Display *display;
  int dummy, screen;
  
  /* Initialisation de la fentre 3D */
  display = XtDisplay(w);
  screen = DefaultScreen(display);
  
  /* Searches if GLX is supported */
  if (!glXQueryExtension(display, &dummy, &dummy))
    fatal("X server has no OpenGL GLX extension");
  
  /* Find an OpenGL-capable RGB visual with depth buffer. */
  glvisual = glXChooseVisual(display, screen, dblBuf);
  if (glvisual == NULL)
    fatal("no RGB visual with depth buffer");
  
  if (depth == 8) {
    cmap = XCreateColormap(display, RootWindow(display, screen),
			   glvisual->visual, AllocNone);
    XInstallColormap(display, cmap);

    /* Dtourne la convertion de type pour les couleurs */
    XtAppSetTypeConverter(appContext, XtRString, XtRPixel, colorToPixel,
			  (XtConvertArgList) NULL, 0, XtCacheAll, NULL);
  } else {
    cmap = DefaultColormapOfScreen(XtScreen(w));
  }

  /* Create an OpenGL rendering context. */
  glxc = glXCreateContext(display, glvisual, None, True);
  if (glxc == NULL)
    fatal("could not create rendering context");
}


/* Fonction XInit : initialisation des ressources Xlib */
Public
int XInit(Widget w)
{
  int i;
  XVisualInfo visual_info;
  
  /* Initialise la variable display */
  display = XtDisplay(w);
  screen = XtScreen(w);
  depth = DefaultDepth(display, DefaultScreen(display));
  trace(DBG_WIN, "Xinit: depth = %d", depth);

  /* Test de la profondeur des couleurs */
  if ((depth!=8) && (depth!=16) && (depth!=24)) {
    trace(DBG_WIN, "VREng only supports 8,16,24 bits visuals, depth=%d", depth);
    return -1;
  }

  /* Initialise OpenGL (and thus, the visual) ... */
  initGLZone(w);
  visual = glvisual->visual;
  
  /* Enlve l'auto-repeat */
  XAutoRepeatOff(display);

  /* Gestion des erreurs */
  x11error=0;
  orgx11err=XSetErrorHandler(XErrors);

  /* Initialisation de l'history */
  histpos=0;
  histtab=(char **) malloc(history*sizeof(char *));
  for (i=0;i<history;i++)
    histtab[i]=NULL;

  /* Initialisations diverses */
  cpopup=0;

  /* Initialise la mmoire partage */
  startX=0;
  startY=0;

  /* todisp=0 => en cas d'expose, pas de redessinement */
  todisp=0;

  return 0;
}

#endif /* WANT_TCL */

/* quit VREng */
Public
void QuitVreng(int i)
{  
  if (inquit)
    return ;
  inquit=1;

  /* Remet le clavier dans l'tat initial */
  XAutoRepeatOn(display);

  /* Empche l'accs  la statur bar */
#ifndef WANT_TCL
  statusLabel = NULL;
#endif
  
  /* Ferme le display */
  XCloseDisplay(display);
  
  /* Ferme les modules */
  if (zlibinit)
    RenderClose();
  if (worldinit)
    quitWMgt();

  /* stat Network */
  statNetwork();

  /* quit if i!=0 (to eventually call Xerrors) */
  if (i)
    exit(i);
}

Private
void quitSig(int sig)
{
  fprintf(stderr, "Got signal %d, aborting VREng.\n", sig);
  QuitVreng(sig);
}

Private
void reapchild(int sig)
{
#if HAVE_WAIT3
	union wait s;
#endif

#if HAVE_WAITPID
        while (waitpid(-1, 0, WNOHANG) > 0 )
#else
#if HAVE_WAIT3
        while (wait3(&s, WNOHANG, NULL) > 0 )
#else
	while (wait(NULL) != -1 )
#endif
#endif
		;
}

Public
void initSignals(void)
{
  int i;

  for (i=1; i < SIGALRM; i++)
    signal(i, quitSig);
  signal(SIGCHLD, reapchild);
}

Public
void initEnv(void)
{
  char *home;
  char pathenvdir[PATH_LEN], pathprefs[PATH_LEN], pathcache[PATH_LEN];
  struct stat bufstat;

  if ((home = getenv("HOME")) == 0)
    return;
  sprintf(pathenvdir, "%s/.vreng", home);
  if (stat(pathenvdir, &bufstat) < 0) {
    mkdir(pathenvdir, 0700);
  }
  strncpy(vrengdir, pathenvdir, sizeof(pathenvdir));
  chdir(pathenvdir);
  sprintf(pathprefs, "%s/prefs", pathenvdir);
  if (stat(pathprefs, &bufstat) == 0) {
    strncpy(vrengprefs, pathprefs, sizeof(pathprefs));
  }
  sprintf(pathcache, "%s/cache", pathenvdir);
  if (stat(pathcache, &bufstat) < 0) {
    mkdir(pathcache, 0700);
  }
  strncpy(vrengcache, pathcache, sizeof(pathcache));
}
