/* # skkinput (Simple Kana-Kanji Input)
 * attrs.h
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef attrs_h
#define attrs_h

#define CASpotLocation		((unsigned long)1L << 1)
#define CAFocusWindow		((unsigned long)1L << 2)
#define CAClientArea		((unsigned long)1L << 3)
#define CAStatusArea		((unsigned long)1L << 4)
#define CAColormap		((unsigned long)1L << 5)
#define CAColor			((unsigned long)1L << 6)
#define CABackgroundPixmap	((unsigned long)1L << 7)
#define CALineSpacing		((unsigned long)1L << 8)
#define CAFonts			((unsigned long)1L << 9)
#define CACursor		((unsigned long)1L <<10)

struct ConvAttrs {
  Position	spot_x, spot_y ;
  Window	focus_window ;
  XRectangle	client_area ;
  XRectangle	status_area ;
  Colormap	colormap ;
  Pixel		foreground, background ;
  struct skkinputManagedFont	**fontset ;
  Dimension	linespacing ;
  /* ̵뤹롣ͳϰ٤ˤȼݤ顣*/
#if 0
  Pixmap	background_pixmap ;
  Cursor	cursor ;
#endif
} ;

/*
 * Widget ֤ǥåѤ빽¤Ρ
 *-------
 * ǸåϡXtSetValue ڤ XtGetValue ˤäƼϤ
 * 롣
 */
struct ConvAttrsMesg {
  unsigned long		mask ;
  struct ConvAttrs	value ;
} ;

#endif
