/*  Sclient
 *  Copyright (C) 1999 Heathen (the.heathen@swipnet.se)
 *		  1999 Drizzt  (doc.day@swipnet.se)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <glib.h>

#include "window.h"
#include "config.h"
#include "pixmaps.h"	// ToolBar Icons

void destructify()
{
    gtk_widget_hide (win);
    return;
}

void close_window (GtkWidget *widget, gpointer data)
{
    gtk_widget_destroy (GTK_WIDGET (data));
}

void quit (GtkWidget *widget, gpointer data)
{
    if (mud->LOGGING)
        fclose (mud->LOG_FILE);
    gtk_main_quit();
}

void do_con()
{
    char *port;
    char *host;
    gchar buf[256];

    port = (char *)malloc(10);
    host = (char *)malloc(1000);

    host = gtk_entry_get_text(GTK_ENTRY(mud->hostentry));
    port = gtk_entry_get_text(GTK_ENTRY(mud->portentry));
	
    make_connection(host,port);
    sprintf (buf, "Connected to %s - SClient %s", host, VERSION);
    gtk_window_set_title (GTK_WINDOW (mud->window), buf);
    return;
}

void cbox()
{
    GtkWidget *con_window;
    GtkWidget *table_main;
    GtkWidget *frame;
    GtkWidget *table_frame;
    GtkWidget *label_host;
    GtkWidget *label_port;
    GtkWidget *table_button;
    GtkWidget *hbuttonbox;
    GtkWidget *button_connect;
    GtkWidget *button_cancel;

    con_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_object_set_data (GTK_OBJECT (con_window), "con_window", con_window);
    gtk_window_set_title (GTK_WINDOW (con_window), "SClient Connection");
    gtk_window_set_policy (GTK_WINDOW (con_window), TRUE, TRUE, FALSE);

    table_main = gtk_table_new (2, 1, FALSE);
    gtk_object_set_data (GTK_OBJECT (con_window), "table_main", table_main);
    gtk_widget_show (table_main);
    gtk_container_add (GTK_CONTAINER (con_window), table_main);
    gtk_container_set_border_width (GTK_CONTAINER (table_main), 3);

    frame = gtk_frame_new ("Connect To");
    gtk_object_set_data (GTK_OBJECT (con_window), "frame", frame);
    gtk_widget_show (frame);
    gtk_table_attach (GTK_TABLE (table_main), frame, 0, 1, 0, 1,
                     (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 3);
    gtk_frame_set_label_align (GTK_FRAME (frame), 0.03, 0.5);

    table_frame = gtk_table_new (2, 2, FALSE);
    gtk_object_set_data (GTK_OBJECT (con_window), "table_frame", table_frame);
    gtk_widget_show (table_frame);
    gtk_container_add (GTK_CONTAINER (frame), table_frame);
    gtk_container_set_border_width (GTK_CONTAINER (table_frame), 5);
    gtk_table_set_row_spacings (GTK_TABLE (table_frame), 5);
    gtk_table_set_col_spacings (GTK_TABLE (table_frame), 4);

    label_host = gtk_label_new ("Host");
    gtk_object_set_data (GTK_OBJECT (con_window), "label_host", label_host);
    gtk_widget_show (label_host);
    gtk_table_attach (GTK_TABLE (table_frame), label_host, 0, 1, 0, 1,
                     (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

    label_port = gtk_label_new ("Port");
    gtk_object_set_data (GTK_OBJECT (con_window), "label_port", label_port);
    gtk_widget_show (label_port);
    gtk_table_attach (GTK_TABLE (table_frame), label_port, 0, 1, 1, 2,
                     (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

    mud->portentry = gtk_entry_new ();
    gtk_object_set_data (GTK_OBJECT (con_window), "mud->portentry", mud->portentry);
    gtk_widget_show (mud->portentry);
    gtk_table_attach (GTK_TABLE (table_frame), mud->portentry, 1, 2, 1, 2,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

    mud->hostentry = gtk_entry_new ();
    gtk_object_set_data (GTK_OBJECT (con_window), "mud->hostentry", mud->hostentry);
    gtk_widget_show (mud->hostentry);
    gtk_table_attach (GTK_TABLE (table_frame), mud->hostentry, 1, 2, 0, 1,
                     (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

    table_button = gtk_table_new (1, 1, FALSE);
    gtk_object_set_data (GTK_OBJECT (con_window), "table_button", table_button);
    gtk_widget_show (table_button);
    gtk_table_attach (GTK_TABLE (table_main), table_button, 0, 1, 1, 2,
                     (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 2, 0);
    gtk_container_set_border_width (GTK_CONTAINER (table_button), 4);

    hbuttonbox = gtk_hbutton_box_new ();
    gtk_object_set_data (GTK_OBJECT (con_window), "hbuttonbox", hbuttonbox);
    gtk_widget_show (hbuttonbox);
    gtk_table_attach (GTK_TABLE (table_button), hbuttonbox, 0, 1, 0, 1,
                     (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
    gtk_widget_set_usize (hbuttonbox, 219, -1);
    gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox), GTK_BUTTONBOX_SPREAD);
    gtk_button_box_set_child_size (GTK_BUTTON_BOX (hbuttonbox), 72, 25);

    button_connect = gtk_button_new_with_label ("Connect");
    gtk_object_set_data (GTK_OBJECT (con_window), "button_connect", button_connect);
    gtk_signal_connect (GTK_OBJECT (button_connect), "clicked",
                        GTK_SIGNAL_FUNC (do_con), &mud);
    gtk_signal_connect (GTK_OBJECT (button_connect), "clicked",
                        GTK_SIGNAL_FUNC (close_window), con_window);
    gtk_widget_show (button_connect);
    gtk_container_add (GTK_CONTAINER (hbuttonbox), button_connect);
    gtk_container_border_width (GTK_CONTAINER (button_connect), 3);

    button_cancel = gtk_button_new_with_label ("Cancel");
    gtk_object_set_data (GTK_OBJECT (con_window), "button_cancel", button_cancel);
    gtk_signal_connect (GTK_OBJECT(button_cancel), "clicked", 
                        GTK_SIGNAL_FUNC (close_window), con_window);
    gtk_widget_show (button_cancel);
    gtk_container_add (GTK_CONTAINER (hbuttonbox), button_cancel);
    gtk_container_border_width (GTK_CONTAINER (button_cancel), 3);

    gtk_widget_show (con_window);

}


void macro_send (GtkWidget *widget, gint button)
{
    switch (button) {
      case F1:
               alt_send_to_connection(macro_list->F1);
               break;
      case F2:
               alt_send_to_connection(macro_list->F2);
               break;
      case F3:
               alt_send_to_connection(macro_list->F3);
               break;
      case F4:
               alt_send_to_connection(macro_list->F4);
               break;
      case F5:
               alt_send_to_connection(macro_list->F5);
               break;
      case F6:
               alt_send_to_connection(macro_list->F6);
               break;
      case F7:
               alt_send_to_connection(macro_list->F7);
               break;
      case F8:
               alt_send_to_connection(macro_list->F8);
               break;
      case F9:
               alt_send_to_connection(macro_list->F9);
               break;
      case F10:
               alt_send_to_connection(macro_list->F10);
               break;
      default:
               break;
    }
}

/*
 * This Function vil toggle the logger
 */
void toggle_logger (GtkWidget *menuitem, gpointer data)
{
    /* Toggle the toolbar logger button and do the stuff */
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(btn_toolbar_logger), GTK_CHECK_MENU_ITEM(menuitem)->active);
}

/*
 * This Function creates the main window
 */
GtkWidget *spawn_gui()
{
  GtkWidget *window=mud->window;
  GtkWidget *vbox1;
  GtkWidget *menubar;
  GtkWidget *menu_File;
  GtkWidget *menu_File_menu;
  GtkWidget *menu_File_Connection_Wizard;
  GtkWidget *separator1;
  GtkWidget *separator2;
  GtkWidget *separator3;
  GtkWidget *menu_File_Quit;
  GtkWidget *menu_Options;
  GtkWidget *menu_Options_menu;
  GtkWidget *menu_Options_Fonts;
  GtkWidget *menu_Options_Colors;
  GtkWidget *menu_Options_Preference;
  GtkWidget *menu_Tools;
  GtkWidget *menu_Tools_menu;
  GtkWidget *menu_Tools_Macro;
  GtkWidget *menu_Tools_Alias;
  GtkWidget *menu_Tools_Trigger;
  GtkWidget *menu_Tools_LogViewer;
  GtkWidget *menu_Help;
  GtkWidget *menu_Help_menu;
  GtkWidget *menu_Help_About;
  GtkWidget *menu_Help_Manual;
  GtkWidget *vbox2;
  GtkWidget *hbox1;
  GtkWidget *frame;
  GtkWidget *table;
  GtkWidget *label_f1;
  GtkWidget *label_f2;
  GtkWidget *label_f3;
  GtkWidget *label_f4;
  GtkWidget *label_f5;
  GtkWidget *label_f6;
  GtkWidget *label_f7;
  GtkWidget *label_f8;
  GtkWidget *label_f9;
  GtkWidget *label_f10;
  GtkAccelGroup *accel_group;
  GtkWidget *button_f1;
  GtkWidget *button_f2;
  GtkWidget *button_f3;
  GtkWidget *button_f4;
  GtkWidget *button_f5;
  GtkWidget *button_f6;
  GtkWidget *button_f7;
  GtkWidget *button_f8;
  GtkWidget *button_f9;
  GtkWidget *button_f10;
  GtkWidget *fill_block2;
  GtkWidget *vscrollbar;
  GtkWidget *hbox2;
  GtkWidget *fill_block;
  /*** ToolBar ***/
  GtkWidget *toolbar;
  GdkPixmap *icon;
  GdkBitmap *mask;
  GtkWidget *iconw;
  GtkWidget *btn_toolbar_connection_wizard,
            *btn_toolbar_font,
            *btn_toolbar_prefs,
            *btn_toolbar_colors,
            *btn_toolbar_alias,
            *btn_toolbar_macro,
            *btn_toolbar_trigger,
            *btn_toolbar_logview,
            *btn_toolbar_help;
  /*** ToolBar End ***/

  /* create the main window */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (window), "window", window);
  gtk_widget_set_usize (window, 695, 450);
  gtk_container_border_width (GTK_CONTAINER (window), 3);
  gtk_window_set_title (GTK_WINDOW (window), "SClient "VERSION"");
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, TRUE, FALSE);

  /* handlers so we can quit the close the app */
  gtk_signal_connect (GTK_OBJECT (window), "delete_event", GTK_SIGNAL_FUNC (quit), NULL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy", GTK_SIGNAL_FUNC (quit), NULL);

  /* create the accel_group for the keyboard bindings */
  accel_group = gtk_accel_group_new ();
  gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window), "vbox1", vbox1);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (window), vbox1);

  /* menu bar */
  menubar = gtk_menu_bar_new ();
  gtk_object_set_data (GTK_OBJECT (window), "menubar", menubar);
  gtk_widget_show (menubar);
  gtk_box_pack_start (GTK_BOX (vbox1), menubar, FALSE, TRUE, 3);

  /* file menu */
  menu_File = gtk_menu_item_new_with_label ("File");
  gtk_object_set_data (GTK_OBJECT (window), "menu_File", menu_File);
  gtk_widget_show (menu_File);
  gtk_container_add (GTK_CONTAINER (menubar), menu_File);

  menu_File_menu = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (window), "menu_File_menu", menu_File_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_File), menu_File_menu);

  menu_File_Connection_Wizard = gtk_menu_item_new_with_label ("Connection Wizard");
  gtk_object_set_data (GTK_OBJECT (window), "menu_File_Connection_Wizard", menu_File_Connection_Wizard);
  gtk_widget_show (menu_File_Connection_Wizard);
  gtk_container_add (GTK_CONTAINER (menu_File_menu), menu_File_Connection_Wizard);
  gtk_signal_connect (GTK_OBJECT (menu_File_Connection_Wizard), "activate",
                      GTK_SIGNAL_FUNC (do_wiz),
                      NULL);
  gtk_widget_add_accelerator (menu_File_Connection_Wizard, "activate", accel_group,
                              GDK_W, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);

  separator1 = gtk_menu_item_new ();
  gtk_object_set_data (GTK_OBJECT (window), "separator1", separator1);
  gtk_widget_show (separator1);
  gtk_container_add (GTK_CONTAINER (menu_File_menu), separator1);

  menu_File_Connect = gtk_menu_item_new_with_label ("Connect");
  gtk_object_set_data (GTK_OBJECT (window), "menu_File_Connect", menu_File_Connect);
  gtk_widget_show (menu_File_Connect);
  gtk_container_add (GTK_CONTAINER (menu_File_menu), menu_File_Connect);
  gtk_signal_connect (GTK_OBJECT (menu_File_Connect), "activate",
                      GTK_SIGNAL_FUNC (cbox),
                      NULL);
  gtk_widget_add_accelerator (menu_File_Connect, "activate", accel_group,
                              GDK_C, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);

  menu_File_DisConnect = gtk_menu_item_new_with_label ("DisConnect");
  gtk_object_set_data (GTK_OBJECT (window), "menu_File_DisConnect", menu_File_DisConnect);
  gtk_widget_show (menu_File_DisConnect);
  gtk_container_add (GTK_CONTAINER (menu_File_menu), menu_File_DisConnect);
  gtk_signal_connect (GTK_OBJECT (menu_File_DisConnect), "activate",
                      GTK_SIGNAL_FUNC (disconnect),
                      NULL);
  gtk_widget_add_accelerator (menu_File_DisConnect, "activate", accel_group,
                              GDK_D, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);

  separator2 = gtk_menu_item_new ();
  gtk_object_set_data (GTK_OBJECT (window), "separator2", separator2);
  gtk_widget_show (separator2);
  gtk_container_add (GTK_CONTAINER (menu_File_menu), separator2);

  menu_File_Quit = gtk_menu_item_new_with_label ("Quit");
  gtk_object_set_data (GTK_OBJECT (window), "menu_File_Quit", menu_File_Quit);
  gtk_widget_show (menu_File_Quit);
  gtk_container_add (GTK_CONTAINER (menu_File_menu), menu_File_Quit);
  gtk_signal_connect (GTK_OBJECT (menu_File_Quit), "activate",
                      GTK_SIGNAL_FUNC (quit),
                      NULL);
  gtk_widget_add_accelerator (menu_File_Quit, "activate", accel_group,
                              GDK_Q, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);

  gtk_widget_set_sensitive (menu_File_DisConnect, FALSE);

  /* options menu */
  menu_Options = gtk_menu_item_new_with_label ("Options");
  gtk_object_set_data (GTK_OBJECT (window), "menu_Options", menu_Options);
  gtk_widget_show (menu_Options);
  gtk_container_add (GTK_CONTAINER (menubar), menu_Options);

  menu_Options_menu = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (window), "menu_Options_menu", menu_Options_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_Options), menu_Options_menu);

  menu_Options_Fonts = gtk_menu_item_new_with_label ("Fonts");
  gtk_object_set_data (GTK_OBJECT (window), "menu_Options_Fonts", menu_Options_Fonts);
  gtk_widget_show (menu_Options_Fonts);
  gtk_container_add (GTK_CONTAINER (menu_Options_menu), menu_Options_Fonts);
  gtk_signal_connect (GTK_OBJECT (menu_Options_Fonts), "activate",
                      GTK_SIGNAL_FUNC (window_font),
                      NULL);
  gtk_widget_add_accelerator (menu_Options_Fonts, "activate", accel_group,
                              GDK_F, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);

  menu_Options_Colors = gtk_menu_item_new_with_label ("Colors");
  gtk_object_set_data (GTK_OBJECT (window), "menu_Options_Colors", menu_Options_Colors);
  gtk_widget_show (menu_Options_Colors);
  gtk_container_add (GTK_CONTAINER (menu_Options_menu), menu_Options_Colors);
  gtk_signal_connect (GTK_OBJECT (menu_Options_Colors), "activate",
                      GTK_SIGNAL_FUNC (color_prefs),
                      NULL);
  gtk_widget_add_accelerator (menu_Options_Colors, "activate", accel_group,
                              GDK_O, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);

  menu_Options_Preference = gtk_menu_item_new_with_label ("Preference");
  gtk_object_set_data (GTK_OBJECT (window), "menu_Options_Preference", menu_Options_Preference);
  gtk_widget_show (menu_Options_Preference);
  gtk_container_add (GTK_CONTAINER (menu_Options_menu), menu_Options_Preference);
  gtk_signal_connect (GTK_OBJECT (menu_Options_Preference), "activate",
                      GTK_SIGNAL_FUNC (window_prefs),
                      NULL);
  gtk_widget_add_accelerator (menu_Options_Preference, "activate", accel_group,
                              GDK_P, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);

  /* tools menu */
  menu_Tools = gtk_menu_item_new_with_label ("Tools");
  gtk_object_set_data (GTK_OBJECT (window), "menu_Tools", menu_Tools);
  gtk_widget_show (menu_Tools);
  gtk_container_add (GTK_CONTAINER (menubar), menu_Tools);

  menu_Tools_menu = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (window), "menu_Tools_menu", menu_Tools_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_Tools), menu_Tools_menu);

  menu_Tools_Macro = gtk_menu_item_new_with_label ("Macro's");
  gtk_object_set_data (GTK_OBJECT (window), "menu_Tools_Macro", menu_Tools_Macro);
  gtk_widget_show (menu_Tools_Macro);
  gtk_container_add (GTK_CONTAINER (menu_Tools_menu), menu_Tools_Macro);
  gtk_signal_connect (GTK_OBJECT (menu_Tools_Macro), "activate",
                      GTK_SIGNAL_FUNC (window_macro),
                      NULL);
  gtk_widget_add_accelerator (menu_Tools_Macro, "activate", accel_group,
                              GDK_M, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);


  menu_Tools_Alias = gtk_menu_item_new_with_label ("Aliases");
  gtk_object_set_data (GTK_OBJECT (window), "menu_Tools_Alias", menu_Tools_Alias);
  gtk_widget_show (menu_Tools_Alias);
  gtk_container_add (GTK_CONTAINER (menu_Tools_menu), menu_Tools_Alias);
  gtk_signal_connect (GTK_OBJECT (menu_Tools_Alias), "activate",
                      GTK_SIGNAL_FUNC (window_alias),
                      NULL);
  gtk_widget_add_accelerator (menu_Tools_Alias, "activate", accel_group,
                              GDK_A, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);

  menu_Tools_Trigger = gtk_menu_item_new_with_label ("Triggers");
  gtk_object_set_data (GTK_OBJECT (window), "menu_Tools_Trigger", menu_Tools_Trigger);
  gtk_widget_show (menu_Tools_Trigger);
  gtk_container_add (GTK_CONTAINER (menu_Tools_menu), menu_Tools_Trigger);
  gtk_signal_connect (GTK_OBJECT (menu_Tools_Trigger), "activate",
                      GTK_SIGNAL_FUNC (triggers_window),
		      NULL);

  gtk_widget_add_accelerator (menu_Tools_Trigger, "activate", accel_group,
                              GDK_T, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);

  menu_Tools_Logger = gtk_check_menu_item_new_with_label ("Logger");
  gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(menu_Tools_Logger), TRUE);
  gtk_object_set_data (GTK_OBJECT (window), "menu_Tools_Logger", menu_Tools_Logger);
  gtk_widget_show (menu_Tools_Logger);
  gtk_container_add (GTK_CONTAINER (menu_Tools_menu), menu_Tools_Logger);
  gtk_signal_connect (GTK_OBJECT (menu_Tools_Logger), "activate",
                      GTK_SIGNAL_FUNC (toggle_logger),
                      NULL);
  gtk_widget_add_accelerator (menu_Tools_Logger, "activate", accel_group,
                              GDK_L, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);

  menu_Tools_LogViewer = gtk_menu_item_new_with_label ("Log Viewer");
  gtk_object_set_data (GTK_OBJECT (window), "menu_Tools_LogViewer", menu_Tools_LogViewer);
  gtk_widget_show (menu_Tools_LogViewer);
  gtk_container_add (GTK_CONTAINER (menu_Tools_menu), menu_Tools_LogViewer);
  gtk_signal_connect (GTK_OBJECT (menu_Tools_LogViewer), "activate",
                      GTK_SIGNAL_FUNC (log_viewer),
                      NULL);
  gtk_widget_add_accelerator (menu_Tools_LogViewer, "activate", accel_group,
                              GDK_V, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);

  /* help menu */
  menu_Help = gtk_menu_item_new_with_label ("Help");
  gtk_object_set_data (GTK_OBJECT (window), "menu_Help", menu_Help);
  gtk_widget_show (menu_Help);
  gtk_container_add (GTK_CONTAINER (menubar), menu_Help);
  gtk_menu_item_right_justify (GTK_MENU_ITEM (menu_Help));

  menu_Help_menu = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (window), "menu_Help_menu", menu_Help_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_Help), menu_Help_menu);

  menu_Help_Manual = gtk_menu_item_new_with_label ("Manual");
  gtk_object_set_data (GTK_OBJECT (window), "menu_Help_Manual", menu_Help_Manual);
  gtk_widget_show (menu_Help_Manual);
  gtk_container_add (GTK_CONTAINER (menu_Help_menu), menu_Help_Manual);
  gtk_signal_connect (GTK_OBJECT (menu_Help_Manual), "activate",
                      GTK_SIGNAL_FUNC (do_manual),
                      NULL);
  gtk_widget_add_accelerator (menu_Help_Manual, "activate", accel_group,
                              GDK_H, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);

  separator3 = gtk_menu_item_new ();
  gtk_object_set_data (GTK_OBJECT (window), "separator3", separator3);
  gtk_widget_show (separator3);
  gtk_container_add (GTK_CONTAINER (menu_Help_menu), separator3);

  menu_Help_About = gtk_menu_item_new_with_label ("About");
  gtk_object_set_data (GTK_OBJECT (window), "menu_Help_About", menu_Help_About);
  gtk_widget_show (menu_Help_About);
  gtk_container_add (GTK_CONTAINER (menu_Help_menu), menu_Help_About);
  gtk_signal_connect (GTK_OBJECT (menu_Help_About), "activate",
                      GTK_SIGNAL_FUNC (do_about),
                      NULL);
  gtk_widget_add_accelerator (menu_Help_About, "activate", accel_group,
                              GDK_B, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);

/*** ToolBar ***/
  /* we need to realize the window because we use pixmaps for 
   * items on the toolbar in the context of it */
  gtk_widget_realize ( window );

  /* to make it nice we'll put the toolbar into the handle box, 
   * so that it can be detached from the main window */
  handlebox = gtk_handle_box_new ();
  gtk_box_pack_start ( GTK_BOX ( vbox1 ), handlebox, FALSE, FALSE, 2 );

  /* toolbar will be horizontal, with both icons and text, and
   * with 5pxl spaces between items and finally, 
   * we'll also put it into our handlebox */
  toolbar = gtk_toolbar_new ( GTK_ORIENTATION_HORIZONTAL,
                              GTK_TOOLBAR_ICONS );
  gtk_container_set_border_width ( GTK_CONTAINER ( toolbar ) , 5 );
  gtk_toolbar_set_space_size ( GTK_TOOLBAR ( toolbar ), 5 );
  gtk_container_add ( GTK_CONTAINER ( handlebox ) , toolbar );

  /* our first item is <Connection Wizard> button */
  /* now we create icon with mask: we'll reuse it to create
   * icon widgets for toolbar items */
  icon = gdk_pixmap_create_from_xpm_d ( window->window, &mask, &window->style->white, SC_wizard );
  iconw = gtk_pixmap_new ( icon, mask ); 					/* icon widget */
  btn_toolbar_connection_wizard = gtk_toolbar_append_item ( GTK_TOOLBAR (toolbar), /* our toolbar */
                                           NULL,               			/* button label */
                                           "Connection Wizard (Alt+W)",     	/* this button's tooltip */
                                           "Private",             		/* tooltip private info */
                                           iconw,                 		/* icon widget */
                                           GTK_SIGNAL_FUNC (do_wiz), 		/* a signal */
                                           NULL );
  gtk_toolbar_append_space ( GTK_TOOLBAR ( toolbar ) ); 			/* space after item */

  /* our next item is <Connect> button */
  icon = gdk_pixmap_create_from_xpm_d ( window->window, &mask, &window->style->white, SC_connect );
  iconw = gtk_pixmap_new ( icon, mask ); 					/* icon widget */
  btn_toolbar_connect = gtk_toolbar_append_item ( GTK_TOOLBAR (toolbar), 	/* our toolbar */
                                           NULL,               			/* button label */
                                           "Connect (Alt+C)",     		/* this button's tooltip */
                                           "Private",             		/* tooltip private info */
                                           iconw,                 		/* icon widget */
                                           GTK_SIGNAL_FUNC (cbox), 		/* a signal */
                                           NULL );

  /* our next item is <DisConnect> button */
  icon = gdk_pixmap_create_from_xpm_d ( window->window, &mask, &window->style->white, SC_disconnect );
  iconw = gtk_pixmap_new ( icon, mask ); 					/* icon widget */
  btn_toolbar_disconnect = gtk_toolbar_append_item ( GTK_TOOLBAR (toolbar), 	/* our toolbar */
                                           NULL,               			/* button label */
                                           "Disconnect (Alt+D)",     		/* this button's tooltip */
                                           "Private",             		/* tooltip private info */
                                           iconw,                		 /* icon widget */
                                           GTK_SIGNAL_FUNC (disconnect), 	/* a signal */
                                           NULL );
  gtk_toolbar_append_space ( GTK_TOOLBAR ( toolbar ) ); 			/* space after item */

  /* our next item is <Font> button */
  icon = gdk_pixmap_create_from_xpm_d ( window->window, &mask, &window->style->white, SC_font );
  iconw = gtk_pixmap_new ( icon, mask ); 					/* icon widget */
  btn_toolbar_font = gtk_toolbar_append_item ( GTK_TOOLBAR (toolbar), 		/* our toolbar */
                                           NULL,               			/* button label */
                                           "Font (Alt+F)",     			/* this button's tooltip */
                                           "Private",             		/* tooltip private info */
                                           iconw,                 		/* icon widget */
                                           GTK_SIGNAL_FUNC (window_font), 	/* a signal */
                                           NULL );

  /* our next item is <Colors> button */
  icon = gdk_pixmap_create_from_xpm_d ( window->window, &mask, &window->style->white, SC_colors );
  iconw = gtk_pixmap_new ( icon, mask ); 					/* icon widget */
  btn_toolbar_colors = gtk_toolbar_append_item ( GTK_TOOLBAR (toolbar),		/* our toolbar */
                                           NULL,               			/* button label */
                                           "Colors (Alt+O)",   			/* this button's tooltip */
                                           "Private",             		/* tooltip private info */
                                           iconw,                 		/* icon widget */
                                           GTK_SIGNAL_FUNC (color_prefs), 	/* a signal */
                                           NULL );

  /* our next item is <Preferences> button */
  icon = gdk_pixmap_create_from_xpm_d ( window->window, &mask, &window->style->white, SC_prefs );
  iconw = gtk_pixmap_new ( icon, mask ); 					/* icon widget */
  btn_toolbar_prefs = gtk_toolbar_append_item ( GTK_TOOLBAR (toolbar), 		/* our toolbar */
                                           NULL,               			/* button label */
                                           "Preferences (Alt+P)",     		/* this button's tooltip */
                                           "Private",             		/* tooltip private info */
                                           iconw,                 		/* icon widget */
                                           GTK_SIGNAL_FUNC (window_prefs), 	/* a signal */
                                           NULL );
  gtk_toolbar_append_space ( GTK_TOOLBAR ( toolbar ) ); 			/* space after item */

  /* our next item is <Alias> button */
  icon = gdk_pixmap_create_from_xpm_d ( window->window, &mask, &window->style->white, SC_alias );
  iconw = gtk_pixmap_new ( icon, mask ); 					/* icon widget */
  btn_toolbar_alias = gtk_toolbar_append_item ( GTK_TOOLBAR (toolbar), 		/* our toolbar */
                                           NULL,               			/* button label */
                                           "Alias (Alt+A)",     		/* this button's tooltip */
                                           "Private",             		/* tooltip private info */
                                           iconw,                 		/* icon widget */
                                           GTK_SIGNAL_FUNC (window_alias), 	/* a signal */
                                           NULL );

  /* our next item is <macros> button */
  icon = gdk_pixmap_create_from_xpm_d ( window->window, &mask, &window->style->white, SC_macros );
  iconw = gtk_pixmap_new ( icon, mask );				 	/* icon widget */
  btn_toolbar_macro = gtk_toolbar_append_item ( GTK_TOOLBAR (toolbar), 		/* our toolbar */
                                           NULL,               			/* button label */
                                           "Macros (Alt+M)",    		/* this button's tooltip */
                                           "Private",             		/* tooltip private info */
                                           iconw,                 		/* icon widget */
                                           GTK_SIGNAL_FUNC (window_macro), 	/* a signal */
                                           NULL );

  /* our next item is <trigger> button */
  icon = gdk_pixmap_create_from_xpm_d ( window->window, &mask, &window->style->white, SC_triggers );
  iconw = gtk_pixmap_new ( icon, mask ); 					/* icon widget */
  btn_toolbar_trigger = gtk_toolbar_append_item ( GTK_TOOLBAR (toolbar),  	/* our toolbar */
                                           NULL,           		    	/* button label */
                                           "Triggers (Alt+T)",		   	/* this button's tooltip */
                                           "Private",             	    	/* tooltip private info */
                                           iconw,                 	    	/* icon widget */
                                           GTK_SIGNAL_FUNC (triggers_window),  	/* a signal */
                                           NULL );

  gtk_toolbar_append_space ( GTK_TOOLBAR ( toolbar ) ); 		    	/* space after item */

  /* our next item is <Logger> button */
  icon = gdk_pixmap_create_from_xpm_d ( window->window, &mask, &window->style->white, SC_logger );
  iconw = gtk_pixmap_new ( icon, mask ); /* icon widget */
  btn_toolbar_logger = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
                                               GTK_TOOLBAR_CHILD_TOGGLEBUTTON,	/* a type of element */
                                               NULL,				/* pointer to widget */
                                               NULL,				/* label */
                                               "Logger (Alt+L)",		/* tooltip */
                                               "Private",			/* tooltip private string */
                                               iconw,				/* icon */
                                               GTK_SIGNAL_FUNC (do_log),	/* signal */
                                               toolbar);
  //gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tooltips_button), FALSE);

  /* our next item is <LogViewer> button */
  icon = gdk_pixmap_create_from_xpm_d ( window->window, &mask, &window->style->white, SC_logviewer );
  iconw = gtk_pixmap_new ( icon, mask ); 					/* icon widget */
  btn_toolbar_logview = gtk_toolbar_append_item ( GTK_TOOLBAR (toolbar), 	/* our toolbar */
                                           NULL,              		 	/* button label */
                                           "Log Viewer (Alt+V)",     	 	/* this button's tooltip */
                                           "Private",             	 	/* tooltip private info */
                                           iconw,                 	 	/* icon widget */
                                           GTK_SIGNAL_FUNC (log_viewer), 	/* a signal */
                                           NULL );
  gtk_toolbar_append_space ( GTK_TOOLBAR ( toolbar ) );			 	/* space after item */

  /* our next item is <help> button */
  icon = gdk_pixmap_create_from_xpm_d ( window->window, &mask, &window->style->white, SC_help );
  iconw = gtk_pixmap_new ( icon, mask ); 					/* icon widget */
  btn_toolbar_help = gtk_toolbar_append_item ( GTK_TOOLBAR (toolbar), 		/* our toolbar */
                                           NULL,               			/* button label */
                                           "Help (Alt+H)",     			/* this button's tooltip */
                                           "Private",          			/* tooltip private info */
                                           iconw,      		        	/* icon widget */
                                           GTK_SIGNAL_FUNC (do_manual),		/* a signal */
                                           NULL );

  /* sets the disconnect button unsensitive on startup */
  gtk_widget_set_sensitive (btn_toolbar_disconnect, FALSE);

  /* that's it ! let's show everything. */
  gtk_widget_show ( toolbar );

  if (prefs.Toolbar)
      gtk_widget_show (handlebox);
  else 
      gtk_widget_hide (handlebox);

/*** ToolBar End ***/

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window), "vbox2", vbox2);
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), vbox2, TRUE, TRUE, 0);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window), "hbox1", hbox1);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox1, TRUE, TRUE, 0);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window), "vbox3", vbox3);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox3, FALSE, TRUE, 0);

  if (prefs.Macrobuttons)
      gtk_widget_show (vbox3);
  else 
      gtk_widget_hide (vbox3);

  /* Macro frame */
  frame = gtk_frame_new ("Macros");
  gtk_object_set_data (GTK_OBJECT (window), "frame", frame);
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (vbox3), frame, FALSE, FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (frame), 3);
  gtk_frame_set_label_align (GTK_FRAME (frame), 0.03, 0.5);

  table = gtk_table_new (10, 2, FALSE);
  gtk_object_set_data (GTK_OBJECT (window), "table", table);
  gtk_widget_show (table);
  gtk_container_add (GTK_CONTAINER (frame), table);

  /* the labels that are beside the macro buttons */
  label_f1 = gtk_label_new ("F1");
  gtk_object_set_data (GTK_OBJECT (window), "label_f1", label_f1);
  gtk_widget_show (label_f1);
  gtk_table_attach (GTK_TABLE (table), label_f1, 0, 1, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  label_f2 = gtk_label_new ("F2");
  gtk_object_set_data (GTK_OBJECT (window), "label_f2", label_f2);
  gtk_widget_show (label_f2);
  gtk_table_attach (GTK_TABLE (table), label_f2, 0, 1, 1, 2,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  label_f3 = gtk_label_new ("F3");
  gtk_object_set_data (GTK_OBJECT (window), "label_f3", label_f3);
  gtk_widget_show (label_f3);
  gtk_table_attach (GTK_TABLE (table), label_f3, 0, 1, 2, 3,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  label_f4 = gtk_label_new ("F4");
  gtk_object_set_data (GTK_OBJECT (window), "label_f4", label_f4);
  gtk_widget_show (label_f4);
  gtk_table_attach (GTK_TABLE (table), label_f4, 0, 1, 3, 4,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  label_f5 = gtk_label_new ("F5");
  gtk_object_set_data (GTK_OBJECT (window), "label_f5", label_f5);
  gtk_widget_show (label_f5);
  gtk_table_attach (GTK_TABLE (table), label_f5, 0, 1, 4, 5,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  label_f6 = gtk_label_new ("F6");
  gtk_object_set_data (GTK_OBJECT (window), "label_f6", label_f6);
  gtk_widget_show (label_f6);
  gtk_table_attach (GTK_TABLE (table), label_f6, 0, 1, 5, 6,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  label_f7 = gtk_label_new ("F7");
  gtk_object_set_data (GTK_OBJECT (window), "label_f7", label_f7);
  gtk_widget_show (label_f7);
  gtk_table_attach (GTK_TABLE (table), label_f7, 0, 1, 6, 7,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  label_f8 = gtk_label_new ("F8");
  gtk_object_set_data (GTK_OBJECT (window), "label_f8", label_f8);
  gtk_widget_show (label_f8);
  gtk_table_attach (GTK_TABLE (table), label_f8, 0, 1, 7, 8,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  label_f9 = gtk_label_new ("F9");
  gtk_object_set_data (GTK_OBJECT (window), "label_f9", label_f9);
  gtk_widget_show (label_f9);
  gtk_table_attach (GTK_TABLE (table), label_f9, 0, 1, 8, 9,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  label_f10 = gtk_label_new ("F10");
  gtk_object_set_data (GTK_OBJECT (window), "label_f10", label_f10);
  gtk_widget_show (label_f10);
  gtk_table_attach (GTK_TABLE (table), label_f10, 0, 1, 9, 10,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  /* Macro buttons with accel.. key's F1-F10 */
  button_f1 = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (window), "button_f1", button_f1);
  gtk_signal_connect (GTK_OBJECT (button_f1), "clicked",
                      GTK_SIGNAL_FUNC (macro_send), F1);
  gtk_widget_show (button_f1);
  gtk_table_attach (GTK_TABLE (table), button_f1, 1, 2, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND, 0, 0);
  gtk_widget_set_usize (button_f1, 65, 26);
  gtk_container_border_width (GTK_CONTAINER (button_f1), 3);
  gtk_widget_add_accelerator (button_f1, "clicked", accel_group,
                              GDK_F1, 0, GTK_ACCEL_VISIBLE);

  btnLabel[0] = gtk_label_new (macro_list->F1);
  gtk_object_set_data (GTK_OBJECT (window), "btnLabel[0]", btnLabel[0]);
  gtk_container_add (GTK_CONTAINER(button_f1), btnLabel[0]);
  gtk_widget_show(btnLabel[0]);


  button_f2 = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (window), "button_f2", button_f2);
  gtk_signal_connect (GTK_OBJECT (button_f2), "clicked",
                      GTK_SIGNAL_FUNC (macro_send), (gpointer *)F2);
  gtk_widget_show (button_f2);
  gtk_table_attach (GTK_TABLE (table), button_f2, 1, 2, 1, 2,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND, 0, 0);
  gtk_widget_set_usize (button_f2, 65, 26);
  gtk_container_border_width (GTK_CONTAINER (button_f2), 3);
  gtk_widget_add_accelerator (button_f2, "clicked", accel_group,
                              GDK_F2, 0, GTK_ACCEL_VISIBLE);

  btnLabel[1] = gtk_label_new (macro_list->F2);
  gtk_object_set_data (GTK_OBJECT (window), "btnLabel[1]", btnLabel[1]);
  gtk_container_add (GTK_CONTAINER(button_f2), btnLabel[1]);
  gtk_widget_show(btnLabel[1]);

  button_f3 = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (window), "button_f3", button_f3);
  gtk_signal_connect (GTK_OBJECT (button_f3), "clicked",
                      GTK_SIGNAL_FUNC (macro_send), (gpointer *)F3);
  gtk_widget_show (button_f3);
  gtk_table_attach (GTK_TABLE (table), button_f3, 1, 2, 2, 3,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND, 0, 0);
  gtk_widget_set_usize (button_f3, 65, 26);
  gtk_container_border_width (GTK_CONTAINER (button_f3), 3);
  gtk_widget_add_accelerator (button_f3, "clicked", accel_group,
                              GDK_F3, 0, GTK_ACCEL_VISIBLE);

  btnLabel[2] = gtk_label_new (macro_list->F3);
  gtk_object_set_data (GTK_OBJECT (window), "btnLabel[2]", btnLabel[2]);
  gtk_container_add (GTK_CONTAINER(button_f3), btnLabel[2]);
  gtk_widget_show(btnLabel[2]);

  button_f4 = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (window), "button_f4", button_f4);
  gtk_signal_connect (GTK_OBJECT (button_f4), "clicked",
                      GTK_SIGNAL_FUNC (macro_send), (gpointer *)F4);
  gtk_widget_show (button_f4);
  gtk_table_attach (GTK_TABLE (table), button_f4, 1, 2, 3, 4,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND, 0, 0);
  gtk_widget_set_usize (button_f4, 65, 26);
  gtk_container_border_width (GTK_CONTAINER (button_f4), 3);
  gtk_widget_add_accelerator (button_f4, "clicked", accel_group,
                              GDK_F4, 0, GTK_ACCEL_VISIBLE);

  btnLabel[3] = gtk_label_new (macro_list->F4);
  gtk_object_set_data (GTK_OBJECT (window), "btnLabel[3]", btnLabel[3]);
  gtk_container_add (GTK_CONTAINER(button_f4), btnLabel[3]);
  gtk_widget_show(btnLabel[3]);

  button_f5 = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (window), "button_f5", button_f5);
  gtk_signal_connect (GTK_OBJECT (button_f5), "clicked",
                      GTK_SIGNAL_FUNC (macro_send), (gpointer *)F5);
  gtk_widget_show (button_f5);
  gtk_table_attach (GTK_TABLE (table), button_f5, 1, 2, 4, 5,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND, 0, 0);
  gtk_widget_set_usize (button_f5, 65, 26);
  gtk_container_border_width (GTK_CONTAINER (button_f5), 3);
  gtk_widget_add_accelerator (button_f5, "clicked", accel_group,
                              GDK_F5, 0, GTK_ACCEL_VISIBLE);

  btnLabel[4] = gtk_label_new (macro_list->F5);
  gtk_object_set_data (GTK_OBJECT (window), "btnLabel[4]", btnLabel[4]);
  gtk_container_add (GTK_CONTAINER(button_f5), btnLabel[4]);
  gtk_widget_show(btnLabel[4]);

  button_f6 = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (window), "button_f6", button_f6);
  gtk_signal_connect (GTK_OBJECT (button_f6), "clicked",
                      GTK_SIGNAL_FUNC (macro_send), (gpointer *)F6);
  gtk_widget_show (button_f6);
  gtk_table_attach (GTK_TABLE (table), button_f6, 1, 2, 5, 6,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND, 0, 0);
  gtk_widget_set_usize (button_f6, 65, 26);
  gtk_container_border_width (GTK_CONTAINER (button_f6), 3);
  gtk_widget_add_accelerator (button_f6, "clicked", accel_group,
                              GDK_F6, 0, GTK_ACCEL_VISIBLE);

  btnLabel[5] = gtk_label_new (macro_list->F6);
  gtk_object_set_data (GTK_OBJECT (window), "btnLabel[5]", btnLabel[5]);
  gtk_container_add (GTK_CONTAINER(button_f6), btnLabel[5]);
  gtk_widget_show(btnLabel[5]);

  button_f7 = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (window), "button_f7", button_f7);
  gtk_signal_connect (GTK_OBJECT (button_f7), "clicked",
                      GTK_SIGNAL_FUNC (macro_send), (gpointer *)F7);
  gtk_widget_show (button_f7);
  gtk_table_attach (GTK_TABLE (table), button_f7, 1, 2, 6, 7,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND, 0, 0);
  gtk_widget_set_usize (button_f7, 65, 26);
  gtk_container_border_width (GTK_CONTAINER (button_f7), 3);
  gtk_widget_add_accelerator (button_f7, "clicked", accel_group,
                              GDK_F7, 0, GTK_ACCEL_VISIBLE);

  btnLabel[6] = gtk_label_new (macro_list->F7);
  gtk_object_set_data (GTK_OBJECT (window), "btnLabel[6]", btnLabel[6]);
  gtk_container_add (GTK_CONTAINER(button_f7), btnLabel[6]);
  gtk_widget_show(btnLabel[6]);

  button_f8 = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (window), "button_f8", button_f8);
  gtk_signal_connect (GTK_OBJECT (button_f8), "clicked",
                      GTK_SIGNAL_FUNC (macro_send), (gpointer *)F8);
  gtk_widget_show (button_f8);
  gtk_table_attach (GTK_TABLE (table), button_f8, 1, 2, 7, 8,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND, 0, 0);
  gtk_widget_set_usize (button_f8, 65, 26);
  gtk_container_border_width (GTK_CONTAINER (button_f8), 3);
  gtk_widget_add_accelerator (button_f8, "clicked", accel_group,
                              GDK_F8, 0, GTK_ACCEL_VISIBLE);

  btnLabel[7] = gtk_label_new (macro_list->F8);
  gtk_object_set_data (GTK_OBJECT (window), "btnLabel[7]", btnLabel[7]);
  gtk_container_add (GTK_CONTAINER(button_f8), btnLabel[7]);
  gtk_widget_show(btnLabel[7]);

  button_f9 = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (window), "button_f9", button_f9);
  gtk_signal_connect (GTK_OBJECT (button_f9), "clicked",
                      GTK_SIGNAL_FUNC (macro_send), (gpointer *)F9);
  gtk_widget_show (button_f9);
  gtk_table_attach (GTK_TABLE (table), button_f9, 1, 2, 8, 9,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND, 0, 0);
  gtk_widget_set_usize (button_f9, 65, 26);
  gtk_container_border_width (GTK_CONTAINER (button_f9), 3);
  gtk_widget_add_accelerator (button_f9, "clicked", accel_group,
                              GDK_F9, 0, GTK_ACCEL_VISIBLE);

  btnLabel[8] = gtk_label_new (macro_list->F9);
  gtk_object_set_data (GTK_OBJECT (window), "btnLabel[8]", btnLabel[8]);
  gtk_container_add (GTK_CONTAINER(button_f9), btnLabel[8]);
  gtk_widget_show(btnLabel[8]);

  button_f10 = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (window), "button_f10", button_f10);
  gtk_signal_connect (GTK_OBJECT (button_f10), "clicked",
                      GTK_SIGNAL_FUNC (macro_send), (gpointer *)F10);
  gtk_widget_show (button_f10);
  gtk_table_attach (GTK_TABLE (table), button_f10, 1, 2, 9, 10,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND, 0, 0);
  gtk_widget_set_usize (button_f10, 65, 26);
  gtk_container_border_width (GTK_CONTAINER (button_f10), 3);
  gtk_widget_add_accelerator (button_f10, "clicked", accel_group,
                              GDK_F10, 0, GTK_ACCEL_VISIBLE);

  btnLabel[9] = gtk_label_new (macro_list->F10);
  gtk_object_set_data (GTK_OBJECT (window), "btnLabel[9]", btnLabel[9]);
  gtk_container_add (GTK_CONTAINER(button_f10), btnLabel[9]);
  gtk_widget_show(btnLabel[9]);

  /* just a empty label we use as a fillblock so it should look nice */
  fill_block2 = gtk_label_new ("");
  gtk_object_set_data (GTK_OBJECT (window), "fill_block2", fill_block2);
  gtk_widget_show (fill_block2);
  gtk_box_pack_start (GTK_BOX (vbox3), fill_block2, FALSE, TRUE, 0);

  /* main text window */
  mud->text = gtk_text_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (window), "mud->text", mud->text);
  gtk_widget_show (mud->text);
  gtk_box_pack_start (GTK_BOX (hbox1), mud->text, TRUE, TRUE, 0);

  gtk_widget_realize (mud->text);

  /* the scrollbar attached to the main text window */
  vscrollbar = gtk_vscrollbar_new (GTK_TEXT(mud->text)->vadj);
  gtk_object_set_data (GTK_OBJECT (window), "vscrollbar", vscrollbar);
  gtk_widget_show (vscrollbar);
  gtk_box_pack_start (GTK_BOX (hbox1), vscrollbar, FALSE, TRUE, 0);
  GTK_WIDGET_UNSET_FLAGS (vscrollbar, GTK_CAN_FOCUS);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window), "hbox2", hbox2);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox2, FALSE, TRUE, 3);

  /* just a empty label we use as a fillblock so it should look nice */
  fill_block = gtk_label_new ("");
  gtk_object_set_data (GTK_OBJECT (window), "fill_block", fill_block);
  gtk_widget_show (fill_block);
  gtk_box_pack_start (GTK_BOX (hbox2), fill_block, FALSE, TRUE, 40);

  /* the entry box, that we use to type the commands in */
  mud->ent = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (window), "mud->ent", mud->ent);
  gtk_signal_connect_object (GTK_OBJECT (mud->ent), "activate", GTK_SIGNAL_FUNC (send_to_connection), NULL);
  gtk_signal_connect(GTK_OBJECT(mud->ent),"key_press_event",GTK_SIGNAL_FUNC(hist_evt),mud->ent);
  gtk_widget_show (mud->ent);
  gtk_box_pack_start (GTK_BOX (hbox2), mud->ent, TRUE, TRUE, 16);
  GTK_WIDGET_SET_FLAGS (mud->ent, GTK_CAN_DEFAULT);
  gtk_widget_grab_focus (mud->ent);
  gtk_widget_grab_default (mud->ent);

  /* status bar wich can be used for displaying information */
  statusbar = gtk_statusbar_new ();
  gtk_object_set_data (GTK_OBJECT (window), "statusbar", statusbar);
  gtk_box_pack_start (GTK_BOX (vbox1), statusbar, FALSE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (statusbar), 3);

  if (prefs.Statusbar)
      gtk_widget_show (statusbar);
  else 
      gtk_widget_hide (statusbar);

  statusbar_id = gtk_statusbar_get_context_id(GTK_STATUSBAR(statusbar), "Statusbar");
  gtk_statusbar_push (GTK_STATUSBAR(statusbar), statusbar_id, "Ready");

  return window;
}

/* Change Macro buttons labels
 */
void macro_btnLabel_change ()
{
   gtk_label_set(GTK_LABEL(btnLabel[0]), macro_list->F1);
   gtk_misc_set_alignment (GTK_MISC(btnLabel[0]), LorC(macro_list->F1), 0.5);
   gtk_label_set(GTK_LABEL(btnLabel[1]), macro_list->F2);
   gtk_misc_set_alignment (GTK_MISC(btnLabel[1]), LorC(macro_list->F2), 0.5);
   gtk_label_set(GTK_LABEL(btnLabel[2]), macro_list->F3);
   gtk_misc_set_alignment (GTK_MISC(btnLabel[2]), LorC(macro_list->F3), 0.5);
   gtk_label_set(GTK_LABEL(btnLabel[3]), macro_list->F4);
   gtk_misc_set_alignment (GTK_MISC(btnLabel[3]), LorC(macro_list->F4), 0.5);
   gtk_label_set(GTK_LABEL(btnLabel[4]), macro_list->F5);
   gtk_misc_set_alignment (GTK_MISC(btnLabel[4]), LorC(macro_list->F5), 0.5);
   gtk_label_set(GTK_LABEL(btnLabel[5]), macro_list->F6);
   gtk_misc_set_alignment (GTK_MISC(btnLabel[5]), LorC(macro_list->F6), 0.5);
   gtk_label_set(GTK_LABEL(btnLabel[6]), macro_list->F7);
   gtk_misc_set_alignment (GTK_MISC(btnLabel[6]), LorC(macro_list->F7), 0.5);
   gtk_label_set(GTK_LABEL(btnLabel[7]), macro_list->F8);
   gtk_misc_set_alignment (GTK_MISC(btnLabel[7]), LorC(macro_list->F8), 0.5);
   gtk_label_set(GTK_LABEL(btnLabel[8]), macro_list->F9);
   gtk_misc_set_alignment (GTK_MISC(btnLabel[8]), LorC(macro_list->F9), 0.5);
   gtk_label_set(GTK_LABEL(btnLabel[9]), macro_list->F10);
   gtk_misc_set_alignment (GTK_MISC(btnLabel[9]), LorC(macro_list->F10), 0.5);

}

void textfield_add(gchar *message, int colortype)
{
  GtkAdjustment *adj = GTK_TEXT(mud->text)->vadj;
  int scrolled_up = FALSE;
  int x, numbytes = strlen(message);
	        
  if (message[0] == '\0')
    return;

  if (adj->value < (adj->upper - adj->page_size)) {
     scrolled_up = TRUE;
     gtk_text_freeze(GTK_TEXT(mud->text));
  }

  if (colortype == MESSAGE_NONE || colortype == MESSAGE_NORMAL) {
     if (mud->LOGGING) /* Loging */
        fprintf(mud->LOG_FILE, message);
     gtk_text_insert(GTK_TEXT (mud->text), font_normal, &prefs.DefaultColor, NULL, message, -1);
  }
  if (colortype == MESSAGE_ERR) {
     if (mud->LOGGING) /* Loging */
        fprintf(mud->LOG_FILE, message);
     gtk_text_insert(GTK_TEXT (mud->text), font_normal, &color_red, NULL, message, -1);
  }
  if (colortype == MESSAGE_SENT) {
     if (mud->LOGGING) /* Loging */
        fprintf(mud->LOG_FILE, message);
     gtk_text_insert(GTK_TEXT (mud->text), font_normal, &color_lightyellow, NULL, message, -1);
  }
  if (colortype == MESSAGE_ANSI) {
   /* break the ansi into 2 parts, and do 'em */
     x = numbytes;
     disp_ansi(x, message, mud->text);
  }

  clear_backbuffer();

  if (scrolled_up)
      gtk_text_thaw (GTK_TEXT (mud->text));
  else if(adj->value < (adj->upper - adj->page_size))
      gtk_adjustment_set_value(adj, (adj->upper - adj->page_size));

  gtk_widget_grab_focus (GTK_WIDGET (mud->ent));
  return;
}


	/* n is the number of lines to NOT delete, if it's 0, delete 'em all */
void clear(int n, GtkText *target)
{
    gtk_text_freeze (target);
    gtk_text_backward_delete ((target), gtk_text_get_length (target));
    gtk_text_thaw (target);
}	

/* FOR THE WINDOW BUFFER FUNCTION */
void clear_backbuffer()
{
    int n = gtk_text_get_length (GTK_TEXT (mud->text));
    if (mud->maxlines <= 0 || n < mud->maxlines)
        return;
    gtk_text_freeze (GTK_TEXT (mud->text));
    gtk_text_set_point (GTK_TEXT (mud->text), n - mud->maxlines);
    gtk_text_backward_delete (GTK_TEXT (mud->text), n - mud->maxlines);
    gtk_text_set_point (GTK_TEXT (mud->text), mud->maxlines);
    gtk_text_thaw (GTK_TEXT (mud->text));
}

void popup_window (const gchar *message)
{
    GtkWidget *window;
    GtkWidget *label;
    GtkWidget *button;
    GtkWidget *box;
    GtkWidget *separator;

    gchar       buf[3072];

    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title (GTK_WINDOW (window), "Popup Message");

    box = gtk_vbox_new (FALSE, 5);
    gtk_container_set_border_width (GTK_CONTAINER (box), 5);
    gtk_container_add (GTK_CONTAINER (window), box);

    g_snprintf ( buf, 3072, " %s ", message);
    label = gtk_label_new (buf);
    gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
    gtk_widget_show (label);

    separator = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (box), separator, TRUE, TRUE, 0);
    gtk_widget_show (separator);
    
    button = gtk_button_new_with_label (" OK ");
    gtk_signal_connect (GTK_OBJECT (button), "clicked",
                        GTK_SIGNAL_FUNC (close_window),
                        window);
    gtk_box_pack_start (GTK_BOX (box), button, TRUE, TRUE, 5);
    gtk_widget_show (button);
    
    gtk_widget_show (box);
    gtk_widget_show (window);
}
