/*  SClient
 *  Copyright (C) 1999 Heathen (the.heathen@swipnet.se)
 *		  1999 Drizzt  (doc.day@swipnet.se)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "macro.h"

/* The callback function for the ok button */
void button_ok_callback(GtkWidget *button, GtkWidget *entry[])
{
    macro_list->F1 = g_strdup (gtk_entry_get_text(GTK_ENTRY(entry[0])));
    macro_list->F2 = g_strdup (gtk_entry_get_text(GTK_ENTRY(entry[1])));
    macro_list->F3 = g_strdup (gtk_entry_get_text(GTK_ENTRY(entry[2])));
    macro_list->F4 = g_strdup (gtk_entry_get_text(GTK_ENTRY(entry[3])));
    macro_list->F5 = g_strdup (gtk_entry_get_text(GTK_ENTRY(entry[4])));
    macro_list->F6 = g_strdup (gtk_entry_get_text(GTK_ENTRY(entry[5])));
    macro_list->F7 = g_strdup (gtk_entry_get_text(GTK_ENTRY(entry[6])));
    macro_list->F8 = g_strdup (gtk_entry_get_text(GTK_ENTRY(entry[7])));
    macro_list->F9 = g_strdup (gtk_entry_get_text(GTK_ENTRY(entry[8])));
    macro_list->F10 = g_strdup (gtk_entry_get_text(GTK_ENTRY(entry[9])));

    macro_btnLabel_change();
    save_macro(NULL);
}

/* saves the macro's to file */
void save_macro (gpointer data)
{
    gchar *home, filename[256] = "";
    FILE *fp;
    gchar buf[256];

    home = getenv ("HOME");

    g_snprintf (filename, 255, "%s%s", home, "/.sclient");
    if (check_sclient_dir (filename) != 0)
        return;

    g_snprintf (filename, 255, "%s%s", home, "/.sclient/macro");

    fp = fopen (filename, "w");

    if ( fp == NULL )  
    {
        sprintf (buf, "You must create the directory %s/.sclient before you can save.",
                 home);
        popup_window (buf);
        return;
    }

        fprintf (fp, "F1 %s\n", macro_list->F1);

        fprintf (fp, "F2 %s\n", macro_list->F2);

        fprintf (fp, "F3 %s\n", macro_list->F3);

        fprintf (fp, "F4 %s\n", macro_list->F4);

        fprintf (fp, "F5 %s\n", macro_list->F5);

        fprintf (fp, "F6 %s\n", macro_list->F6);

        fprintf (fp, "F7 %s\n", macro_list->F7);

        fprintf (fp, "F8 %s\n", macro_list->F8);

        fprintf (fp, "F9 %s\n", macro_list->F9);
 
        fprintf (fp, "F10 %s\n", macro_list->F10);

    if ( fp )
        fclose (fp);
    return;
}

/* load's the macro's from file into the entry boxes */
void load_macro ( void )
{
    FILE *fp;
    gchar *home, filename[255] = "";
    gchar line[255];
    
    home = getenv ("HOME");

    g_snprintf (filename, 255, "%s%s", home, "/.sclient");
    if (check_sclient_dir (filename) != 0)
        return;

    g_snprintf (filename, 254, "%s%s", home, "/.sclient/macro");

    fp = fopen (filename, "r");

    if ( fp == NULL )
        return;

/* load in the macro's into the entry[] boxes */
    while ( fgets (line, 80, fp) != NULL )
    {
        gchar macro[25];
        gchar value[250];
        value[0] = 0;

        sscanf (line, "%s %[^\n]", macro, value);

   /* the F1 value */
    if ( !strcmp (macro, "F1") )
       {
        macro_list->F1 = g_strdup (value);
       }

    if ( !macro_list->F1 )
        macro_list->F1 = g_strdup ("");

   /* the F2 value */
    if ( !strcmp (macro, "F2") )
       {
        macro_list->F2 = g_strdup (value);
       }

    if ( !macro_list->F2 )
        macro_list->F2 = g_strdup ("");

   /* the F3 value */
    if ( !strcmp (macro, "F3") )
       {
        macro_list->F3 = g_strdup (value);
       }

    if ( !macro_list->F3 )
        macro_list->F3 = g_strdup ("");

   /* the F4 value */
    if ( !strcmp (macro, "F4") )
       {
        macro_list->F4 = g_strdup (value);
       }

    if ( !macro_list->F4 )
        macro_list->F4 = g_strdup ("");

   /* the F5 value */
    if ( !strcmp (macro, "F5") )
       {
        macro_list->F5 = g_strdup (value);
       }

    if ( !macro_list->F5 )
        macro_list->F5 = g_strdup ("");

   /* the F6 value */
    if ( !strcmp (macro, "F6") )
       {
        macro_list->F6 = g_strdup (value);
       }

    if ( !macro_list->F6 )
        macro_list->F6 = g_strdup ("");

   /* the F7 value */
    if ( !strcmp (macro, "F7") )
       {
        macro_list->F7 = g_strdup (value);
       }

    if ( !macro_list->F7 )
        macro_list->F7 = g_strdup ("");

   /* the F8 value */
    if ( !strcmp (macro, "F8") )
       {
        macro_list->F8 = g_strdup (value);
       }

    if ( !macro_list->F8 )
        macro_list->F8 = g_strdup ("");

   /* the F9 value */
    if ( !strcmp (macro, "F9") )
       {
        macro_list->F9 = g_strdup (value); 
       }

    if ( !macro_list->F9 )
        macro_list->F9 = g_strdup ("");

   /* the F10 value */
    if ( !strcmp (macro, "F10") )
       {
        macro_list->F10 = g_strdup (value);
       }

    if ( !macro_list->F10 )
        macro_list->F10 = g_strdup ("");

}
    fclose (fp);
    macro_btnLabel_change ();
}

void window_macro (GtkWidget *widget, gpointer data)
{
  GtkWidget *macro_window;
  GtkWidget *vbox1;
  GtkWidget *frame1;
  GtkWidget *hbox1;
  GtkWidget *vbox2;
  GtkWidget *label_f1;
  GtkWidget *label_f2;
  GtkWidget *label_f3;
  GtkWidget *label_f4;
  GtkWidget *label_f5;
  GtkWidget *vbox3;
  GtkWidget *vbox4;
  GtkWidget *label_f6;
  GtkWidget *label_f7;
  GtkWidget *label_f8;
  GtkWidget *label_f9;
  GtkWidget *label_f10;
  GtkWidget *vbox5;
  GtkWidget *hbuttonbox;
  GtkWidget *button_ok;
  GtkWidget *button_cancel;
  static GtkWidget *entry[10];


  macro_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (macro_window), "macro_window", macro_window);
  gtk_widget_set_usize (macro_window, 400, 200);
  gtk_container_border_width (GTK_CONTAINER (macro_window), 3);
  gtk_window_set_title (GTK_WINDOW (macro_window), "Macros");
  gtk_window_set_policy (GTK_WINDOW (macro_window), FALSE, FALSE, FALSE);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (macro_window), "vbox1", vbox1);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (macro_window), vbox1);

  frame1 = gtk_frame_new ("Macros");
  gtk_object_set_data (GTK_OBJECT (macro_window), "frame1", frame1);
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox1), frame1, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (frame1), 3);
  gtk_frame_set_label_align (GTK_FRAME (frame1), 0.03, 0.5);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (macro_window), "hbox1", hbox1);
  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (frame1), hbox1);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (macro_window), "vbox2", vbox2);
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox2, FALSE, TRUE, 5);

  label_f1 = gtk_label_new ("F1");
  gtk_object_set_data (GTK_OBJECT (macro_window), "label_f1", label_f1);
  gtk_widget_show (label_f1);
  gtk_box_pack_start (GTK_BOX (vbox2), label_f1, TRUE, TRUE, 0);

  label_f2 = gtk_label_new ("F2");
  gtk_object_set_data (GTK_OBJECT (macro_window), "label_f2", label_f2);
  gtk_widget_show (label_f2);
  gtk_box_pack_start (GTK_BOX (vbox2), label_f2, TRUE, TRUE, 0);

  label_f3 = gtk_label_new ("F3");
  gtk_object_set_data (GTK_OBJECT (macro_window), "label_f3", label_f3);
  gtk_widget_show (label_f3);
  gtk_box_pack_start (GTK_BOX (vbox2), label_f3, TRUE, TRUE, 0);

  label_f4 = gtk_label_new ("F4");
  gtk_object_set_data (GTK_OBJECT (macro_window), "label_f4", label_f4);
  gtk_widget_show (label_f4);
  gtk_box_pack_start (GTK_BOX (vbox2), label_f4, TRUE, TRUE, 0);

  label_f5 = gtk_label_new ("F5");
  gtk_object_set_data (GTK_OBJECT (macro_window), "label_f5", label_f5);
  gtk_widget_show (label_f5);
  gtk_box_pack_start (GTK_BOX (vbox2), label_f5, TRUE, TRUE, 0);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (macro_window), "vbox3", vbox3);
  gtk_widget_show (vbox3);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox3, TRUE, TRUE, 5);

  entry[0] = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (macro_window), "entry[0]", entry[0]);
  gtk_entry_set_text (GTK_ENTRY(entry[0]), macro_list->F1);
  gtk_widget_show (entry[0]);
  gtk_box_pack_start (GTK_BOX (vbox3), entry[0], TRUE, TRUE, 0);
  gtk_widget_set_usize (entry[0], 140, -1);

  entry[1] = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (macro_window), "entry[1]", entry[1]);
  gtk_entry_set_text (GTK_ENTRY(entry[1]), macro_list->F2);
  gtk_widget_show (entry[1]);
  gtk_box_pack_start (GTK_BOX (vbox3), entry[1], TRUE, TRUE, 0);
  gtk_widget_set_usize (entry[1], 140, -1);

  entry[2] = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (macro_window), "entry[2]", entry[2]);
  gtk_entry_set_text (GTK_ENTRY(entry[2]), macro_list->F3);
  gtk_widget_show (entry[2]);
  gtk_box_pack_start (GTK_BOX (vbox3), entry[2], TRUE, TRUE, 0);
  gtk_widget_set_usize (entry[2], 140, -1);

  entry[3] = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (macro_window), "entry[3]", entry[3]);
  gtk_entry_set_text (GTK_ENTRY(entry[3]), macro_list->F4);
  gtk_widget_show (entry[3]);
  gtk_box_pack_start (GTK_BOX (vbox3), entry[3], TRUE, TRUE, 0);
  gtk_widget_set_usize (entry[3], 140, -1);

  entry[4] = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (macro_window), "entry[4]", entry[4]);
  gtk_entry_set_text (GTK_ENTRY(entry[4]), macro_list->F5);
  gtk_widget_show (entry[4]);
  gtk_box_pack_start (GTK_BOX (vbox3), entry[4], TRUE, TRUE, 0);
  gtk_widget_set_usize (entry[4], 140, -1);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (macro_window), "vbox4", vbox4);
  gtk_widget_show (vbox4);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox4, FALSE, TRUE, 0);

  label_f6 = gtk_label_new ("F6");
  gtk_object_set_data (GTK_OBJECT (macro_window), "label_f6", label_f6);
  gtk_widget_show (label_f6);
  gtk_box_pack_start (GTK_BOX (vbox4), label_f6, TRUE, TRUE, 0);

  label_f7 = gtk_label_new ("F7");
  gtk_object_set_data (GTK_OBJECT (macro_window), "label_f7", label_f7);
  gtk_widget_show (label_f7);
  gtk_box_pack_start (GTK_BOX (vbox4), label_f7, TRUE, TRUE, 0);

  label_f8 = gtk_label_new ("F8");
  gtk_object_set_data (GTK_OBJECT (macro_window), "label_f8", label_f8);
  gtk_widget_show (label_f8);
  gtk_box_pack_start (GTK_BOX (vbox4), label_f8, TRUE, TRUE, 0);

  label_f9 = gtk_label_new ("F9");
  gtk_object_set_data (GTK_OBJECT (macro_window), "label_f9", label_f9);
  gtk_widget_show (label_f9);
  gtk_box_pack_start (GTK_BOX (vbox4), label_f9, TRUE, TRUE, 0);

  label_f10 = gtk_label_new ("F10");
  gtk_object_set_data (GTK_OBJECT (macro_window), "label_f10", label_f10);
  gtk_widget_show (label_f10);
  gtk_box_pack_start (GTK_BOX (vbox4), label_f10, TRUE, TRUE, 0);

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (macro_window), "vbox5", vbox5);
  gtk_widget_show (vbox5);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox5, TRUE, TRUE, 5);

  entry[5] = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (macro_window), "entry[5]", entry[5]);
  gtk_entry_set_text (GTK_ENTRY(entry[5]), macro_list->F6);
  gtk_widget_show (entry[5]);
  gtk_box_pack_start (GTK_BOX (vbox5), entry[5], TRUE, TRUE, 0);
  gtk_widget_set_usize (entry[5], 140, -1);

  entry[6] = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (macro_window), "entry[6]", entry[6]);
  gtk_entry_set_text (GTK_ENTRY(entry[6]), macro_list->F7);
  gtk_widget_show (entry[6]);
  gtk_box_pack_start (GTK_BOX (vbox5), entry[6], TRUE, TRUE, 0);
  gtk_widget_set_usize (entry[6], 140, -1);

  entry[7] = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (macro_window), "entry[7]", entry[7]);
  gtk_entry_set_text (GTK_ENTRY(entry[7]), macro_list->F8);
  gtk_widget_show (entry[7]);
  gtk_box_pack_start (GTK_BOX (vbox5), entry[7], TRUE, TRUE, 0);
  gtk_widget_set_usize (entry[7], 140, -1);

  entry[8] = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (macro_window), "entry[8]", entry[8]);
  gtk_entry_set_text (GTK_ENTRY(entry[8]), macro_list->F9);
  gtk_widget_show (entry[8]);
  gtk_box_pack_start (GTK_BOX (vbox5), entry[8], TRUE, TRUE, 0);
  gtk_widget_set_usize (entry[8], 140, -1);

  entry[9] = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (macro_window), "entry[9]", entry[9]);
  gtk_entry_set_text (GTK_ENTRY(entry[9]), macro_list->F10);
  gtk_widget_show (entry[9]);
  gtk_box_pack_start (GTK_BOX (vbox5), entry[9], TRUE, TRUE, 0);
  gtk_widget_set_usize (entry[9], 140, -1);

  hbuttonbox = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (macro_window), "hbuttonbox", hbuttonbox);
  gtk_widget_show (hbuttonbox);
  gtk_box_pack_start (GTK_BOX (vbox1), hbuttonbox, FALSE, TRUE, 5);
  gtk_widget_set_usize (hbuttonbox, -1, 25);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox), GTK_BUTTONBOX_SPREAD);

  button_ok = gtk_button_new_with_label ("Ok");
  gtk_object_set_data (GTK_OBJECT (macro_window), "button_ok", button_ok);
  gtk_signal_connect (GTK_OBJECT (button_ok), "clicked",
                             GTK_SIGNAL_FUNC (button_ok_callback),
                             entry);
  gtk_signal_connect (GTK_OBJECT (button_ok), "clicked",
                      GTK_SIGNAL_FUNC (close_window), macro_window);
  gtk_widget_show (button_ok);
  gtk_container_add (GTK_CONTAINER (hbuttonbox), button_ok);
  gtk_widget_set_usize (button_ok, -1, 20);
  gtk_container_border_width (GTK_CONTAINER (button_ok), 3);

  button_cancel = gtk_button_new_with_label ("Cancel");
  gtk_object_set_data (GTK_OBJECT (macro_window), "button_cancel", button_cancel);
  gtk_signal_connect (GTK_OBJECT (button_cancel), "clicked",
                      GTK_SIGNAL_FUNC (close_window), macro_window);
  gtk_widget_show (button_cancel);
  gtk_container_add (GTK_CONTAINER (hbuttonbox), button_cancel);
  gtk_widget_set_usize (button_cancel, -1, 20);
  gtk_container_border_width (GTK_CONTAINER (button_cancel), 3);

  gtk_widget_show (macro_window);
}





