/***************************************************************************
                          setupdialog.cpp  -  setup dialog
                             -------------------
    begin                : September 22nd 1999
    copyright            : (C) 1999 by David Johnson
    email                : arandir@meer.net

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#include "resource.h"
#include "setupdialog.h"

SetupDialog::SetupDialog(QWidget* parent, const char* name) : QDialog( parent, name, true )
{
	// create label widgets
	qbrewLabel = new QLabel(this, "qbrewLabel");
	qbrewLabel->setText( "QBrew directory" );
	styleLabel = new QLabel(this, "styleLabel");
	styleLabel->setText( "Qt Style" );
	batchLabel = new QLabel(this, "batchLabel");
	batchLabel->setText( "Default Batch Size" );
	efficiencyLabel = new QLabel(this, "efficiencyLabel");
	efficiencyLabel->setText( "Mash Efficiency" );
	sepOne = new QFrame(this, "sepOne");
	sepOne->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	sepTwo = new QFrame(this, "sepTwo");
	sepTwo->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	
	// create other widgets
	qbrewEdit = new QLineEdit(this, "qbrewEdit");
	styleBox = new QComboBox(this, "styleBox");
	batchSpin = new FixedSpinBox(0, 10000, 25, 2, this, "batchSpin");
	efficiencySpin = new QSpinBox(0, 100, 1, this, "batchSpin");
	efficiencySpin->setSuffix("%");
	cancelButton = new QPushButton(this, "cancelButton");
	cancelButton->setText("Cancel");
	okButton = new QPushButton(this, "okButton");
	okButton->setText("OK");
	okButton->setDefault(true);
	connect( okButton, SIGNAL(clicked()), SLOT(accept()) );
	connect( cancelButton, SIGNAL(clicked()), SLOT(reject()) );	

	// create layout		
	layout = new QGridLayout(this, 3, 7, 3, 3, "setupLayout");
	layout->addColSpacing(1, 3);
	layout->setColStretch(0, 1);
	layout->setColStretch(2, 1);
	layout->addWidget(qbrewLabel, 0, 0);
	layout->addWidget(qbrewEdit, 0, 2);
	layout->addWidget(styleLabel, 1, 0);
	layout->addWidget(styleBox, 1, 2);
	layout->addMultiCellWidget(sepOne, 2, 2, 0, 2);
	layout->addWidget(batchLabel, 3, 0);
	layout->addWidget(batchSpin, 3, 2);
	layout->addWidget(efficiencyLabel, 4, 0);
	layout->addWidget(efficiencySpin, 4, 2);
	layout->addMultiCellWidget(sepTwo, 5, 5, 0, 2);
	layout->addWidget(cancelButton, 6, 0, QLabel::AlignRight);
	layout->addWidget(okButton, 6, 2, QLabel::AlignRight);
 	
	// setup styles combobox
	styleBox->clear();
	QMap<QString, int>::Iterator it;
	for( it = styleMap.begin(); it != styleMap.end(); ++it )
		styleBox->insertItem(it.key());
		
	setCaption( IDS_TITLE + tr(" Setup") );
}

SetupDialog::~SetupDialog() {}

void SetupDialog::setQBrewDir(const QString &qdir) { qbrewEdit->setText(qdir); }

const QString SetupDialog::qbrewDir() { return qbrewEdit->text(); }

void SetupDialog::setStyle(const QString &sstyle)
{
	int item;
	// search combo box for style string
	for (item = 0; item <= styleBox->count(); item++) {
		if (styleBox->text(item) == sstyle)
			break;
	}
	// if item not found, will set it to the last one
	styleBox->setCurrentItem(item);
}

const QString SetupDialog::style() { return styleBox->currentText(); }

void SetupDialog::setBatch(const QString &qbatch) { batchSpin->setValue(qbatch.toInt()); }

const QString SetupDialog::batch() { return QString::number(batchSpin->value()); }

void SetupDialog::setEfficiency(const QString &qeff) { efficiencySpin->setValue(qeff.toInt()); }

const QString SetupDialog::efficiency() { return QString::number(efficiencySpin->value()); }

















