/***************************************************************************
                          miscingredient.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Oct 20 1999                                           
    copyright            : (C) 1999 by David Johnson                         
    email                : arandir@meer.net                                     

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#include <math.h>

#include <qstring.h>
#include <qstringlist.h>

#include "miscingredient.h"

MiscIngredient::MiscIngredient() { name = quantity = 0; notes = "notes"; }

MiscIngredient::MiscIngredient(const QString &mname, const unsigned &mquant, const QString &mnotes)
{
	name = mname;
	quantity = mquant;
	notes = mnotes;
}

MiscIngredient::MiscIngredient(const MiscIngredient &m)
{
	name = m.name;
	quantity = m.quantity;
	notes = m.notes;
}

MiscIngredient MiscIngredient::operator=(const MiscIngredient &m)
{
	name = m.name;
	quantity = m.quantity;
	notes = m.notes;
	return *this;
}

bool MiscIngredient::operator==(const MiscIngredient &m)
{
	return (name == m.name)
		&& (quantity == m.quantity)
		&& (notes == m.notes);
}

MiscIngredient::~MiscIngredient() {}

///////////////////////////////////////////////////////////////////////////////
// member access

QString MiscIngredient::getName() { return name; }

unsigned MiscIngredient::getQuantity() { return quantity; }

QString MiscIngredient::getNotes() { return notes; }

QString MiscIngredient::getQuantityString() { return formatValue(quantity, 2); }

///////////////////////////////////////////////////////////////////////////////
// utility functions

QString MiscIngredient::formatValue(const unsigned &value, const unsigned &fix)
{
	unsigned divisor = unsigned(pow(10.0, double(fix)));
	unsigned leftuint = value / divisor;
	QString leftstring = QString::number(leftuint) + ".";
	QString rightstring = QString::number(value - (leftuint * divisor));
	leftstring += rightstring.rightJustify(fix, '0', true);
	return leftstring;
}

///////////////////////////////////////////////////////////////////////////////
// serialization

QString MiscIngredient::serializeOut()
{
	return QString::number(quantity) + ", " + notes;
}

void MiscIngredient::serializeIn(const QString &mname, const QString &mvalue)
{
	QString value = mvalue;
	QStringList tokens;
	int pos;
	
	// get tokens
	while (value.length() > 0) {
		pos = value.find(',');
		if (pos > 0) {
			tokens += value.left(pos);
			value.remove(0, pos+1);
			value = value.stripWhiteSpace();
		} else {
			// get last token
			tokens += value;
			value = "";
		}
	}
	// create new misc ingredient
	// TODO: note that commas in the notes will cause problems
	name = mname;
	quantity	= tokens[0].toUInt();
	notes	= tokens[1];
}

///////////////////////////////////////////////////////////////////////////////
// MiscIngredientListItem class

MiscIngredientListItem::MiscIngredientListItem(QListView * parent, QString a, QString b = QString::null,
			QString c = QString::null, QString d = QString::null, QString e = QString::null,
			QString f = QString::null, QString g = QString::null, QString h = QString::null )
			: QListViewItem(parent, a, b, c, d, e, f, g, h) { mit = NULL; };

MiscIngredientListItem::~MiscIngredientListItem() {}

MiscIngredientIterator MiscIngredientListItem::getMiscIngredientIterator() { return mit; }

void MiscIngredientListItem::setMiscIngredientIterator(MiscIngredientIterator &it) { mit = it; }

void MiscIngredientListItem::setToIterator()
{
	setText(0, (*mit).getName());
	setText(1, (*mit).getQuantityString());
	setText(2, (*mit).getNotes());
}
