/***************************************************************************
                          ingredientpage.cpp  -  a page for ingredientTab
                             -------------------                                         
    begin                : Fri Oct 8 1999                                           
    copyright            : (C) 1999 by David Johnson                         
    email                : arandir@meer.net                                     

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#include <qpixmap.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "qbrewview.h"

#include "ingredientpage.h"
#include "add.xpm"
#include "apply.xpm"
#include "remove.xpm"

IngredientPage::IngredientPage(QWidget *parent, const char *name, QObject *doc, QObject *calc) : QWidget(parent,name)
{
	// get document and calcdata
	view = (QBrewView *)parent;
	document = (QBrewDoc *)doc;
	calcdata = (QBrewCalc *)calc;
	
	// setup widgets
	itemsListView = new QListView(this, "itemsListView");
	itemsListView->addColumn(tr("Item"));
	itemsListView->addColumn(tr("Quantity"));
	itemsListView->setColumnAlignment(0, AlignLeft);
	itemsListView->setColumnAlignment(1, AlignRight);
	itemsListView->setSorting(0);
	itemsListView->setSorting(1);
			
	itemLabel = new QLabel(tr("Item"), this, "itemLabel");
	itemCombo = new QComboBox(true, this, "itemCombo");
	quantityLabel = new QLabel(tr("Quantity"), this, "quantityLabel");	
	quantitySpin = new FixedSpinBox(0, 10000, 25, 2, this, "quantitySpin");
	
	addButton = new QPushButton(this, "addButton");
	addButton->setPixmap(addIcon);
	addButton->setAccel( CTRL+Key_Insert );
	QToolTip::add(addButton, tr("Add Ingredient"));
	QWhatsThis::add(addButton, tr("Click the button to add the current ingredient to the recipe\n\n"
			"You can also type Ctrl+Insert to apply an ingredient"));
	applyButton = new QPushButton(this, "applyButton");
	applyButton->setPixmap(applyIcon);
	applyButton->setAccel( CTRL+Key_Enter );
	QToolTip::add(applyButton, tr("Apply/Change Ingredient"));
	QWhatsThis::add(applyButton, tr("Click the button to apply or change the current ingredient to the recipe\n\n"
			"You can also type Ctrl+Enter to apply an ingredient"));
	removeButton = new QPushButton(this, "removeButton");
	removeButton->setPixmap(removeIcon);
	removeButton->setAccel( CTRL+Key_Delete );
	QToolTip::add(removeButton, tr("Remove Ingredient"));
	QWhatsThis::add(removeButton, tr("Click the button to remove the current ingredient from the recipe\n\n"
			"You can also type Ctrl+Delete to remove an ingredient"));
			
	spacer = new QWidget(this, "spacer");

	// setup layout
	pageLayout = new QVBoxLayout(this, 6, 3, "pageLayout");
	rowOneLayout = new QHBoxLayout(6, "rowOneLayout");
	rowTwoLayout = new QHBoxLayout(6, "rowTwoLayout");

	pageLayout->addWidget(itemsListView, 0);
	pageLayout->addLayout(rowOneLayout, 1);
	pageLayout->addLayout(rowTwoLayout, 0);

	rowOneLayout->addWidget(itemLabel, 0);
	rowOneLayout->addWidget(itemCombo, 1);
}

IngredientPage::~IngredientPage() {}

///////////////////////////////////////////////////////////////////////////////
// member access routines











