/****************************************************************************
** helpwindow.h
**
** This file originated as part of an example program for Qt.  This
** file may be used, distributed and modified without limitation.
**
** Thanks to Troll Tech for their generosity in granting me permission to
** modify this class for the needs of my program - David Johnson
**
*****************************************************************************/

#ifndef HELPWINDOW_H
#define HELPWINDOW_H

#include <qtextbrowser.h>
#include <qmainwindow.h>

class HelpWindow : public QMainWindow
{
	Q_OBJECT
public:
	/** constructor */
	HelpWindow( const QString& home_,  const QString& path, QWidget* parent = 0, const char *name=0 );
	/** destructor */
	~HelpWindow();

private slots:
	/** set if back button available */
	void setBackwardAvailable( bool );
	/** set if forward button available */
	void setForwardAvailable( bool );
	/** if text has changed */
	void textChanged();

private:
	QTextBrowser* browser;
	int backwardId, forwardId;
};

#endif





