/*
 * Copyright (c) 1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include "prototypes.h"
#include <sys/types.h>
#include <stdlib.h>
#include <string.h>
#include <tcl.h>
#include <tk.h>
#include <signal.h>


#define HASH_TABLE_SIZE 5000

/*Global vars */
int ttl;
int max_block_len;
char maddress[250];
int port;
int tx_fd, rx_fd;
int logging;
int enc;

/*local address and port */
unsigned long ipaddr;
unsigned short localport;

unsigned short processid;
extern queue sendq;
extern queue rtxq;
extern p_list plist;
extern Tcl_Interp *interp;

#define BLACK 7
extern u_int8 cur_col;
extern recent_list rl;
extern missing_list ml;

struct timeval rtx_time;

extern int s_message_type;
extern const int NORMAL_S_MESSAGE;


char *username;
char hostname[MAXHOSTNAMELEN];
char domainname[MAXHOSTNAMELEN];
char sessionname[MAX_SESSION_NAME_LEN];
char vanityname[MAX_SESSION_NAME_LEN];
char os_version[MAX_SESSION_NAME_LEN];
char nt_version[MAX_SESSION_NAME_LEN];
char charset[MAX_SESSION_NAME_LEN];
int ui_quit();

char command[40];

/*sliding key used for retransmissions */
extern sliding_key skey;

/*our local key for matching against the sliding key of others */
extern u_int16 lkey;

/*our estimate of number of members in the conference */
extern int confsize;

int checksum_active = 1;	/* checksum activation */

char usage[] = "\
Usage:  nte [-t <ttl>] [-p | +p] [-bl <max block len>] [-display <display>] [-C <session name>] [-N <user name>] [-charset <charset>] <address>/<port>\n";

int main(argc, argv)
char **argv;
int argc;
{
    int i, participants = -1;
    struct hostent *addr;
    unsigned long netaddr;
    struct utsname uts;
#ifdef WIN32
    HKEY hKeyResult;
    DWORD dwDisp;
    int buffersz = 255;
    char buffer[255];
#endif

    gethostname(hostname, MAXHOSTNAMELEN);
    addr = gethostbyname(hostname);
    if (addr == NULL) {
	fprintf(stderr, "nte:  your machine does not exist (address resolution failed)\n");
	exit(0);
    }
    strcpy(hostname, addr->h_name);
    memcpy(&netaddr, (addr->h_addr_list[0]), 4);
    ipaddr = ntohl(netaddr);
    debug("ipaddress: %x\n", ipaddr);

    debug("hostname: %s\n", hostname);
    strcpy(nt_version, NT_VERSION);

#ifdef WIN32
    RegCreateKeyEx(HKEY_CURRENT_USER, "Software\\Mbone Applications\\nte\\", 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKeyResult, &dwDisp);
    RegSetValueEx(hKeyResult, "version", 0, REG_SZ, NT_VERSION, strlen(NT_VERSION));
    RegCloseKey(hKeyResult);
#endif

    uname(&uts);
    strcpy(os_version, uts.sysname);
    strcat(os_version, " ");
    strcat(os_version, uts.release);

    debug("%s\n", os_version);
    debug("%s\n", nt_version);

    processid = (unsigned short) getpid();

    username = (char *) getenv("USER");
    if (username == NULL)
	username = (char *) getenv("LOGNAME");
#ifdef WIN32
    if (username == NULL) {
	dwDisp = REG_SZ;
	RegCreateKeyEx(HKEY_CURRENT_USER, "Software\\Mbone Applications\\common\\", 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKeyResult, &dwDisp);
	if (ERROR_SUCCESS == RegQueryValueEx(hKeyResult, "*rtpName", 0, &dwDisp, buffer, &buffersz))
	    username = (char *) buffer;
	RegCloseKey(hKeyResult);
    }
#endif
    if (username == NULL)
	username = (char *) "unknown";
    debug("username : %s\n", username);

    ttl = 16;
    port = 32414;
    logging = 0;
    enc = 0;
    if (getenv("NTE_MAX_BLOCK_LEN") != NULL) {
	max_block_len = atoi(getenv("NTE_MAX_BLOCK_LEN"));
    } else {
	max_block_len = MAX_BLOCK_LEN;
    }
    strcpy(maddress, "224.9.9.9");
    strcpy(sessionname, "nte");
    strcpy(charset, "iso8859-1");
    sprintf(vanityname, "%s@%s", username, hostname);
    for (i = 1; i < argc; i++) {
	if ((strncmp(argv[i], "-t", 3) == 0) && ((i + 1) < argc)) {
	    if (strlen(argv[i + 1]) > 3) {
		goto error;
	    }
	    ttl = atoi(argv[i + 1]);
	    argv[i] = "";
	    argv[i + 1] = "";
	}
	if ((strncmp(argv[i], "-s", 3) == 0) && ((i + 1) < argc)) {
#ifdef WIN32
	    Sleep(9000);
#else
	    /* need unix version of sleep here */
#endif
	}
	if ((strncmp(argv[i], "-bl", 4) == 0) && ((i + 1) < argc)) {
	    max_block_len = atoi(argv[i + 1]);
	    argv[i] = "";
	    argv[i + 1] = "";
	}
	if ((strncmp(argv[i], "-C", 3) == 0) && ((i + 1) < argc)) {
	    strncpy(sessionname, argv[i + 1], MAX_SESSION_NAME_LEN - 1);
	    argv[i] = "";
	    argv[i + 1] = "";
	}
	if ((strncmp(argv[i], "-N", 3) == 0) && ((i + 1) < argc)) {
	    if (strlen(argv[i + 1]) > (MAX_SESSION_NAME_LEN - 1)) {
		goto error;
	    } else {
		strncpy(vanityname, argv[i + 1], MAX_SESSION_NAME_LEN - 1);
		argv[i] = "";
		argv[i + 1] = "";
	    }
	}
	if ((strncmp(argv[i], "-k", 3) == 0) && ((i + 1) < argc)) {
	    Set_Key(argv[i + 1]);
	    enc = 1;
	    argv[i] = "";
	    argv[i + 1] = "";
	}
	if ((strncmp(argv[i], "-U", 3) == 0) && ((i + 1) < argc)) {
	    username = (char *) argv[i + 1];
	    argv[i] = "";
	    argv[i + 1] = "";
	}
	if (strncmp(argv[i], "-p", 3) == 0) {
	    participants = 0;
	}
	if (strncmp(argv[i], "+p", 3) == 0) {
	    participants = 1;
	}
	if (strncmp(argv[i], "-log", 4) == 0) {
	    logging = 1;
	}
	if ((strncmp(argv[i], "-charset", 9) == 0) && ((i + 1) < argc)) {
	    if (strlen(argv[i + 1]) > (MAX_SESSION_NAME_LEN - 1)) {
		fprintf(stderr, "charset must be less than 255 characters");
		goto error;
	    }
	    strncpy(charset, argv[i + 1], MAX_SESSION_NAME_LEN - 1);
	    argv[i] = "";
	    argv[i + 1] = "";
	}
    }
    if ((argv[argc - 1] != NULL) & (argc > 1)) {
	int maddress_length;
	char *pstr;
	pstr = strchr(argv[argc - 1], '/');
	if (pstr != NULL) {
	    pstr[0] = '\0';
	    pstr++;
	    port = atoi(pstr);
	} else {
	    goto error;
	}

	maddress_length = strlen(argv[argc - 1]);
	if (maddress_length > 250) {
	    fprintf(stderr, "multicast address must be less than 250 characters\n");
	    goto error;
	} else {
	    strncpy(maddress, argv[argc - 1], 250);
	}
    }
    debug("ttl=%d ", ttl);
    debug("multicast address: %s  port: %d\n", maddress, port);

    /*Initialise Session Message Type as the normal type */

    s_message_type = NORMAL_S_MESSAGE;	/* to store current session message type */

    /*Initialise network sockets */
    rx_fd = rx_sock_init(maddress, port, ttl);
    tx_fd = tx_sock_init(maddress, port, ttl);
    localport = getlocalport(tx_fd);

    /*initialise tx queue */
    init_queue(&sendq);

    /*initialise retransmission queue */
    init_queue(&rtxq);

    /*initialise retransmission key */
    init_key(&skey, &lkey);

    /*initialise hash table for quick finding of lines/blocks */
    hcreate(HASH_TABLE_SIZE);

    /*Initialise the document and user data structures */
    init_ds();

    /*Initialise the tcl interpreter, and extend command set */
    ui_init(argc, argv, sessionname);

    /*Extend the tk bitmap set */
    init_bitmaps();

    /*Enable/Disable logging */
    if (logging == 1) {
	Tcl_SetVar(interp, "crclog", "TRUE", TCL_GLOBAL_ONLY);
    } else {
	Tcl_SetVar(interp, "crclog", "FALSE", TCL_GLOBAL_ONLY);
    }

    /*Enable/Disble Encryption in UI */
    if (enc == 1) {
	Tcl_SetVar(interp, "encrypt", "1", TCL_GLOBAL_ONLY);
    } else {
	Tcl_SetVar(interp, "encrypt", "0", TCL_GLOBAL_ONLY);
    }

    /* Set the character set being used */
    Tcl_SetVar(interp, "charset", charset, TCL_GLOBAL_ONLY);

    /*actuallly create the interface */
    ui_create_interface(rx_fd, participants);

    cur_col = BLACK;
    init_participant_list(&plist, cur_col);
    init_missing_list(&ml);
    init_recent_list(&rl);

    /*send our first session message, and start timer for rest */
    send_session_message();

    signal(SIGINT, (void (*)) ui_quit);
    Tk_MainLoop();
    return 0;

  error:
    fprintf(stderr, usage);

/* must return a value as this is an int function */
    return (0);
}
