//#include <stdio.h>

//#include <netinet/in.h>

#define NAPSTER_MESSAGE 109
#define NAPSTER_STATUS_MESSAGE (-42)
#define NAPSTER_USER_MESSAGE_IN (-51)
#define NAPSTER_SEARCH_RESULT (-55)
#define NAPSTER_END_SEARCH (-54)
#define NAPSTER_BROWSE_RESULT (-44)
#define NAPSTER_END_BROWSE (-43)
#define NAPSTER_BROWSE_ERROR (-46)
#define NAPSTER_DOWNLOAD_REPLY (-52)
#define NAPSTER_DOWNLOAD_ERROR (-50)
#define NAPSTER_WHOIS_REPLY (92)
#define NAPSTER_WHOIS_OFFLINE (93)
#define NAPSTER_USER_ERROR (-108)
#define NAPSTER_CHAN_JOIN (-107)
#define NAPSTER_CHAN_USERLIST (-104)
#define NAPSTER_CHAN_USERLIST_END (-103)
#define NAPSTER_CHAN_TOPIC (-102)
#define NAPSTER_CHAN_JOINUSER (-106)
#define NAPSTER_CHAN_PARTUSER (-105)

#define NAPSTER_LOGIN "\2"
#define NAPSTER_NEW_USER "\7"
#define NAPSTER_SEARCH "\310"
#define NAPSTER_GET "\313"
#define NAPSTER_USER_MESSAGE "\315"
#define NAPSTER_WHOIS_REQUEST "[\2"
#define NAPSTER_BROWSE "\323"
#define NAPSTER_JOIN_CHAN "\220\1"
#define NAPSTER_PART_CHAN "\221\1"
#define NAPSTER_CHAN_MESSAGE "\222\1"

typedef struct _nap_download {
   char *trunc_file;
   char *file;
   char *user;
   int connection;
   int port;
   unsigned long int ip;
   
   struct sockaddr_in saddr;
   
   int sock;
   int sock_input;
   FILE *fdesc;
   char *fpath;
   char header[40];
   int header_val;
   int size;
   int total;
} NAP_DOWNLOAD;

typedef struct _nap_search {
   char *file;
   char *trunc_file;
   char *id;
   int size;
   int kbps;
   int freq;
   int num;
   char *user;
   unsigned long int ip;
   int connection;
} NAP_SEARCH;

void napster_get_best_host();
void napster_connect(char *, int);
void napster_connect_user(NAP_DOWNLOAD *);
void napster_bind(int);
void napster_send_get(int, char *, char *, int);
void napster_send(int, char *, char *);
void napster_handle_data(char, char *);
int napster_conn_as_int(char *);
char *napster_conn_as_str(int);
