/* gnapster.c - controls main loop and various run-time GUI changes */

#include <stdio.h>

#include <sys/stat.h>
#include <unistd.h>
#include <netinet/in.h>

#include <gnome.h>

#include "napster.h"
#include "gnapster.h"
#include "ui.h"
#include "callbacks.h"

GNAPSTER_MAIN gnapster_main;
SEARCH_TAB search_tab;
DOWNLOAD_TAB download_tab;
CONSOLE_TAB console_tab;
CHAT_TAB chat_tab;
MOTD_TAB motd_tab;

PROP_DLG prop_dlg;

CONN_INFO conn_info;
USER_INFO user_info;

void conv_file(char *s) {
   int i = 0;

   if (!user_info.name_fix) return;
   
   while(s[i]) {
      if (s[i] == ' ') s[i] = '_';
      i++;
   }
}

FILE *open_file(NAP_DOWNLOAD *download, char *file) {
   FILE *f;
   char *temp_str, *temp_str2;
   int inc = 1;
   
   temp_str = g_strdup_printf("%s/%s", user_info.download_dir, file);
   conv_file(temp_str);
   if (file_exists(temp_str)) {
      temp_str2 = g_strdup_printf("%s.%i", temp_str, inc);
      conv_file(temp_str2);
      while(file_exists(temp_str2)) {
	 temp_str2 = g_strdup_printf("%s.%i", temp_str, inc);
	 conv_file(temp_str2);
	 inc++;
      }
   } else temp_str2 = strdup(temp_str);
   
   f = fopen(temp_str2, "w");
   download->fpath = strdup(temp_str2);
   
   if (strcmp(temp_str, temp_str2)) {
      char *temp_str3;
      temp_str3 = g_strdup_printf("File already exists, using backup file %s...\n",
				  temp_str2);
      gnapster_text_insert(console_tab.text, console_tab.vbox, temp_str3);
      free(temp_str3);
   }
   
   if (temp_str) free(temp_str);
   if (temp_str2) free(temp_str2);
   return f;
}

int file_exists(char *file) {
   struct stat st;
   int x;
   
   x = stat(file, &st);
   if (x < 0) return 0;
   
   return 1;
}

NAP_DOWNLOAD *gnapster_parse_download(char *s) {
   char *trunc_file, *file, *extra, user[40], id[40];
   int port, connection;
   unsigned long int ip;
   NAP_DOWNLOAD *temp;
   
   file = strchr(s, '\"');
   if (!file) return NULL;
   file[0] = '\0';
   file++;
   extra = strchr(file, '\"');
   extra[0] = '\0';
   extra += 2;

   trunc_file = strrchr(file, '\\');
   if (trunc_file) trunc_file++;
   else trunc_file = file;   
   
   sscanf(s, "%39s %lu %i", user, &ip, &port);
   sscanf(extra, "%39s %i", id, &connection);
   
   temp = malloc(sizeof(NAP_DOWNLOAD));
   temp->trunc_file = strdup(trunc_file);
   temp->file = strdup(file);
   temp->user = strdup(user);
   temp->connection = connection;
   temp->port = port;
   temp->ip = ip;
   
   return temp;
}

NAP_SEARCH *gnapster_parse_search(char *s) {
   char *trunc_file, *file, user[40], id[40];
   int num, size, kbps, freq, connection;
   unsigned long int ip;
   NAP_SEARCH *temp;

   file = s;
   file++;
   s = strchr(file, '\"');
   if (!s) return NULL;
   s[0] = '\0';
   s++;
   
   trunc_file = strrchr(file, '\\');
   if (trunc_file) trunc_file++;
   else trunc_file = file;
   
   sscanf(s, " %39s %i %i %i %i %39s %lu %i",
	  id, &size, &kbps, &freq, &num, user, &ip, &connection);
   
   temp = malloc(sizeof(NAP_SEARCH));
   temp->trunc_file = strdup(trunc_file);
   temp->file = strdup(file);
   temp->user = strdup(user);
   temp->id = strdup(id);
   temp->num = num;
   temp->size = size;
   temp->kbps = kbps;
   temp->freq = freq;
   temp->connection = connection;
   temp->ip = ip;
   
   return temp;
}

NAP_SEARCH *gnapster_parse_browse(char *s) {
   int i = 0, flag = 0, x = 0, z = 0;
   char values[10][1024];
   char *trunc_file;
   NAP_SEARCH *temp;
   
   while(s[i]) {
      if (s[i] == '\"' && !flag) flag = 1;
      else if (s[i] == '\"' && flag) flag = 0;
      else if (s[i] == ' ' && !flag) {
	 values[x][z] = '\0';
	 z = 0;
	 x++;
      } else values[x][z++] = s[i];
      i++;
   }
   values[x][z] = '\0';
   
   trunc_file = strrchr(values[1], '\\');
   trunc_file++;
   
   temp = malloc(sizeof(NAP_SEARCH));
   temp->trunc_file = strdup(trunc_file);
   temp->file = strdup(values[1]);
   temp->user = strdup(values[0]);
   temp->id = strdup(values[2]);
   temp->num = atoi(values[6]);
   temp->size = atoi(values[3]);
   temp->kbps = atoi(values[4]);
   temp->freq = atoi(values[5]);
   /* Unknown fields */
   temp->connection = 0;
   temp->ip = 0;
   
   return temp;
}

int gnapster_update_appbar() {
   float val;
   gnapster_main.progress = gnome_appbar_get_progress(GNOME_APPBAR(gnapster_main.appbar));
   val = gtk_progress_get_value(GTK_PROGRESS(gnapster_main.progress));
   val += 0.5;
   if (val > 100) val = 0;
   gtk_progress_set_value(GTK_PROGRESS(gnapster_main.progress), val);
   
   return 1;
}

void gnapster_update_status(char *s, int i) {
   if (s) {
      gnome_appbar_pop(GNOME_APPBAR(gnapster_main.appbar));
      gnome_appbar_push(GNOME_APPBAR(gnapster_main.appbar), s);
   }
   if (i == 0) {
      gtk_timeout_remove(gnapster_main.appbar_timeout);
   } else if (i == 1) {
      if (gnapster_main.appbar_timeout) gtk_timeout_remove(gnapster_main.appbar_timeout);
      gnapster_main.appbar_timeout = gtk_timeout_add(50, gnapster_update_appbar,
						     NULL);
   }
}

void gnapster_highlight(GtkWidget *vbox) {
   GtkWidget *label, *notebook_page;
   int curr_page;
   
   label = gtk_notebook_get_tab_label(GTK_NOTEBOOK(gnapster_main.notebook),
				      vbox);
   curr_page = gtk_notebook_get_current_page(GTK_NOTEBOOK(gnapster_main.notebook));
   notebook_page = gtk_notebook_get_nth_page(GTK_NOTEBOOK(gnapster_main.notebook), 
					     curr_page);
   if (notebook_page != GTK_WIDGET(vbox))
     gtk_widget_set_style(label, gnapster_main.highlight);   
}

int gnapster_clist_sort(GtkCList *clist, const void *ptr1, const void *ptr2) {
   int conn1, conn2;
   GtkCListRow *row1, *row2;
   char *text1, *text2;
   
   row1 = (GtkCListRow *)ptr1;
   row2 = (GtkCListRow *)ptr2;
   
   text1 = GTK_CELL_TEXT(row1->cell[clist->sort_column])->text;
   text2 = GTK_CELL_TEXT(row2->cell[clist->sort_column])->text;
   
   conn1 = napster_conn_as_int(text1);
   conn2 = napster_conn_as_int(text2);
   
   if (conn1 == -1 || conn1 <= conn2) return 1;
   if (conn2 == -1 || conn2 < conn1) return -1;
   
   /* Default to conn1 */
   return 1;
}

void gnapster_text_insert(GtkWidget *text, GtkWidget *vbox, char *format_str) {
   int i = 0, x = 0;
   char buf[1024];
   static GdkColor colors[] = {
      { 0, 0x0000, 0x0000, 0x0000 },
      { 0, 0x0000, 0x0000, 0x7FFF },
      { 0, 0x7FFF, 0x0000, 0x0000 },
      { 0, 0x0000, 0x0000, 0x0000 },
      { 0, 0xaaaa, 0x0000, 0x0000 },
   };
   GdkColor *col, *old_col;
   
   while(format_str[i]) {
      old_col = col;
      switch(format_str[i]) {
       case '':
//	 col = &colors[0];
	 col = &gnapster_main.normal->fg[GTK_STATE_NORMAL];
	 break;
       case '':
//	 col = &colors[1];
	 col = &gnapster_main.highlight->fg[GTK_STATE_NORMAL];
	 break;
       case '':
	 col = &colors[2];
	 break;
       case '':
	 col = &colors[3];
	 break;
       default:
	 buf[x++] = format_str[i];
      }
      if (old_col != col || format_str[i] == '\n') {
	 buf[x] = '\0';
	 x = 0;
	 gtk_text_insert(GTK_TEXT(text), NULL, old_col, NULL, buf, -1);
      }
      i++;
   }
   
   gnapster_highlight(vbox);
}

void gnapster_clist_append(GtkWidget *clist, GtkWidget *vbox, void *data, char *s1, char *s2,
			   char *s3, char *s4, char *s5) {
   char *add_id[6] = { s1, s2, s3, s4, s5, NULL };
   int i;
   
   if (!data) return;
   
   for(i=0; i<5; i++) {
      if (!add_id[i]) add_id[i] = "???";
   }
   
   gtk_clist_append(GTK_CLIST(clist), add_id);
   gtk_clist_set_row_data(GTK_CLIST(clist), g_list_length(GTK_CLIST(clist)->row_list) - 1,
			  data);

   gnapster_highlight(vbox);
}

void gnapster_get_styles(GtkWidget *widget) {
   gnapster_main.normal = gtk_widget_get_style(widget);
   gnapster_main.highlight = gtk_style_new();
   gnapster_main.highlight->font = gnapster_main.normal->font;
   gnapster_main.highlight->fg[GTK_STATE_NORMAL] =
     gnapster_main.normal->fg[GTK_STATE_SELECTED];
}

int idle_startup_cb(gpointer data) {
//   printf("data -> %s\n", (char *)data);
   if (!strcmp(data, "connect"))
     connect_cb();
   else if (!strcmp(data, "props"))
     preferences_cb();
   return 0;
}

int main(int argc, char **argv) {
   gnome_init("gnapster", VERSION, argc, argv);
   
   create_gnapster_main();
   
   create_search_tab();
   create_download_tab();
   create_console_tab();
   /* This has been disabled in the release because it's fucked, I'll
    * fix it and enable it later */
/*   create_chat_tab();*/
   create_motd_tab();
   
   gtk_widget_show_all(gnapster_main.window);
   gnapster_get_styles(gnapster_main.window);

   conn_info.connected = 0;
   conn_info.connecting = 0;

   user_info.new_user = user_info.name_fix = 0;
   user_info.chan = NULL;
   
   user_info.user = gnome_config_get_string("/gnapster/User/user");
   if (!user_info.user) {
      gnapster_update_status("Please fill out the preferences form before trying to connect.", -1);
      gtk_idle_add(idle_startup_cb, "props");
   } else {
      gnapster_update_status("Auto-connecting...", -1);
      user_info.pass = gnome_config_get_string("/gnapster/User/pass");
      user_info.download_dir = gnome_config_get_string("/gnapster/User/dl_dir");
      user_info.connection = gnome_config_get_int("/gnapster/User/connection");
      user_info.name_fix = gnome_config_get_int("/gnapster/User/name_fix");
      gtk_idle_add(idle_startup_cb, "connect");
   }
   
   napster_bind(6699);
   
   gtk_main();
   
   return 1;
}
