/* GKrellM
|  Copyright (C) 1999 Bill Wilson
|
|  Author:	Bill Wilson		bill@gkrellm.net
|  Latest versions might be found at:
|		http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation, Inc.,
|  59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <gtk/gtk.h>
#include <gdk_imlib.h>

/* To get at the private structure of pixmaps (for sizes)
*/
#include <gdk/gdkx.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <time.h>
#include <signal.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <net/if.h>
#include <net/ppp_defs.h>

/* -------------------------------------------------------------------
*/
#define	VERSION_MAJOR	0
#define	VERSION_MINOR	7
#define	VERSION_REV		5

#define	GKRELLM_DIR				".gkrellm"
#define	GKRELLM_USER_CONFIG		".gkrellm/user_config"
#define	GKRELLM_THEME			".gkrellm/gkrellm_theme.cfg"
#define	GKRELLM_DATA_DIR		"+data"
#define GKRELLMRC				"gkrellmrc"


#define	ON				1
#define	OFF				0

  /* Enumerate net interfaces I know how to provide default scales for.
  */
#define	PPP				0
#define	PLIP			1
#define	ETH				2
#define	NET_OTHER		3
#define	N_NET_IFACES	4

  /* Label midpoints are positioned as a percent of chart_width.
  */
#define	LABEL_NONE		-1
#define	LABEL_CENTER	50
#define LABEL_MAX		100

#define	N_LEDS					4

#define	DECAL_BLANK				0
#define	DECAL_AC				1
#define	DECAL_BATTERY			2
#define	DECAL_BATTERY_WARN		3
#define	DECAL_FS_UM				4
#define	DECAL_FS_M				5
#define	DECAL_FS_UM_MOUNTABLE	6
#define	DECAL_FS_M_MOUNTABLE	7
#define DECAL_MAIL_NOMAIL		8
#define DECAL_MAIL0				9
#define DECAL_MAIL1				10
#define DECAL_UNDEF				11
#define	N_DECALS				12

#define	GRID_MODE_NORMAL		0
#define	GRID_MODE_RESTRAINED	1

#define	CPU_TICKS_PER_SECOND	100		/* XXX */
#define	FULL_SCALE_GRIDS		5


#define TEXTSTYLE_LABEL			0
#define TEXTSTYLE_METER			1
#define TEXTSTYLE_TIME			2
#define TEXTSTYLE_ALT1			3
#define TEXTSTYLE_ALT2			4

typedef struct
	{
	GdkFont		*font;
	GdkColor	color;
	gint		effect;
	}
	TextStyle;

  /* Values for Decal type
  */
#define	DECAL_TRANSPARENCY		0
#define	DECAL_OPAQUE			1
#define	DECAL_ZOMBIE			2

  /* A decal is a pixmap or a part of a pixmap drawn on a panel.  The
  |  pixmap can be a graphic, a vertical stack of graphics, or a drawn
  |  text string - as structured by the creating monitor.
  */
typedef struct _Decal
	{
	struct _Decal
				*next;
	GdkPixmap	*pixmap;
	GdkBitmap	*mask;
	gint		y_src;		/* Offset into pixmap if a vertical stack	*/
	gint		w, h;		/* Size of the decal						*/
	gint		x, y;		/* Position of decal in a drawable			*/

	TextStyle	text_style;	/* Used if decal is a drawn text string		*/
	gint		y_baseline;
	
	gint		type;
	gint		value,		/* Index into stack, text value, etc	*/
				modified;
	}
	Decal;


typedef struct
	{
	gchar		*string;
	gint		lbearing,
				rbearing,
				width,
				ascent,
				descent;
	gint		position;		/* 0 - 100 %	*/
	gint		x_panel;		/* x position of label start in panel */
	gint		y_baseline;
	gint		h_panel;
	TextStyle	textstyle;
	}
	Label;


typedef struct
	{
	gint		x_src;
	gint		y_src;
	gint		x_dst;
	gint		y_dst;
	gint		w;
	gint		h;
	}
	Draw_rec;

  /* Some of these style entries do not apply to all monitors.
  */
typedef struct
	{
	gint		label_position;
	gint		krell_enable,
				krell_yoff,
				krell_expand,
				krell_x_hot,
				krell_ema_period,
				krell_depth;
	GdkImlibBorder
				border_panel,
				border_chart;
	}
	Style;

  /* The Panel of each Chart or Meter can have a moving indicator
  |  representing a current sampled data value as a fraction of some full
  |  scale value.  Since there can be quite a few of them dancing around on
  |  a maxed out GKrellM display, I call them Krells.  See Forbidden Planet.
  */
  /* Krell.expand values (not sure I will keep these in) */
#define	NONE	0
#define	LEFT	1
#define	RIGHT	2

typedef struct _Krell
	{
	struct _Krell
				*next;
	gchar		*name;
	GdkPixmap	*pixmap;
	GdkBitmap	*mask;
	gint		w, h;	/* Of the full Krell - all the frames included */
	gint		expand;	/* How this Krell was preprocessed in config.c */
	gint		depth;	/* How many vertical frames in the krell image */

	GdkBitmap	*stencil;
	gint		h_stencil;	/* Height of one frame + y0 offset	*/
							/* Include y0 here so no need to set_clip_origin */
	gint		modified;	/* True if krell has moved.			*/

	gint		reading;
	gint		last_reading;
	gint		full_scale;
	gulong		previous;

	gint		x_hot;		/* Offset in Krell pixmap to hot spot */
	gint		x_position;	/* Current position of x_hot in Panel */

	gint		x0,		/* Offset in Panel to start of Krell scale range */
				y0;
	gint		w_scale;		/* Width of active range. */

	Draw_rec	old_draw;	/* Last draw for restoring background.	*/
	Draw_rec	draw;		/* Parameters to currently drawn krell	*/

	gint		ema;		/* exponential moving average */
	gint		period;		/* of ema */
	gint		full_scale_expand;
	}
	Krell;


typedef struct
	{
	GtkWidget	*hbox;			/* Container box this area is packed into */
	GtkWidget	*fixed;			/* Fixed container for drawing_area + ?	*/
	GtkWidget	*drawing_area;
	GdkPixmap	*pixmap;		/* Expose pixmap */
	GdkBitmap	*mask;
	GdkPixmap	*background;	/* Copy of rendered bg, used for stenciling */
	GdkBitmap	*stencil;		/* A stencil bitmap of the same size.	*/
	GdkGC		*stencil_gc;	/* And a gc for drawing on the stencil	*/

	Decal		*decal;			/* Linked list of decals for this panel	*/
	Krell		*krell;			/* Linked list of krells for this panel	*/
	Label		label;
	Style		*style;
	gint		modified;		/* True if a decal is modified.			*/
	gint		x, y, w, h;
	}
	Panel;


typedef struct
	{
	gchar		*name;
	Panel		panel;

	GtkWidget	*hbox;			/* Container box this chart is packed into */
	GtkWidget	*drawing_area;
	GdkPixmap	*pixmap;			/* The expose pixmap.		*/

	GdkPixmap	*bg_clean_pixmap;	/* Original background pixmap	*/
	GdkPixmap	*bg_grided_pixmap;	/* Background pixmap with grid lines */
	GdkPixmap	*grid_pixmap;		/* Background grid pixmap	*/

	GdkPixmap	*in_grided_pixmap,	/* Data_in image with grid lines on it	*/
				*out_grided_pixmap;	/* Data_out image with grid lines on it	*/
	GdkBitmap	*in_data_bitmap,	/* Draw in_data here and use as stencil */
				*out_data_bitmap;	/* Draw out_data here and use as stencil */

	gint		x, y, w, h;		/* Location inside monitor */
	gint		private;
	gint		type;			/* 0 - Normal stacked bar, 1 - proc special */
	gint		i0;				/* Draw start index */
	gint		*pDataOut,
				*pDataIn;

	gint		in_maxval,		/* To get data enclosing rectangle to 	*/
				out_maxval;		/*  optimize chart stencil draws.		*/
	gint		maxval;

	gint		scale_max;
	gint		scale_min;
	unsigned long		prevOut,
						prevIn,
						prevTotal;
	gint		position;
	gint		primed;
	}
	Chart;



/* ================= User Config ==================*/
#define	NET_UNITS_PACKETS	0
#define	NET_UNITS_BYTES		1


#define	MON_CPU		0
#define	MON_PROC	1
#define	MON_DISK	2
#define	MON_NET		3
#define	MON_INET	4
#define	N_CHART_MONITORS 5
#define	MON_MEMINFO	5
#define	MON_FS		6
#define	MON_MAIL	7
#define	MON_APM		8
#define	MON_UPTIME	9

#define	N_MONITORS	10

struct UserConfig
	{
	gint	enable[N_MONITORS];		/* Not used for all monitors */
	gint	enable_hostname;
	gint	enable_clock;
	gint    enable_mailcheck;
	gint	enable_extra_info;
	gint	save_position;

	gint	fixed_scale;			/* 0 => autoscale, or 1-5 fixed grids */
	gint	on_top;
	gint	update_HZ;

	gint	enable_net_timer,
			net_timer_is_ppp;		/* Could be for ippp0 or anything */

	gint	clock_24hr_format;
	gint	clock_12hr_seconds;
	gint	hostname_short;
	gint	sensor_temp_fahrenheit;

	gint	chart_width;
	gint	chart_height[N_CHART_MONITORS];

	gint	super_mute_mailcheck;
	gint	smp_mode;

	gint	proc_load_bar_graph,
			proc_processes_enable,
			load_resolution,
			proc_clip_processes;

	gint	disk_resolution;
	gint	enable_auto_eject;

	gchar	*ppp_on_command,
			*ppp_off_command;

	gint	ema_period;
	gint	bump_HZ;
	};

extern struct UserConfig  UC;
extern struct UserConfig  UCdef;

/* ================= Theme Config ==================*/

#define	DEFAULT_IMAGE	0

#define	CPU_IMAGE		1
#define	DISK_IMAGE		2
#define	NET_IMAGE		3
#define	PROC_IMAGE		4
#define	INET_IMAGE		5
#define	N_CHART_IMAGES	6		/* Including the DEFAULT_IMAGE */

#define	MEM_IMAGE		1
#define	SWAP_IMAGE		2
#define	FS_IMAGE		3
#define	MAIL_IMAGE		4		/* Sort of a meter	*/
#define	APM_IMAGE		5
#define	N_METER_IMAGES	6		/* Including the DEFAULT_IMAGE */

struct	ThemeConfig
	{
	gchar	*theme_path;

	gint	initialized;
	gchar	*geometry;		/* +x+y or -x-y styles only		*/

	gint	frame_width;
	gint	chart_width_min;
	gint	chart_width_max;
	gint	chart_width_ref;

	gint	chart_height_min;
	gint	chart_height_max;
	gint	allow_scaling;

	  /* All net interfaces have a label and two leds */
	gint	rx_led_x;
	gint	rx_led_y;
	gint	tx_led_x;
	gint	tx_led_y;

	  /* The ppp interface has additional stuff: a button and a timer */
	GdkImlibImage	*ppp_button_image;
	GdkPixmap	*ppp_button_on_pixmap,
				*ppp_button_off_pixmap;
	GdkBitmap	*ppp_button_mask;

	gint		ppp_border_mode;

	gint		timer_ticks;
	gint		second_tick,
				two_second_tick,
				ten_second_tick,
				minute_tick,
				hour_tick,
				day_tick;

	gint		up_minutes;
	gint		base_uptime;
	time_t		start_time;
	gint		cpu_sys_activity;
	gint		sensor_temp_files;

	gint		max_chart_height;
	gint		monitor_height;

	gint		on_top_hint_ok;

	Style		*chart_style[N_CHART_IMAGES],
				*meter_style[N_METER_IMAGES];

	GdkImlibImage
				*chart_grid_image[N_CHART_IMAGES],
				*bg_chart_image[N_CHART_IMAGES],
				*bg_panel_image[N_CHART_IMAGES],
				*krell_panel_image[N_CHART_IMAGES];
	GdkImlibImage
				*bg_meter_image[N_METER_IMAGES],
				*krell_meter_image[N_METER_IMAGES];

	GdkImlibImage
				*bg_spacer_image,
				*bg_bordered_image,
				*bg_timer_image;			/* Optional		*/

	GdkImlibImage
				*frame_horizontal_image,
				*frame_top_image,
				*frame_bottom_image,
				*frame_side_image,
				*frame_left_image,
				*frame_right_image;

	GdkImlibBorder
				timer_border,
				frame_top_border,
				frame_bottom_border,
				frame_side_border,
				bordered_bg_border;

	GdkPixmap	*spacer_pixmap;

	GdkImlibImage
				*led_image;
	GdkPixmap	*led_pixmap;
	GdkBitmap	*led_mask;
	gint		led_width,
				led_height;

	GdkImlibImage
				*decal_image;
	GdkPixmap	*decal_pixmap;
	GdkBitmap	*decal_mask;
	gint		decal_width,
				decal_height;

	gint		decal_mail_frames,
				decal_mail_delay;

	GdkImlibImage
				*decal_mail_image;
	GdkPixmap	*decal_mail_pixmap;
	GdkBitmap	*decal_mail_mask;
	gint		decal_mail_width,
				decal_mail_height;



	GdkGC		*draw1_GC,
				*draw2_GC,
				*draw3_GC,
				*draw4_GC,
				*text_GC;

	GdkGC		*bit1_GC,		/* Depth 1 GCs		*/
				*bit0_GC;

	GdkFont		*large_font,
				*label_font,
				*alt_font;

	gchar		*large_font_string,
				*label_font_string,
				*alt_font_string;

	gchar		*label_effect_string,
				*meter_effect_string,
				*time_effect_string,
				*alt1_effect_string,
				*alt2_effect_string;

	gchar		*label_color_string,
				*meter_color_string,
				*time_color_string,
				*alt1_color_string,
				*alt2_color_string;

	GdkColor	label_color,
				meter_color,
				time_color,
				alt1_color,
				alt2_color;

	GdkImlibImage
				*data_in_image,
				*data_out_image,
				*data_in_etch_image,
				*data_out_etch_image;

	GdkPixmap	*data_in_pixmap,
				*data_out_pixmap,
				*data_in_etch_pixmap,
				*data_out_etch_pixmap;

	gchar		*chart_in_color,
				*chart_in_color_grid,
				*chart_out_color,
				*chart_out_color_grid;

	GdkColor	in_color;	/* For cpu user, disk read, rx data	*/
	GdkColor	out_color;	/* For cpu sys, disk writes, tx data	*/
	GdkColor	in_color_etch;	/* Cosmetics */
	GdkColor	out_color_etch;
	GdkColor	background_color;
	GdkColor	white_color;

	gint		chart_grid_mode;

	gint		debug;
	gint		trace;
	gint		test;
	};

extern struct ThemeConfig  GK;

#include "proto.h"

