/**************************************************************
  (C) 1997 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifndef FILEMANAGER_H
#define FILEMANAGER_H

#include <sys/stat.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

struct item {
  char *filename;
  struct stat info;
  int type; /* 0 file 1 folder 2 linkfile 3 linkfolder */
  int mark; 
  struct item *NextItem;
  Window Iconwindow;
  Pixmap mini;
  Pixmap minis;
};

struct tree {
  struct item *ThisItem;
  struct tree *subtree;
  struct tree *nexttree;
  int initalized;/*dotree was called with this argument*/
  int expanded;
  int abletoexpand; /*if subtree=NULL then False*/
  Window Expandbutton;
  Window Expandline;
};

struct item *GetDirectory(char *filepath);

struct tree *GetFirstTree();

void DoTree(struct tree *treeinfo);

void GetLinkNameWithoutLast(char **text);

void GetLinkName(char **text);

int CopyFile(char *filename,char *goal,char *subfolder,int move);

int FileExist(char *filename);

int CreateProgramLink(char *programname);

int CreateFolder(char *foldername);

int CreateFile(char *filename);

int LinkFile(char *filename,char *subfolder);

int EraseFile(char *filename);

#endif
