
#include "config.h"
#include "edit.h"
#include "ami.h"

void
cb_status_draw(IC *ic)
{
    IMStatusCBStruct data;
    XIMFeedback feedback[2]={0};
    XIMText text;
    char *txt;
    if (ic->composing_hangul) {
	txt = editing_mbstocts(hangul_mode_label);
    } else {
	txt = editing_mbstocts(english_mode_label);
    }
    data.major_code = XIM_STATUS_DRAW;
    data.todo.draw.data.text = &text;
    text.string.multi_byte = txt;
    text.length = strlen(txt);
    text.feedback = feedback;
    data.todo.draw.type = XIMTextType;
    data.connect_id = ic->connect_id;
    data.icid = ic->id;
    IMCallCallback(xims, (gpointer)&data);
    if(debug) g_print("%s: %s\n", __FUNCTION__, txt);
}

void
cb_edit_clear_temp(IC *ic)
{
    IMPreeditCBStruct data;
    XIMText text;
    XIMFeedback feedback[2];
    char tmpbuf[3];
    char *cts;
    data.major_code = XIM_PREEDIT_DRAW;
    data.connect_id = ic->connect_id;
    data.icid = ic->id;
    data.todo.draw.caret = ic->han->pos/2;
    data.todo.draw.chg_first = ic->han->pos/2 - 1;
    data.todo.draw.chg_length = 1;

    data.todo.draw.text = &text;
    feedback[0] = XIMUnderline;
    feedback[1] = 0;
    text.feedback = feedback;
    tmpbuf[0] = ic->han->buf[ic->han->pos-2];
    tmpbuf[1] = ic->han->buf[ic->han->pos-1];
    tmpbuf[2] = '\0';
    cts = editing_mbstocts(tmpbuf);
    text.string.multi_byte = cts;
    text.length = strlen(cts);
    if (debug) g_print("%s\n",__FUNCTION__);
    IMCallCallback(xims, (gpointer)&data);
    XFree(cts);
}

void
cb_edit_correct_insert(IC *ic, char *buf)
{
    IMPreeditCBStruct data;
    XIMText text;
    XIMFeedback feedback[3];
    char *cts;
    int pos = ic->han->pos;
    if (debug) g_print("%s\n",__FUNCTION__);

    data.major_code = XIM_PREEDIT_DRAW;
    data.connect_id = ic->connect_id;
    data.icid = ic->id;
    data.todo.draw.caret = pos/2 + 1;
    data.todo.draw.chg_first = pos/2 - 1;
    data.todo.draw.chg_length = 1;

    cts = editing_mbstocts(buf);
    data.todo.draw.text = &text;
    feedback[0] = XIMUnderline;
    feedback[1] = XIMReverse;
    feedback[2] = 0;
    text.feedback = feedback;
    text.string.multi_byte = cts;
    text.length = strlen(cts);
    if (debug) g_print("%s: text length=%d\n", __FUNCTION__, text.length);

    IMCallCallback(xims, (gpointer)&data);
    XFree(cts);
}

void
cb_edit_backward_delete(IC *ic)
{
    IMPreeditCBStruct data;
    XIMText text;
    XIMFeedback feedback = 0;
    int pos = ic->han->pos;
    if (debug) g_print("%s\n",__FUNCTION__);

    data.major_code = XIM_PREEDIT_DRAW;
    data.connect_id = ic->connect_id;
    data.icid = ic->id;
    data.todo.draw.caret = pos/2 - 1;
    data.todo.draw.chg_first = pos/2 - 1;
    data.todo.draw.chg_length = 1;

    data.todo.draw.text = &text;
    text.feedback = &feedback;

    text.string.multi_byte = "";
    text.length = 0;
    IMCallCallback(xims, (gpointer)&data);
}

void
cb_edit_insert(IC *ic, char *buf)
{
    IMPreeditCBStruct data;
    XIMText text;
    char *cts;
    XIMFeedback feedback[3];
    int pos = ic->han->pos;
    if (debug) g_print("%s\n",__FUNCTION__);

    data.major_code = XIM_PREEDIT_DRAW;
    data.connect_id = ic->connect_id;
    data.icid = ic->id;
    data.todo.draw.caret = pos/2 + 1;
    data.todo.draw.text = &text;
    text.feedback = feedback;

    if (pos >= 2) {
	char tmpbuf[5];
	feedback[0] = XIMUnderline;
	feedback[1] = XIMReverse;
	feedback[2] = 0;
	tmpbuf[0] = ic->han->buf[pos-2];
	tmpbuf[1] = ic->han->buf[pos-1];
	tmpbuf[2] = buf[0];
	tmpbuf[3] = buf[1];
	tmpbuf[4] = '\0';
	data.todo.draw.chg_length = 1;
	data.todo.draw.chg_first = pos/2 - 1;
	cts = editing_mbstocts(tmpbuf);
	if (debug) g_print("tmpbuf=%s\n", tmpbuf);
    } else {
	feedback[0] = XIMReverse;
	feedback[1] = 0;
	data.todo.draw.chg_length = 0;
	data.todo.draw.chg_first = pos/2;
	cts = editing_mbstocts(buf);
    }
    text.string.multi_byte = cts;
    text.length = strlen(cts);
    if (debug) g_print("%s: len=%d\n",__FUNCTION__,text.length);

    IMCallCallback(xims, (gpointer)&data);
    XFree(cts);
}

void
cb_edit_correct(IC *ic, char *buf)
{
    IMPreeditCBStruct data;
    XIMText text;
    XIMFeedback feedback[2];
    char *cts;
    int pos = ic->han->pos;
    if (debug) g_print("%s\n",__FUNCTION__);

    data.major_code = XIM_PREEDIT_DRAW;
    data.connect_id = ic->connect_id;
    data.icid = ic->id;
    data.todo.draw.caret = pos/2;
    data.todo.draw.chg_first = pos/2 - 1;
    data.todo.draw.chg_length = 1;

    data.todo.draw.text = &text;
    feedback[0] = XIMReverse;
    feedback[1] = 0;
    text.feedback = feedback;

    cts = editing_mbstocts(buf);
    text.string.multi_byte = cts;
    text.length = strlen(cts);
    if (debug) g_print("%s: len=%d\n",__FUNCTION__,text.length);
    IMCallCallback(xims, (gpointer)&data);
    XFree(cts);
}

void
cb_edit_reset(IC *ic)
{
    IMPreeditCBStruct data;
    XIMText text;
    XIMFeedback feedback[1];
    if (debug) g_print("%s\n",__FUNCTION__);
    data.major_code = XIM_PREEDIT_DRAW;
    data.connect_id = ic->connect_id;
    data.icid = ic->id;
    data.todo.draw.caret = 0;
    data.todo.draw.chg_first = 0;
    data.todo.draw.chg_length = ic->han->pos/2;
    data.todo.draw.text = &text;
    text.feedback = feedback;
    text.length = 0;
    text.string.multi_byte = "";
    IMCallCallback(xims, (gpointer)&data);
}

void
cb_edit_toggle(IC *ic)
{
    IMPreeditCBStruct data;
    cb_status_draw(ic);
    if (ic->han->composing_hangul) {
	data.major_code = XIM_PREEDIT_START;
    } else {
	data.major_code = XIM_PREEDIT_DONE;
    }
    data.connect_id = ic->connect_id;
    data.icid = ic->id;
    IMCallCallback(xims, (gpointer)&data);
}

void
cb_edit_move(IC *ic, int howmuch)
{
    IMPreeditCBStruct data;

    data.major_code = XIM_PREEDIT_CARET;
    data.connect_id = ic->connect_id;
    data.icid = ic->id;
    data.todo.caret.position = ic->han->pos / 2;
    data.todo.caret.direction = XIMAbsolutePosition;
    data.todo.caret.style = XIMIsPrimary;
    IMCallCallback(xims, (gpointer)&data);
}

