#ifndef __AMITYPE_H
#define __AMITYPE_H

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <Ximd/IMdkit.h>
#include <Ximd/Xi18n.h>

typedef struct _IC IC;
typedef struct _HangulState HangulState;
typedef struct _DispWindow DispWindow;

struct _HangulState {
    unsigned char	*buf;
    int			buf_size;
    int			pos;
    int			len;
    unsigned char	stack[20];
    int			f, m, l;
    int			sp, last_l, last_ll;
    int			composing_hangul;
    int			has_temp_hangul;
    GtkWidget	*aux_input;
};

struct _DispWindow {
    GdkWindow *win;
    GdkWindow *win2, *win3;
    GdkGC *gc, *reverse_gc;
    GdkFont *font;
    char *fontname;
    gchar *text;
    XRectangle area;
    XRectangle area_needed;
    Cursor	cursor;		/* cursor */
    Colormap	cmap;		/* colormap */
    Pixmap	bg_pixmap;	/* background pixmap */
    int x, y;
    int caret;  /* ѱ ۳ Ŀ ġ.  ѱ .
                   minus  Է ǹ̰  status area Ÿ */
    int caret_pixel;
    int has_temp_hangul;
    int win_width;
    int linespace;
    int cn1, cn2, cn3;
    int xoffset;
    CARD32 fg, bg;
    IC *ic; /* owner */
};

struct _IC {
    CARD16	id;		/* ic id */
    CARD16	connect_id;	/* connect id */
    INT32	input_style;	/* input style */
    GdkWindow	*client_win;	/* client window */
    GdkWindow	*focus_win;	/* focus window */
    GdkWindow   *top_win;
    DispWindow	*edit_win;
    DispWindow	*status_win;
    HangulState	*han;
    int		destroyed;
    int		composing_hangul;
    IC	*next;
};

enum {
    HOTKEY_FORWARD,
    HOTKEY_DONE,
    HOTKEY_CONTINUE
};

#define AUTOMATA_NEW 0
#define AUTOMATA_CORRECT 1
#define AUTOMATA_SPECIAL 2
#define AUTOMATA_CORRECT_NEW 3
#define AUTOMATA_ERROR 4
#define AUTOMATA_NULL 5

enum {
    AMI_NORMAL_RUN,  /* Ϲ  */
    AMI_WM_RUN,      /* WindowMaker Dock applet  */
    AMI_GNOME_RUN    /* GNOME panle applet  */
} AMI_RUN_MODE;

enum {
    AMI_EDITING_WORD_MODE=1,
    AMI_EDITING_SIMPLE_WORD_MODE=2,
    AMI_EDITING_CHAR_MODE=3
} AMI_EDITING_MODE;

enum {
    HANJA_HANJA=1,
    HANJA_HANJA_HANGUL=2,
    HANJA_HANGUL_HANJA=3
} HANJA_SUBST_MODE;

#endif /* __AMITYPE_H */
