.\" t
.\" @(#)WinList.1	12/10/98
.TH WinList 1.6 "Dec 10 1998"
.UC
.SH NAME
\fBWinList\fP \- the AfterStep window list module

.SH SYNOPSIS
\fBWinList\fP is spawned by afterstep, so no command line invocation
will work.
.sp
.fi
From within an \fIafterstep\fP menu file by 'WinList':
.nf
.sp
% cat "~/GNUstep/Library/AfterStep/start/Modules/WinList"
	Module "WinList" WinList
	MiniPixmap "mini-as.xpm"
.fi

To stop the \fBWinList\fP module, a menu item can be used:
.nf
.sp
% cat "~/GNUstep/Library/AfterStep/start/Modules/WinList_Stop"
	KillModuleByName "Stop WinList" WinList
	MiniPixmap "mini-as.xpm"
.fi

.SH DESCRIPTION
The \fBWinList\fP module provides a window list made up of buttons, each
corresponding to a window that AfterStep is managing.  Clicking on the
buttons with any of the three mouse buttons will either do a default
action or can be user configured by editing the \fIwinlist\fP file.

.SH INITIALIZATION
During initialization, \fBWinList\fP will search a configuration file
which describes the colors, font, actions to take on mouse clicks, and
geometry settings to use. The configuration file is
/usr/local/share/afterstep/winlist; but can be overriden by
~/GNUstep/Library/AfterStep/winlist .

If the \fBWinList\fP executable is linked to another name, ie 'ln -s
\fBWinList\fP \fBOtherWinList\fP', then another module called
\fBOtherWinList\fP can be started, with a completely different set of
configurations than \fBWinList\fP, simply by adding \fI*OtherWinList\fP
options following the same \fI*WinList\fP configuration options below to the
\fIwinlist\fP file. This way multiple Identify programs can be used.

.SH INVOCATION
\fBWinList\fP can be invoked from the \fIautoexec\fP file or from a menu
item as shown in the Synopsis section above.

\fBWinList\fP can also be invoked from binding "Module WinList
\fIargument\fP" to a keystroke or mouse button using \fITransient\fP as an
argument which will cause \fBWinList\fP to resemble the built-in window
list.

AfterStep will search through the directories specified in the
\fIModulePath\fP configuration in the \fIbase.#bpp\fP (where # is your
colordepth) to attempt to locate WinList.

.SH CONFIGURATION OPTIONS
\fBWinList\fP reads the \fIwinlist\fP file when it starts up, and looks
for its configuration options

.IP "*WinListGeometry \fIgeometry\fP"
Specifies the location and gravity of the WinList window.  At the current
time, size is not supported and WinList will resize itself as buttons are
added.  If the NoAnchor option is not specified then the window's gravity
corner will be anchored, and the window will grow in the opposite direction.
(i.e. If the geometry is specified -5-5, that is SoutEastGravity.  This will
cause the window to draw up and to the left as windows are added)

.IP "*WinListFont \fIfont\fP"
Specifies the font to be used for labeling the buttons.

.IP "*WinListFore \fIcolor\fP"
Specifies the color to use for the button names.

.IP "*WinListBack \fIcolor\fP"
Specifies the color for the buttons.

.IP "*WinListUseSkipList"
Tells \fBWinList\fP to not show the windows that are have
\fIWindowListSkip\fP as a \fIStyle\fP option in the \fdatabase\fP file.

.IP "*WinListNoAnchor"
By default, \fBWinList\fP will anchor the gravity corner so the window will
grow in the opposite direction.  This undoes that option.

.IP "*WinListUseIconNames"
Tells WinList to use the icon name of the window instead of the full window
name.  This is useful to keep the width of the window small.

.IP "*WinListAction \fIaction response[,reponse...]\fP"
Tells WinList to do \fIresponse\fP when \fIaction\fP is done.  The
currently supported \fIaction\fPs are: Click1, Click2, Click3.  The
currently supported \fIresponse\fPs are any AfterStep built-in commands,
including modules and functions.

.IP "*WinListOrientation \fIdown|across\fP"
Will make a vertical or horizontal winlist.

.IP "*WinListMaxWidth \fIwidth in pixel\fP"
Sets either maxwidth for a vertical winlist or the actual width for a
horizontal "taskbar".

.IP "*WinListLeftJustify"
If used, will justify the text to the left. If unspecified, the default is
to center text.

.SH FILES

.IP \fI/usr/local/share/afterstep/winlist\fP
The global configuration file for system wide defaults of all users.

.IP \fI$HOME/GNUstep/Library/AfterStep/winlist\fP
This file should be copied from the \fI/usr/local/share/afterstep/winlist\fP and edited to suit the user's specific requirements.  This file, if exists, will override the system wide default file.

.SH EXAMPLES
The \fIwinlist\fP file shipped contains a working example, refer to the
\fBFILES\fP section above for its configuration options.

.sp
To pop up the window list in tranient mode (appear only when button 3 is
pressed & held):
.sp
	...the \fIfeel\fP file would contain \-
.nf
	Mouse 3  R  A  Module "WinList" WinList Transient
.sp
.fi

.SH AUTHORS
Rene Fichter <ceezaer@cyberspace.org>
.nf
Mike Finger <mfinger@mermaid.micro.umn.edu>
.nf
avid Mihm <davemann@ionet.net> [Man page]

.SH SEE ALSO
.BR afterstep (1),
