/*
 * Copyright (c) 1997 Guylhem Aznar <guylhem@oeil.qc.ca>
 * Copyright (c) 1994 Mike Finger <mfinger@mermaid.micro.umn.edu>
 *                    or <Mike_Finger@atk.com>
 * Copyright (c) 1994 Robert Nation
 * Copyright (c) 1994 Nobutaka Suzuki
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "../../configure.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <sys/time.h>

#include "../../include/aftersteplib.h"

#ifdef BROKEN_SUN_HEADERS
#include "../../include/sun_headers.h"
#endif

#ifdef NEEDS_ALPHA_HEADER
#include "../../include/alpha_header.h"
#endif /* NEEDS_ALPHA_HEADER */

extern char *MyName;

/******************************************************************************
  saferealloc - safely reallocate memory or exit if fails. (Doesn't work right)
******************************************************************************/
char *
saferealloc (char *ptr, int length)
{
  char *newptr;

  if (length <= 0)
    length = 1;

  newptr = realloc (ptr, length);
  if (ptr == (char *) 0)
    {
      fprintf (stderr, "%s:realloc failed", MyName);
      exit (1);
    }
  return ptr;
}

void
UpdateString (char **string, char *value)
{
  if (value == NULL)
    return;
  if (*string == NULL)
    *string = (char *) safemalloc (strlen (value) + 1);
  else
    *string = (char *) realloc (*string, strlen (value) + 1);
  strcpy (*string, value);
}
