#define IN_MODULE
#include "../../include/afterstep.h"
#include "../../include/screen.h"

#undef StickyIcons


typedef struct pager_window 
{
  char *t;
  Window w;
  Window frame;
  int x;
  int y;
  int width;
  int height;
  int desk;
  int frame_x;
  int frame_y;
  int frame_width;
  int frame_height;
  int title_height;
  int border_width;
  int icon_x;
  int icon_y;
  int icon_width;
  int icon_height;
  Pixel text;
  Pixel back;
  unsigned long flags;
  Window icon_w;
  Window icon_pixmap_w;
  char *icon_name;
  Window PagerView;        /* window to be shown in Pager desk window */
  Window IconView;         /* window to be shown in iconized Pager */

  struct pager_window *next;
} PagerWindow;

typedef struct pager_view_position
{
  int normal_x, normal_y, normal_width, normal_height ;
  int icon_x, icon_y, icon_width, icon_height ;
}PagerViewPosition ;

typedef enum pager_backgr_type
{
  backgrUseXPM = 0,
  backgrScaleRoot,
  backgrSameAsRoot

} BackgroundType;

typedef struct filed_image
{
  Pixmap pixmap ;
  char*  filename;
  char*  LoaderArgs ;  
  int    in_use ;        /*number of objects using it*/
} FiledImage ;


typedef struct desk_info 
{
  Window w;
  Window title_w;
  Window CPagerWin[4];
  int x;
  int y;
  char *label;
  
  BackgroundType PagerBackType ;
  int RootBack, PagerBack ;
  
  char* LoaderArgs ;

  int FastBackgroundOn ;
  unsigned int tile_hsize;
  unsigned int tile_vsize;
  
} DeskInfo;

typedef struct pager_info
{
  Window Pager_w;

#ifdef PAGER_BACKGROUND

#define BACKS_NUM                        ((Pager.ndesks*2)+1)
#define SMALL_FILE_NAME_EXT              ".%ux%u.as.xpm"
#define SMALL_FILE_NAME_EXT_MAX_LEN      32

  char* XImageLoaderApp ;
  char* XImageLoaderArgs ;

  FiledImage* Backgrounds ;
#endif

  DeskInfo *Desks;
  PagerWindow *Start;
  PagerWindow *FocusWin;

  int desk1, desk2, ndesks;
  int Rows, Columns;
  int PageRows, PageColumns ;
  int xSize, ySize ; /* x and y size of desktop */

} PagerInfo;

extern int StickyIcons;
extern PagerInfo Pager ;


#ifdef PAGER_BACKGROUND
#define PAGER_PIXMAP     Pager.Backgrounds[Pager.Desks[Desk].PagerBack].pixmap
#define ROOT_PIXMAP      Pager.Backgrounds[Pager.Desks[Desk].RootBack].pixmap

#define PAGER_FILENAME   Pager.Backgrounds[Pager.Desks[Desk].PagerBack].filename
#define ROOT_FILENAME    Pager.Backgrounds[Pager.Desks[Desk].RootBack].filename
#endif

#define ON  1
#define OFF 0

/*************************************************************************
 *
 * Subroutine Prototypes
 * 
 *************************************************************************/
void Loop(int *fd);
void SendInfo(int *fd,char *message,unsigned long window);
void DeadPipe(int nonsense);
void process_message(unsigned long type,unsigned long *body);
void ParseOptions(const char *filename);
void ParseBaseOptions(const char *filename);

void list_add(unsigned long *body);
void list_configure(unsigned long *body);
void list_destroy(unsigned long *body);
void list_focus(unsigned long *body);
void list_toggle(unsigned long *body);
void list_new_page(unsigned long *body);
void list_new_desk(unsigned long *body);
void list_new_background(unsigned long *body);
void list_raise(unsigned long *body);
void list_lower(unsigned long *body);
void list_unknown(unsigned long *body);
void list_iconify(unsigned long *body);
void list_deiconify(unsigned long *body);
void list_window_name(unsigned long *body);
void list_icon_name(unsigned long *body);
void list_class(unsigned long *body);
void list_res_name(unsigned long *body);
void list_end(void);
int My_XNextEvent(Display *dpy, XEvent *event);

#ifdef PAGER_BACKGROUND
/* Stuff in background.c */
void InitXImageLoader();
void SetXImageLoaderArgs(char* args);
void InitDeskBackgrounds( long Desk );
void InitBackgrounds();
void SetPagerBackground(long Desk);
void MakeBackgrounds( long Desk );
void CheckAndGrabRootPixmap( long Desk );
int IfRootPixmap( long Desk );
int SetERootPixmap( long Desk );
void DrawRoot( long Desk );
void BackgroundChanged( long Desk );
void SetBackgroundType(long Desk, char* params );
void SetRootPixmap(long Desk, char *xpmFile);
void SetPagerPixmap(long Desk, char *xpmFile);
int ScalePagerBackground( long Desk );
void SetFastBackground( long Desk, char* params );

/* Stuff in x_scale.c */
Pixmap ScalePixmapToWin( Pixmap src, Drawable to_win, unsigned int to_depth );
#endif

/* Stuff in x_pager.c */
void InitDesk( long Desk );
void initialize_pager(void);
Pixel GetColor(char *name);
void nocolor(char *a, char *b);
void DispatchEvent(XEvent *Event);
void DisplayFrame( long Desk );
void LowerFrame( long Desk );
void HideFrame( long Desk );
void DestroyView( PagerWindow* t );
void ReConfigure(void);
void ReConfigureAll(void);
void MovePage(void);
void DrawGrid(int i,int erase);
void DrawIconGrid(int erase);
void SwitchToDesk(int Desk);
void SwitchToDeskAndPage(int Desk, XEvent *Event);
void AddNewWindow(PagerWindow *prev);
void MoveResizePagerView(PagerWindow *t);
void ChangeDeskForWindow(PagerWindow *t,long newdesk);
void MoveStickyWindow(void);
void MapBalloonWindow(XEvent *);
void UnmapBalloonWindow(void);
void DrawInBalloonWindow(void);
void Hilight(PagerWindow *, int);
void Scroll(int Desk, int x, int y);
void MoveWindow(XEvent *Event);
void LabelWindow(PagerWindow *t);
void LabelIconWindow(PagerWindow *t);
void ReConfigureIcons(void);
void IconSwitchPage(XEvent *Event);
void IconScroll(int x, int y);
void IconMoveWindow(XEvent *Event,PagerWindow *t);
void HandleExpose(XEvent *Event);
void MoveStickyWindows(void);


#ifdef BROKEN_SUN_HEADERS
#include "../../afterstep/sun_headers.h"
#endif


