//<copyright>
//
// Copyright (c) 1993
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>
//
// Note: this file is a modified version of one of the InterViews example
// programs

/*
 * imgview.C - tiff raster image viewer
 *
 * created:  3 May 1993
 *
 * changed:  1 Jun 1993
 */


#include "imgview.h"
#include "delhand.h"

#include <IV-look/kit.h>
#include <InterViews/action.h>
#include <InterViews/image.h>
#include <InterViews/layout.h>
#include <InterViews/patch.h>
#include <InterViews/style.h>
#include <InterViews/tformsetter.h>
#include <InterViews/tiff.h>
#include <InterViews/window.h>

#include <iostream.h>


static ApplicationWindow* imvdlgwin = 0;
static TransformFitter* fitter = 0;
static Patch* imvpatch = 0;

/*
class CloseAction: public Action
{
  public:
    void setwin (ApplicationWindow* win)
    { win_ = win; }

    void execute ();

  private:
    ApplicationWindow* win_;
};


void CloseAction::execute ()
{ if (win_)
  { cerr << "unmapping" << endl;
    win_->unmap ();  // unmap the dialog window // Bus error (core dumped)!
    cerr << "unbinding" << endl;
    win_->unbind ();  // IV-bug
    cerr << "done" << endl;
  }
}
*/


void showimage (const char* image)
{
  Raster* r = TIFFRaster::load (image);
  if (!r)
  { cerr << "error: open tiff image " << image << " failed" << endl;
    return;
  }

  if (!imvdlgwin)  // create window on first call
  {
    WidgetKit& kit = *WidgetKit::instance ();
    const LayoutKit& layout = *LayoutKit::instance ();
  
    Style* imvstyle = new Style (kit.style ());
    imvstyle->attribute ("name", "Hyper-G Image Viewer");  // Title
    imvstyle->attribute ("iconName", "Hyper-G Image");
/*
    CloseAction* closeaction = new CloseAction;
    Menu* menubar = kit.menubar ();
    MenuItem* menuitem = kit.menubar_item ("Quit");
    menuitem->action (new CloseAction);
    menubar->append_item (menuitem);
*/

    fitter = new TransformFitter (nil);  // (imvimage)
    imvpatch = new Patch (fitter);

    imvdlgwin = new ApplicationWindow (
	kit.outset_frame (
	  layout.variable_span (
	    imvpatch
	  )
	)
    );

//    closeaction->setwin (imvdlgwin);
    imvdlgwin->style (imvstyle);

    // delete handler
    SDeleteHandler* delhandler = new SDeleteHandler;
    imvdlgwin->wm_delete (delhandler);
  }

  Image* imvimage = new Image (r);
  fitter->body (imvimage);

  imvpatch->redraw ();
/*
  imvpatch->reallocate ();  // ?!
  imvpatch->redraw ();
*/
  imvdlgwin->map ();
}
