/*
 * rpm2html.h : general resources about rpm2html
 *
 * Copyright (c) 1997 Daniel Veillard <veillard@apocalypse.org>
 * See COPYING for the status of this software.
 *
 * $Id: rpm2html.h,v 1.24 1998/02/27 20:28:29 veillard Exp $
 */

#ifndef __RPM2HTML_H__
#define __RPM2HTML_H__

/*
 * General setup default values overriden by config file.
 */
#define RPM2HTML_NAME	"rpm2html"
#define RPM2HTML_VER	"0.70p1"
#define RPM2HTML_URL    "http://rufus.w3.org/linux/rpm2html/"
#define RPM2HTML_MAINT	"Daniel Veillard"
#define RPM2HTML_MAIL 	"veillard@w3.org"

/*
 * Constants.
 */

#define MAX_COLOR_PER_LINE	4
#define MAX_TABLE_LENGHT	20
#define MAX_PAGE_LENGHT		250
#define PACKAGE_FIELD_WIDTH	250
#define DESCRIPTION_FIELD_WIDTH	450
#define SYSTEM_FIELD_WIDTH	75
#define MAX_EXTRA_HEADERS	10

/*
 * Unmodifiable variables.
 */
extern char *rpm2html_rpm2html_name;
extern char *rpm2html_rpm2html_ver;
extern char *rpm2html_rpm2html_url;
extern char *rpm2html_rpm2html_thishost;

/*
 * global variables.
 */
extern char *rpm2html_maint;
extern char *rpm2html_mail;
extern char *rpm2html_dir;
extern char *rpm2html_name;
extern char *rpm2html_url;
extern char *rpm2html_ftp;
extern char *rpm2html_ftpsrc;
extern char *rpm2html_host;

extern int   rpm2html_files;
extern int   rpm2html_size;
extern int   rpm2html_install_files;
extern int   rpm2html_install_size;

extern char *rpm2html_headers_name[MAX_EXTRA_HEADERS];
extern char *rpm2html_headers_url[MAX_EXTRA_HEADERS];
extern int   rpm2html_nb_extra_headers; 

extern int   verbose;
extern int   force;

extern int readConfigFile(char *filename);
extern void reinitialize(void);
extern char *strdupHTML(const char *str);

#endif /* __RPM2HTML_H__ */
