<?php

/*
  
  File: problem.php3
  $Author: bjn $
  $Revision: 2.1.2.13 $
  $Date: 2000/11/06 20:18:15 $
  
  HORDE: Copyright 1999 Charles J. Hagenbuch <chuck@horde.org>
  
  You should have received a copy of the GNU Public
  License along with this package; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
*/


/* Obtain the date offset. Thanks to Javier Kohen <jkohen@tough.com>
 * for fixing this for wrap-around
 */
function gm_offset () {
  $date = date('H');
  $gmdate = gmdate('H');
  /* Adjust for wrap-around, the difference can't be more than 12 hours.
   * AFAIK, -1200 is invalid, the correct one is +1200 (ie: at New Zealand).
   */
  if ($gmdate + 12 < $date) {
    $gmdate += 24;
  } else if ($date + 12 <= $gmdate) {
    $date += 24;
  }
  $offset = $date - $gmdate;
  if ($offset >= 0) {
    return sprintf("+%02d", $offset) . "00";
  } else {
    return sprintf("-%02d", -$offset) . "00";
  }
}

/* Send the browser back to the correct page */
function return_to_page () {
  global $this_client, $return_url, $sess;
  if (isset($return_url)) {
    if (!$this_client->lynx ) {
      echo "<script language=\"JavaScript\">window.location=\"" . $sess->url($return_url) . "\"</script></body></html>";
    } else {
      header("Location: " . $return_url);
    }
  } else {
    if (!$this_client->lynx ) {
      echo "<script language=\"JavaScript\">window.location=\"login.php3\"</script></body></html>";
    } else {
      header("Location: index.php3");
    }
  }
  exit;
}

$need_horde_db = 1;
$db_lib_loaded = 0;
require './lib/horde.lib';    /* Horde lib is the HORDE function library  */
require './config/horde.php3';
require './lib/version.php';

/* Html styles configuration */
require './config/html.php3';
require './config/mime.php3';
require './config/lang.php3';

require './lib/mime.lib';                  /* Mime lib for composing mime messages */
$language = select_lang();
require "./locale/$language/problem.lang";
require "./locale/local/problem.lang";

/* Setup the this_client object */
$this_client = new WebClient;

page_open(array('sess' => 'HordeSession'));
page_close();

error_reporting($default->error_level);      /* set error level from imp.lib   */

if (!empty($message)) $message = stripSlashes($message);
if (!empty($subject)) $subject = stripSlashes($subject);
if (!empty($email)) $email = stripSlashes($email);
if (!empty($name)) $name = stripSlashes($name);
if (!empty($phone)) $phone = stripSlashes($phone);

/* array to translate string actions into the appropriate integer ID */
if (!$this_client->lynx) {
  $actions[$lang->button_send]   = SEND_MESSAGE;
  $actions[$lang->button_cancel] = NO_ACTION;
} else {
  if (!empty($actionID)) {
    if ($actionID == $lang->button_send) { $actionID = SEND_MESSAGE; }
  } else {
    $actionID = NO_ACTION;
  }
}

/* Run through action handlers */

$ACTION_TEXT = '';
if (isset($actionID)) {
  /* translate non-int values into the correct int */
  if (strcspn($actionID, '0123456789')) { $actionID = $actions[$actionID]; }
  
  switch ($actionID) {
    
  case SEND_MESSAGE:
    if ($subject && $name && $email && $phone && ($message != "q")) { // need to check to make sure the other parts are there as well
      $msg_prefix = " Name: " . $name . "\n";
      $msg_prefix = $msg_prefix . "Phone: " . $phone . "\n";
      $msg_prefix = $msg_prefix . "Email: " . $email . "\n\n";

      $message = $msg_prefix . $message;
      $message = str_replace("\r\n", "\n", $message);
      $mime = new MimeMessage($message);
      
      $text_part = new mime_part;
      $text_part->type = 'text';
      $text_part->subtype = 'plain';
      $text_part->contents = wrap_message($message, 80, "\n");
      
      /* add footer to text_part */
      $mime->add_begin_part($text_part);
      $msg = $mime->generate();
      
      $envelope['Message-ID'] = '<' . uniqid(time() . '.') . '@' . $SERVER_NAME . '>';
      $envelope['Date'] = date("D, d M Y H:i:s ") . gm_offset();
      $envelope['To'] = $default->problem_email;
      $emailparts = explode('@', $email);
      $envelope['From'] = imap_rfc822_write_address($emailparts[0], $emailparts[1], $name);
      $recipients = $default->problem_email;
      $envelope['Subject'] = $lang->problem_subject . $subject;
      $envelope = $mime->header($envelope);
      $envelope['User-Agent'] = 'HORDE/PHP3 ' . HORDE_VERSION;
      
      /* hack to work with the mailfrom function depending on imp; this is fixed in 2.3 */
      class tempOb {
      }
      $imp = new tempOb;
      $imp->server = 'localhost';
      $imp->user = 'horde-problem';
      $imp->from_server = 'localhost';
      
      if (mailfrom($recipients, $envelope, $msg)) {
	return_to_page();
      } else {
	$ACTION_TEXT = $lang->action_compose;
      }
    } else {
      /* something wasn't quite right. strange */
      $ACTION_TEXT = $lang->action_compose;
      status($lang->status_error_required_field);
    }
    break;
    
  case NO_ACTION:
  default:
    return_to_page();
    break;
  }
} else { $ACTION_TEXT = $lang->action_compose; }
if (!isset($status_sent)) { status($lang->status_composition); }

$title = $lang->status_composition;
$sidebar = false;
require "$default->horde_include_dir/generic-header.inc";

$from = 'horde-problem@localhost';
$barefrom = 'horde-problem@localhost';
if (!isset($message)) { $message = ''; }
if (!isset($subject)) { $subject = ''; }
if (!isset($email))   { $email   = ''; }
if (!isset($name))    { $name    = ''; }
if (!isset($phone))   { $phone   = ''; }


if (!$this_client->lynx) {
  include "$default->horde_include_dir/problem/problem.inc";
} else {
  include "$default->horde_include_dir/problem/lynx_problem.inc";
}

require "$default->horde_include_dir/generic-footer.inc";
if (!$this_client->lynx) {
  include "$default->horde_include_dir/problem/javascript.inc";
}

?>
