# $Horde: horde/scripts/database/mysql_create.sql,v 1.1.2.10 2000/09/21 15:31:01 bjn Exp $
#
# You can simply direct this file to mysql as STDIN:
# $ mysql (user/pass/host args) < mysql_create.sql

CONNECT mysql;

REPLACE INTO user ( host, user, password )
    VALUES (
        'localhost',
        'hordemgr',
        password('hordemgr')
    );

REPLACE INTO db ( host, db, user, select_priv, insert_priv, update_priv,
                  delete_priv, create_priv, drop_priv )
    VALUES (
        'localhost',
        'horde',
        'hordemgr',
        'Y', 'Y', 'Y', 'Y',
        'Y', 'Y'
    );

# MySQL 3.23.x appears to have "CREATE DATABASE IF NOT EXISTS" and
# "CREATE TABLE IF NOT EXISTS" which would be a nice way to handle
# reinstalls gracefully (someday).  For now, use mysql_drop.sql first
# to avoid CREATE errors.

CREATE DATABASE horde;
CONNECT horde;

# NOTE: everything between these lines should compare identical to:
# $ mysqldump (user/pass/host args) --no-data horde
# ======================================================================

#
# Table structure for table 'active_sessions'
#
CREATE TABLE active_sessions (
  sid varchar(32) DEFAULT '' NOT NULL,
  name varchar(32) DEFAULT '' NOT NULL,
  val text,
  changed varchar(14) DEFAULT '' NOT NULL,
  PRIMARY KEY (name,sid),
  KEY changed (changed)
);

#
# Table structure for table 'imp_addr'
#
CREATE TABLE imp_addr (
  user varchar(120) DEFAULT '' NOT NULL,
  address varchar(120) DEFAULT '' NOT NULL,
  nickname varchar(255),
  fullname varchar(255),
  PRIMARY KEY (user,address)
);

#
# Table structure for table 'imp_pref'
#
CREATE TABLE imp_pref (
  user varchar(120) DEFAULT '' NOT NULL,
  fullname varchar(70),
  replyto varchar(70),
  lang varchar(30),
  sig text,
  PRIMARY KEY (user)
);

# ======================================================================
# end of table definitions

FLUSH PRIVILEGES;

# done!
