package HNS;
################################################################
# HNS : total management of HNS
#
# usage:
# my $hns = new HNS;
# $hns->Read($y, $m, $d);
# # $hns->Read;                # recent
# $hns->Print;
#
# $Id: HNS.pm,v 1.18.2.6 2000/02/18 11:04:44 kenji Exp $
################################################################
use strict;
use ObjectTemplate;
@HNS::ISA = qw(ObjectTemplate);

use SimpleDB::Scalar;                # for lastModified, head.txt, foot.txt
use SimpleDB::Append;                # for Append Log
use DateTime::Format;                # for LastModified
use HNS::Calendar::Table;            # must be 'use' not 'require'
use HNS::Calendar::NoTable;          # 'cause static variable may be change
use HNS::Template;
use HNS::System;
use HNS::Collection;
use HNS::Status;
use HNS::ExtHTML;
use HNS::Style;
################################################################
attributes qw(); # status);

use vars qw($VERSION $PUBLIC_VERSION %VersionMessages $HnsHomePage $Status);
$VERSION = "2.00-pl4";
$PUBLIC_VERSION = "2.00-pl4";

$HnsHomePage = "http://www.h14m.org/";

%VersionMessages =
    ('Public' => q(hns - Hyper NIKKI System - Version %public),
     'NonPublic' => qq(<font color=red>Attention:</font>
		       current version is %current,
		       public released version is %public.));

################################################################
sub initialize($)
{
    my $self = shift;
#    $self->status(new HNS::Status);
    $HNS::Status = new HNS::Status;
}
################################################################
# public:
sub Print($$) #($$$$$)
{
#    my ($self, $col, $year, $month, $day) = @_;
    my ($self, $col) = @_;

    ################################################################
    # last modified
    my $last_modified;
    tie $last_modified, 'SimpleDB::Scalar', "$HNS::System::DiaryDir/log/LastModified";

    if ($last_modified < $col->last_modified){
	$last_modified = $col->last_modified;
    }
    ################################################################
    # Header
    # HTTP header;
    if ($ENV{'SCRIPT_NAME'}){
	my $echo_lm = strftime("%a, %d %b %Y %H:%M:%S %Z",
			       gmtime($last_modified));
	
	print "content-type: text/html\n";
	print "last-modified: $echo_lm\n";
	$HNS::Status->PrintCookieHeader
	    if ($HNS::System::RefererLog eq 'ON' &&
		$HNS::System::CookieFlag eq 'ON' &&
		!$HNS::Status->is_robot);
	print "\n";
    }
    # <header>
    print $HNS::ExtHTML::DOCTYPE;
    print qq(<html>\n<head>\n);
    print qq(<meta http-equiv="content-type" content="text/html; charset=EUC-JP">\n);
    print qq(<base href="$HNS::System::MyDiaryURI">\n);
    print qq(<link rev="made" href="mailto:$HNS::System::UserMail">\n);
    print qq(<!-- HOSHINO_ANTENNA_REGIST $HNS::System::HoshinoAntenna -->\n);
    print $HNS::ExtHTML::Head;
    print qq(<title>$HNS::System::Title</title>\n);
    print qq(</head>\n\n);
    
    ################################################################
    # Content
    # <body> start
    print qq(<body $HNS::ExtHTML::BodyVal>\n);
    print "<!-- START TIME " . $col->start_time . "-->\n";
    my $head_txt;
    tie $head_txt, 'SimpleDB::Scalar', "$HNS::System::DiaryDir/conf/head.txt", 1;
    print $head_txt;
    my $func = $HNS::ExtHTML::DynamicPrintFunc;
    &$func if ref $func;
    
    # print version
    {
	my $template = ($VERSION eq $PUBLIC_VERSION) ?
	    $VersionMessages{'Public'} :
		$VersionMessages{'NonPublic'};
	
	my $templ = new HNS::Template;
	print $templ->Expand($template, {public=>$PUBLIC_VERSION,
					 current=>$VERSION,
					 homepage=>$HnsHomePage});
    }
    # print head style
    my $style = new HNS::Style(col=>$col);
    $style->PrintHead;
    # diary content
    $col->Print;
    # elasp time
    print "<!-- END TIME " . $col->end_time . "-->\n";
    my $elapse_time = $col->end_time - $col->start_time;
    print "<!-- ELAPSE TIME $elapse_time -->\n";

    ################################################################
    # Foot
    $style->PrintFoot;
    
    # HNS Copyright
    printf(qq(
	<div align="right"><a href="%s">hns-%s</a>, 
	Copyright (c) by
	<a href="%s">HyperNikkiSystem Project</a>
	1998-2000
	</div>
	<hr>),
	$HnsHomePage, $VERSION, $HnsHomePage);

    # foot message
    my $foot;
    tie $foot, 'SimpleDB::Scalar', "$HNS::System::DiaryDir/conf/foot.txt";
    print $foot;
    print qq(</body>\n</html>\n);
}    
################################################################
sub RecordLog ($;$$)
{
    my ($self,  $ref, $to) = @_;
    # referer log
    if ($HNS::System::RefererLog eq 'ON'){
	my $referer_log = new SimpleDB::Append("$HNS::System::DiaryDir/log/referer_log");
	$referer_log->Append($HNS::Status->AsRefererLog);
    }
    # link log
    if ($HNS::System::LinkLog eq 'ON' && ($ref && $to)){
	my $link_log = new SimpleDB::Append("$HNS::System::DiaryDir/log/link_log");
	$link_log->Append("$to $ref\n");
    }
}

1;
# end of HNS.pm
################################################################
