#ifndef ___ARENA_TOOLBAR_H___
#  define ___ARENA_TOOLBAR_H___


#include "toolbar_types.h"
#include "types.h"

#include <X11/Xlib.h>


/*
 * Global variables.
 */
extern Window ToolBarWin;
extern     GC ToolBarGC;


/*
 * Functions.
 */

Bool ToolBarInit(Window parent_win);

void DisplayStatusLine_withLabel(char* theLabel);

void PaintVersion(void);
void PaintLabel(char* Label, unsigned long Colour);

Bool       SetToolBarButtonPosition(int button_number, int x, int y);
XRectangle GetToolBarButtonGeometry(int button_number);

void SetToolBarFont(XFontStruct *pf);

Bool    UpdateToolBarGeometry(void);
XRectangle GetToolBarGeometry(void);

Bool DrawToolBarButton(Arena_ButtonState buttonState, int buttonNumber);

void DisplayToolBar(void);

void ToolBarButtonUp(unsigned int MBp, int x, int y);
int  ToolBarButtonDown(unsigned int MBp, int x, int y);

void SaveDoc(char *file);


#ifdef ARENA_FLYBY_HELP
typedef struct _flyby_button_data
{
 char *name;            /* should match one of the button names in toolbar.c */
 int displayed_times;   /* simple counter of # times THIS one has been shown */
 char *hint;            /* i10n text of button (very short hint)             */
 char *terse;           /* "terse" hint                                      */
 char *verbose;         /* "verbose hint... Not too verbose please!          */
} FlyByButtonData;

/* Toolbar Flyby Help routines */
int ToolBarWhichButton(int x, int y);
char *ToolBarFlyByText(int buttonNumber);
#endif  /* ifdef ARENA_FLYBY_HELP */



#endif	/* ifndef ___ARENA_TOOLBAR_H___ */

