/* howcome 11/10/94 */

#include <stdio.h>
#include <stdarg.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/keysym.h>


#include "arena.h"
#include "bridge.h"
#include "colour.h"
#ifdef ARENA_DEBUG	/* QingLong.24-01-97 */
#  include "debug.h"
# else
#  include "error.h"
#endif
#include "gif_arena.h"
#include "icon_i.h"
#include "image.h"
#include "main.h"
#include "status.h"
#include "toolbar.h"
#include "util.h"
#include "x11.h"
#include "xpm_arena.h"

#include "iconArena.xpm"

#include "HTUtils.h"	/* WWW general purpose macros */
#include "HTList.h"
#include "HTAccess.h"
#include "HTFormat.h"


Image* ArenaIconImage = NULL;

Window IconWin = None;
GC     IconGC  = NULL;


Image* LoadIcon (void)
{
 extern HTFormat xpm_atom;
 extern Image* ArenaIconImage;
#ifdef ARENA_DEBUG
 char Iam[] = "LoadIcon";
#endif


 if (ArenaIconImage) return ArenaIconImage;


 if (Icon)
   {
    HTAnchor* a = NULL;
    Doc* d = NULL;

#ifdef ARENA_DEBUG	/* QingLong.24-01-97 */
    Arena_TracePrint(Iam, " sorry, customized icons temporarily disabled.\n");
#endif
    a = libGetDocument(Icon, Arena_StrLen(Icon), NULL,
		       False, True, False, False, True);
    d = (Doc*)HTAnchor_document(HTAnchor_parent(a));

    if (d)
      if (d->content_buffer)
	if (ProcessLoadedImage(d) != FAILURE)
	  {
	   ArenaIconImage = d->image;
	   d->image = NULL;   /* Cut the image from the doc! */
	   DocDel(d);   /* Delete the doc */
	  }
   }

 if (ArenaIconImage)
   {
    ArenaIconImage->next = NULL;	/* to avoid freeing amongst others */
   }
  else
   {
    if (xpm_atom)
      {
       ArenaIconImage = NewImage();
       if (ArenaIconImage)
	 {
	  ImageXyoke* theIconImageXcouple;

	  ArenaIconImage->url  = NULL;
	  ArenaIconImage->next = NULL;
	  ArenaIconImage->npixels = 0;

	  theIconImageXcouple = ProcessXPM(iconArena, depth);

	  if (theIconImageXcouple)
	    {
	     XprocessLoadedImage(theIconImageXcouple, ArenaIconImage);
	     FreeImageXyoke(theIconImageXcouple);
	    }
	 }
      }
#ifdef ARENA_DEBUG
     else
      {
       if (IMAGE_TRACE)
	 Arena_TracePrint(Iam, " ERROR! XPM atom isn't defined yet.\n");
      }
#endif
   }

 if (ArenaIconImage == NULL)
   {
#ifdef ARENA_DEBUG	/* QingLong.24-01-97 */
    Arena_TracePrint(Iam, " Failed to load image.\n");
# else
    Arena_PrintError(_("Failed to load icon.\n"));
#endif
   }

 return ArenaIconImage;
}


/*
 * Computes Arena icon bar width from the icon image width.
 */
int ArenaIconBarWidth(void)
{
 extern Image* ArenaIconImage;


 if (ArenaIconImage == NULL)
   {
    if ((ArenaIconImage = LoadIcon()) == NULL) return -1;
   }

 return (ArenaIconImage->width +
	 2 * (ICON_BORDER_WIDTH + ARENA_ICON_OUTSET_WIDTH));
}


/* Recomputes icon bar geometry from toolbar and statusbar parameters,
 * returns the updated geometry.
 */
XRectangle GetUpdateArenaIconGeometry(void)
{
 XRectangle theXrectangle = {0, 0, 0, 0};
 int theWidth;


 if ((theWidth = ArenaIconBarWidth()) >= 0)
   {
    theXrectangle = GetToolBarGeometry();


    theXrectangle.width   = (unsigned int)theWidth;
    theXrectangle.x = win_width - theXrectangle.width;
   }

 return theXrectangle;
}


/*
 * Initialize Arena icon stuff: create window and graphic context.
 */
Bool IconInit(Window theWindow)
{
 extern Window IconWin;
 extern GC     IconGC;


 if (theWindow != None && IconWin == None)
   {
    XRectangle  iconBar = GetUpdateArenaIconGeometry();

    IconWin = CreateSubWindow(display, theWindow,
			      iconBar.x, iconBar.y,
			      iconBar.width, iconBar.height,
			      0, windowColour);
   }

 if (IconWin != None && IconGC == NULL)
   IconGC = XCreateGC(display, IconWin, 0, NULL);

 return (IconWin != None && (IconGC));
}


void DisplayIcon()
{
 extern Image* ArenaIconImage;
 XRectangle ArenaIconBarXrectangle;


 if (ArenaIconImage == NULL)
   {
    if ((ArenaIconImage = LoadIcon()) == NULL) return;
   }

 ArenaIconBarXrectangle = GetUpdateArenaIconGeometry();

 if ((ArenaIconBarXrectangle.x      == 0) &&
     (ArenaIconBarXrectangle.y      == 0) &&
     (ArenaIconBarXrectangle.width  == 0) &&
     (ArenaIconBarXrectangle.height == 0))
   return;

 XClearWindow(display, IconWin);

 Arena_PutTransparentImage(display, IconGC,
			   ArenaIconImage->pixmap, ArenaIconImage->mask,
			   IconWin,
			   (ArenaIconBarXrectangle.width -
			    ArenaIconImage->width)/2,
			   (ArenaIconBarXrectangle.height -
			    ArenaIconImage->height)/2,
			   ArenaIconImage->width, ArenaIconImage->height);

 DrawOutSet(IconWin, IconGC,
	    0, 0, ArenaIconBarXrectangle.width, ArenaIconBarXrectangle.height);
}
