#ifndef ___ARENA_FORMS_H___
#  define ___ARENA_FORMS_H___


#include <X11/Xlib.h>

#include "display_types.h"
#include "types.h"
#include "editor.h"
#include "entities.h"
#include "image_types.h"
#include "neweditor.h"

#include "forms_types.h"


/*
 * input field types
 */
#define TEXTFIELD       0x00
#define TEXTAREA        0x10
#define CHECKBOX        0x20
#define RADIOBUTTON     0x30
#define OPTIONLIST      0x40
#define SUBMITBUTTON    0x50
#define RESETBUTTON     0x60
#define HIDDEN          0x70
#define PASSWD          0x80

#define MULTIPLE        0x10    /* multiple selections are allowed */
#define DISABLED        0x20    /* field is greyed out */
#define CHECKED         0x40    /* whether the field is "active" */
#define FIELD_AUX_FLAG	0x80	/* Just an auxilliary flag (context sensed) */

/*
 * select options flags.
 */
#define OPTION_SELECTED 0x10    /* option is initially selected */
#define OPTION_DISABLED 0x20    /* option is greyed out */
#define OPTION_CHECKED  0x40    /* flags option as 'active' */
#define OPTION_AUX_FLAG	0x80	/* Just an auxilliary flag (context sensed) */


/*
 * Global variables. :(
 */
extern Field* focus;   /* which field has focus (NULL if none do) */


/*
 * Functions.
 */

char *strdup2(char *s, int len);
char *strsav(char *s);

void FreeForms(void);
void ScrollForms(long delta);
void ResizeForm(void);
void ProcessTableForm(int pass);

Form*  FindForm(FormSubmitMethod method, char* action);
Form*  FindFormByAction(char* action);

Field* FindField_in_List(Field* fieldList, int type, char *name, int namelen);
Field* FindField(Form* form, int type, char *name, int namelen);
Field* FindFieldFuzzy_in_List(Field* fieldList,
			      int type, char *name, int namelen);
Field* FindFieldFuzzy(Form* form, int type, char *name, int namelen);

Bool ResetForm(GC gc, ViewWindow view_window, Form* form);
void SubmitForm(Form *form,
		FormSubmitMethod method, char *action, int alen, int type,
		char *name, int nlen, char *value, int vlen,
		Image *image, int dx, int dy, char *bufpos);

Form* DefaultForm(void);
Form*  GetForm(FormSubmitMethod method, char *url, int len);
Field* GetField(Form *form, int type, int x, char *name, int nlen,
		char *value, int vlen, int pos, int rows, int cols,
		int maxlength, int flags);

Bool GiveUpFocus(GC gc, ViewWindow view_window,
		 Field** edited_field, EditorBuffer** field_editor);

Bool FinishCurrentFieldEditing(GC gc, ViewWindow view_window);

void AddOption(Field* field, int flags, char* label, int len, char* value);

Bool ClickedInField(GC gc, ViewWindow view_window, int indent, int baseline, Field *field,
		    int x, int y, int event);
Bool ClickedInDropDown(GC gc, ViewWindow view_window, Field *field, int indent, int event,
		       int x, int y);

void PaintCross(GC gc, Window win,
		int x, int y, unsigned int w, unsigned int h);
void PaintTickMark(GC gc, Window win,
		   int x, int y, unsigned int w, unsigned int h);

Bool PaintDropDown(GC gc, ViewWindow view_window, int indent, Field* field);

Bool PaintField(GC gc, ViewWindow view_window, int indent, int baseline, Field *field);

/*
 * Take form editing action in response to keyboard event.
 */
Bool EditDocFormField(GC gc, ViewWindow view_window, Doc* theDocument,
		      KeySym theKeyPressed, char* theString);


#endif /* ifndef ___ARENA_FORMS_H___ */
